/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.ServerCookieEncoder;
import java.util.ArrayList;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;

public class MockServerToNettyResponseMapper {
    public DefaultFullHttpResponse mapMockServerResponseToNettyResponse(HttpResponse httpResponse) {
        if (httpResponse != null) {
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)(httpResponse.getStatusCode() != null ? httpResponse.getStatusCode() : 200)), Unpooled.copiedBuffer((byte[])httpResponse.getBody()));
            this.setHeaders(httpResponse, defaultFullHttpResponse);
            this.setCookies(httpResponse, defaultFullHttpResponse);
            return defaultFullHttpResponse;
        }
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
    }

    private void setHeaders(HttpResponse httpResponse, DefaultFullHttpResponse httpServletResponse) {
        if (httpResponse.getHeaders() != null) {
            for (Header header : httpResponse.getHeaders()) {
                for (String value : header.getValues()) {
                    httpServletResponse.headers().set(header.getName(), (Object)value);
                }
            }
        }
    }

    private void setCookies(HttpResponse httpResponse, DefaultFullHttpResponse httpServletResponse) {
        if (httpResponse.getCookies() != null) {
            ArrayList<String> cookieValues = new ArrayList<String>();
            for (org.mockserver.model.Cookie cookie : httpResponse.getCookies()) {
                for (String value : cookie.getValues()) {
                    cookieValues.add(ServerCookieEncoder.encode((Cookie)new DefaultCookie(cookie.getName(), value)));
                }
            }
            if (!cookieValues.isEmpty()) {
                httpServletResponse.headers().add("Set-Cookie", cookieValues);
            }
        }
    }
}

