/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.RequestDefinition;
import org.mockserver.serialization.model.BodyDTO;

public class HttpRequestPrettyPrintedDTO
extends RequestDefinition {
    private int hashCode;
    private String method = "";
    private String path = "";
    private final Map<String, List<String>> queryStringParameters = new HashMap<String, List<String>>();
    private BodyDTO body = null;
    private final Map<String, String> cookies = new HashMap<String, String>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Boolean keepAlive = null;
    private Boolean secure = null;

    public HttpRequestPrettyPrintedDTO(HttpRequest httpRequest) {
        if (httpRequest != null) {
            this.method = httpRequest.getMethod().getValue();
            this.path = httpRequest.getPath().getValue();
            for (Header header : httpRequest.getHeaderList()) {
                this.headers.put(header.getName().getValue(), header.getValues().stream().map(NottableString::getValue).collect(Collectors.toList()));
            }
            for (Cookie cookie : httpRequest.getCookieList()) {
                this.cookies.put(cookie.getName().getValue(), cookie.getValue().getValue());
            }
            for (Parameter parameter : httpRequest.getQueryStringParameterList()) {
                this.queryStringParameters.put(parameter.getName().getValue(), parameter.getValues().stream().map(NottableString::getValue).collect(Collectors.toList()));
            }
            this.body = BodyDTO.createDTO(httpRequest.getBody());
            this.keepAlive = httpRequest.isKeepAlive();
            this.secure = httpRequest.isSecure();
            this.setNot(httpRequest.getNot());
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, List<String>> getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public BodyDTO getBody() {
        return this.body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    @Override
    public HttpRequestPrettyPrintedDTO shallowClone() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpRequestPrettyPrintedDTO that = (HttpRequestPrettyPrintedDTO)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.path, that.path) && Objects.equals(this.queryStringParameters, that.queryStringParameters) && Objects.equals(this.body, that.body) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.headers, that.headers) && Objects.equals(this.keepAlive, that.keepAlive) && Objects.equals(this.secure, that.secure);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.method, this.path, this.queryStringParameters, this.body, this.cookies, this.headers, this.keepAlive, this.secure);
        }
        return this.hashCode;
    }
}

