/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.model.DTO;
import org.mockserver.client.serialization.model.HttpRequestDTO;
import org.mockserver.client.serialization.model.HttpResponseDTO;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.validator.jsonschema.JsonSchemaHttpRequestValidator;
import org.mockserver.validator.jsonschema.JsonSchemaHttpResponseValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTemplateOutputDeserializer {
    private static ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private static Logger logger = LoggerFactory.getLogger(HttpTemplateOutputDeserializer.class);
    private static LoggingFormatter logFormatter = new LoggingFormatter(logger);
    private JsonSchemaHttpRequestValidator httpRequestValidator = new JsonSchemaHttpRequestValidator();
    private JsonSchemaHttpResponseValidator httpResponseValidator = new JsonSchemaHttpResponseValidator();

    public <T> T deserializer(String json, Class<? extends DTO<T>> dtoClass) {
        T result = null;
        try {
            String validationErrors = "";
            String schema = "";
            if (dtoClass.isAssignableFrom(HttpResponseDTO.class)) {
                validationErrors = this.httpResponseValidator.isValid(json);
                schema = this.httpResponseValidator.getSchema();
            } else if (dtoClass.isAssignableFrom(HttpRequestDTO.class)) {
                validationErrors = this.httpRequestValidator.isValid(json);
                schema = this.httpRequestValidator.getSchema();
            }
            if (StringUtils.isEmpty((CharSequence)validationErrors)) {
                result = ((DTO)objectMapper.readValue(json, dtoClass)).buildObject();
            } else {
                logFormatter.errorLog("Validation failed:{}for:{}against schema:{}", validationErrors, json, schema);
            }
        }
        catch (Exception e) {
            logFormatter.errorLog(e, "Exception transforming json:{}", json);
        }
        return result;
    }
}

