/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.Arrays;
import java.util.List;
import org.mockserver.collections.CaseInsensitiveRegexHashMap;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithJsonToString;

public class KeyAndValue
extends ObjectWithJsonToString {
    private final NottableString name;
    private final NottableString value;

    public KeyAndValue(String name, String value) {
        this(NottableString.string(name), NottableString.string(value));
    }

    public KeyAndValue(NottableString name, NottableString value) {
        this.name = name;
        this.value = value;
    }

    public static CaseInsensitiveRegexHashMap toHashMap(List<? extends KeyAndValue> keyAndValue) {
        CaseInsensitiveRegexHashMap caseInsensitiveRegexHashMap = new CaseInsensitiveRegexHashMap();
        if (keyAndValue != null) {
            for (KeyAndValue keyAndValue2 : keyAndValue) {
                caseInsensitiveRegexHashMap.put(keyAndValue2.getName(), keyAndValue2.getValue());
            }
        }
        return caseInsensitiveRegexHashMap;
    }

    public static CaseInsensitiveRegexHashMap toHashMap(KeyAndValue ... keyToMultiValues) {
        return KeyAndValue.toHashMap(Arrays.asList(keyToMultiValues));
    }

    public NottableString getName() {
        return this.name;
    }

    public NottableString getValue() {
        return this.value;
    }
}

