/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mockserver.model.Action;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Cookie;
import org.mockserver.model.Delay;
import org.mockserver.model.Header;
import org.mockserver.model.NottableString;
import org.mockserver.model.StringBody;

public class HttpResponse
extends Action {
    private Integer statusCode;
    private BodyWithContentType body;
    private Map<NottableString, Header> headers = new LinkedHashMap<NottableString, Header>();
    private Map<NottableString, Cookie> cookies = new LinkedHashMap<NottableString, Cookie>();
    private Delay delay;
    private ConnectionOptions connectionOptions;

    public static HttpResponse response() {
        return new HttpResponse();
    }

    public static HttpResponse response(String body) {
        return new HttpResponse().withStatusCode(200).withBody(body);
    }

    public static HttpResponse notFoundResponse() {
        return new HttpResponse().withStatusCode(404);
    }

    public HttpResponse withStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public HttpResponse withBody(String body) {
        if (body != null) {
            this.body = new StringBody(body);
        }
        return this;
    }

    public HttpResponse withBody(String body, Charset charset) {
        if (body != null) {
            this.body = new StringBody(body, charset);
        }
        return this;
    }

    public HttpResponse withBody(byte[] body) {
        this.body = new BinaryBody(body);
        return this;
    }

    public HttpResponse withBody(BodyWithContentType body) {
        this.body = body;
        return this;
    }

    public BodyWithContentType getBody() {
        return this.body;
    }

    @JsonIgnore
    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    public HttpResponse withHeaders(List<Header> headers) {
        this.headers.clear();
        for (Header header : headers) {
            this.withHeader(header);
        }
        return this;
    }

    public HttpResponse withHeaders(Header ... headers) {
        if (headers != null) {
            this.withHeaders(Arrays.asList(headers));
        }
        return this;
    }

    public HttpResponse withHeader(Header header) {
        if (this.headers.containsKey(header.getName())) {
            this.headers.get(header.getName()).addNottableValues(header.getValues());
        } else {
            this.headers.put(header.getName(), header);
        }
        return this;
    }

    public HttpResponse withHeader(String name, String ... values) {
        if (this.headers.containsKey(NottableString.string(name))) {
            this.headers.get(NottableString.string(name)).addValues(values);
        } else {
            this.headers.put(NottableString.string(name), Header.header(name, values));
        }
        return this;
    }

    public HttpResponse updateHeader(Header header) {
        this.headers.put(header.getName(), header);
        return this;
    }

    public HttpResponse updateHeader(String name, String ... values) {
        this.headers.put(NottableString.string(name), Header.header(name, values));
        return this;
    }

    public List<Header> getHeaders() {
        return new ArrayList<Header>(this.headers.values());
    }

    public List<String> getHeader(String name) {
        ArrayList<String> headerValues = new ArrayList<String>();
        for (NottableString headerName : this.headers.keySet()) {
            if (!headerName.equalsIgnoreCase(NottableString.string(name))) continue;
            for (NottableString headerValue : this.headers.get(headerName).getValues()) {
                headerValues.add(headerValue.getValue());
            }
        }
        return headerValues;
    }

    public String getFirstHeader(String name) {
        List<String> headerValues = this.getHeader(name);
        if (headerValues.size() > 0) {
            return headerValues.get(0);
        }
        return "";
    }

    public boolean containsHeader(String name, String value) {
        for (NottableString headerName : this.headers.keySet()) {
            if (!headerName.equalsIgnoreCase(NottableString.string(name))) continue;
            for (NottableString headerValue : this.headers.get(headerName).getValues()) {
                if (!headerValue.equalsIgnoreCase(value)) continue;
                return true;
            }
        }
        return false;
    }

    public HttpResponse withCookies(List<Cookie> cookies) {
        this.cookies.clear();
        for (Cookie cookie : cookies) {
            this.withCookie(cookie);
        }
        return this;
    }

    public HttpResponse withCookies(Cookie ... cookies) {
        if (cookies != null) {
            this.withCookies(Arrays.asList(cookies));
        }
        return this;
    }

    public HttpResponse withCookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
        return this;
    }

    public HttpResponse withCookie(String name, String value) {
        this.cookies.put(NottableString.string(name), Cookie.cookie(name, value));
        return this;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    public HttpResponse withDelay(Delay delay) {
        this.delay = delay;
        return this;
    }

    public HttpResponse withDelay(TimeUnit timeUnit, long value) {
        this.delay = new Delay(timeUnit, value);
        return this;
    }

    public Delay getDelay() {
        return this.delay;
    }

    public HttpResponse withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonIgnore
    public HttpResponse applyDelay() {
        if (this.delay != null) {
            this.delay.applyDelay();
        }
        return this;
    }

    @Override
    @JsonIgnore
    public Action.Type getType() {
        return Action.Type.RESPONSE;
    }

    public HttpResponse clone() {
        return HttpResponse.response().withStatusCode(this.getStatusCode()).withBody(this.getBody()).withHeaders(this.getHeaders()).withCookies(this.getCookies()).withDelay(this.getDelay()).withConnectionOptions(this.getConnectionOptions());
    }
}

