/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import org.mockserver.character.Character;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.mockserver.callback.ExpectationCallbackResponse;
import org.mockserver.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;
import org.slf4j.LoggerFactory;

public class HttpObjectCallbackActionHandler {
    private LoggingFormatter logFormatter = new LoggingFormatter(LoggerFactory.getLogger(this.getClass()));
    private WebSocketClientRegistry webSocketClientRegistry;

    public HttpObjectCallbackActionHandler(WebSocketClientRegistry webSocketClientRegistry) {
        this.webSocketClientRegistry = webSocketClientRegistry;
    }

    public void handle(final HttpObjectCallback httpObjectCallback, final HttpRequest request, final ResponseWriter responseWriter) {
        String clientId = httpObjectCallback.getClientId();
        this.webSocketClientRegistry.registerCallbackResponseHandler(clientId, new ExpectationCallbackResponse(){

            @Override
            public void handle(HttpResponse response) {
                responseWriter.writeResponse(request, response);
                HttpObjectCallbackActionHandler.this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request:{}" + Character.NEW_LINE + " for action:{}", response, request, httpObjectCallback);
            }
        });
        this.webSocketClientRegistry.sendClientMessage(clientId, request);
    }
}

