/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.model.HttpRequestDTO;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.javascript.JavaScriptTemplateEngine;
import org.mockserver.templates.engine.velocity.VelocityTemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpForwardTemplateActionHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private JavaScriptTemplateEngine javaScriptTemplateEngine = new JavaScriptTemplateEngine();
    private VelocityTemplateEngine velocityTemplateEngine = new VelocityTemplateEngine();
    private NettyHttpClient httpClient = new NettyHttpClient();
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();

    public HttpResponse handle(HttpTemplate httpTemplate, HttpRequest httpRequest) {
        HttpRequest templatedRequest;
        HttpResponse httpResponse = HttpResponse.notFoundResponse();
        TemplateEngine templateEngine = null;
        switch (httpTemplate.getTemplateType()) {
            case VELOCITY: {
                templateEngine = this.velocityTemplateEngine;
                break;
            }
            case JAVASCRIPT: {
                templateEngine = this.javaScriptTemplateEngine;
                break;
            }
            default: {
                throw new RuntimeException("Unknown no template engine available for " + (Object)((Object)httpTemplate.getTemplateType()));
            }
        }
        if (templateEngine != null && (templatedRequest = (HttpRequest)templateEngine.executeTemplate(httpTemplate.getTemplate(), httpRequest, HttpRequestDTO.class)) != null) {
            httpResponse = this.sendRequest(templatedRequest);
        }
        httpTemplate.applyDelay();
        return httpResponse;
    }

    private HttpResponse sendRequest(HttpRequest httpRequest) {
        if ((httpRequest = this.hopByHopHeaderFilter.onRequest(httpRequest)) != null) {
            try {
                return this.httpClient.sendRequest(httpRequest);
            }
            catch (Exception e) {
                this.logger.error("Exception forwarding request " + httpRequest, (Throwable)e);
            }
        }
        return null;
    }
}

