/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import io.netty.channel.ChannelHandlerContext;
import org.mockserver.character.Character;
import org.mockserver.log.model.ExpectationMatchLogEntry;
import org.mockserver.log.model.RequestLogEntry;
import org.mockserver.log.model.RequestResponseLogEntry;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.HttpClassCallbackActionHandler;
import org.mockserver.mock.action.HttpErrorActionHandler;
import org.mockserver.mock.action.HttpForwardActionHandler;
import org.mockserver.mock.action.HttpForwardTemplateActionHandler;
import org.mockserver.mock.action.HttpObjectCallbackActionHandler;
import org.mockserver.mock.action.HttpResponseActionHandler;
import org.mockserver.mock.action.HttpResponseTemplateActionHandler;
import org.mockserver.model.Action;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.responsewriter.ResponseWriter;
import org.slf4j.LoggerFactory;

public class ActionHandler {
    private HttpStateHandler httpStateHandler;
    private LoggingFormatter logFormatter = new LoggingFormatter(LoggerFactory.getLogger(this.getClass()));
    private HttpResponseActionHandler httpResponseActionHandler = new HttpResponseActionHandler();
    private HttpResponseTemplateActionHandler httpResponseTemplateActionHandler = new HttpResponseTemplateActionHandler();
    private HttpForwardActionHandler httpForwardActionHandler = new HttpForwardActionHandler();
    private HttpForwardTemplateActionHandler httpForwardTemplateActionHandler = new HttpForwardTemplateActionHandler();
    private HttpClassCallbackActionHandler httpClassCallbackActionHandler = new HttpClassCallbackActionHandler();
    private HttpObjectCallbackActionHandler httpObjectCallbackActionHandler;
    private HttpErrorActionHandler httpErrorActionHandler = new HttpErrorActionHandler();

    public ActionHandler(HttpStateHandler httpStateHandler) {
        this.httpStateHandler = httpStateHandler;
        this.httpObjectCallbackActionHandler = new HttpObjectCallbackActionHandler(httpStateHandler.getWebSocketClientRegistry());
    }

    public void processAction(HttpRequest request, ResponseWriter responseWriter, ChannelHandlerContext ctx) {
        HttpResponse response = HttpResponse.notFoundResponse();
        Expectation expectation = this.httpStateHandler.firstMatchingExpectation(request);
        if (expectation != null) {
            Action action = expectation.getAction();
            switch (action.getType()) {
                case FORWARD: {
                    response = this.httpForwardActionHandler.handle((HttpForward)action, request);
                    responseWriter.writeResponse(request, response);
                    this.httpStateHandler.log(new RequestResponseLogEntry(request, response));
                    this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request:{}" + Character.NEW_LINE + " for action:{}", response, request, action);
                    break;
                }
                case FORWARD_TEMPLATE: {
                    response = this.httpForwardTemplateActionHandler.handle((HttpTemplate)action, request);
                    responseWriter.writeResponse(request, response);
                    this.httpStateHandler.log(new RequestResponseLogEntry(request, response));
                    this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request:{}" + Character.NEW_LINE + " for action:{}", response, request, action);
                    break;
                }
                case OBJECT_CALLBACK: {
                    this.httpStateHandler.log(new ExpectationMatchLogEntry(request, expectation));
                    this.httpObjectCallbackActionHandler.handle((HttpObjectCallback)action, request, responseWriter);
                    break;
                }
                case CLASS_CALLBACK: {
                    this.httpStateHandler.log(new ExpectationMatchLogEntry(request, expectation));
                    response = this.httpClassCallbackActionHandler.handle((HttpClassCallback)action, request);
                    responseWriter.writeResponse(request, response);
                    this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request:{}" + Character.NEW_LINE + " for action:{}", response, request, action);
                    break;
                }
                case RESPONSE: {
                    this.httpStateHandler.log(new ExpectationMatchLogEntry(request, expectation));
                    response = this.httpResponseActionHandler.handle((HttpResponse)action);
                    responseWriter.writeResponse(request, response);
                    this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request:{}" + Character.NEW_LINE + " for action:{}", response, request, action);
                    break;
                }
                case RESPONSE_TEMPLATE: {
                    this.httpStateHandler.log(new ExpectationMatchLogEntry(request, expectation));
                    response = this.httpResponseTemplateActionHandler.handle((HttpTemplate)action, request);
                    responseWriter.writeResponse(request, response);
                    this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request:{}" + Character.NEW_LINE + " for action:{}", response, request, action);
                    break;
                }
                case ERROR: {
                    this.httpStateHandler.log(new ExpectationMatchLogEntry(request, expectation));
                    this.httpErrorActionHandler.handle((HttpError)action, ctx);
                    this.logFormatter.infoLog("returning error :{}" + Character.NEW_LINE + " for request:{}", action, request);
                }
            }
        } else {
            this.httpStateHandler.log(new RequestLogEntry(request));
            responseWriter.writeResponse(request, response);
        }
    }
}

