/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockserver.collections.CircularLinkedList;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class MockServerMatcher
extends ObjectWithReflectiveEqualsHashCodeToString {
    protected final List<Expectation> expectations = Collections.synchronizedList(new CircularLinkedList(ConfigurationProperties.maxExpectations()));

    public void add(Expectation expectation) {
        this.expectations.add(expectation);
    }

    public Expectation firstMatchingExpectation(HttpRequest httpRequest) {
        Expectation matchingExpectation = null;
        for (Expectation expectation : new ArrayList<Expectation>(this.expectations)) {
            if (expectation.matches(httpRequest)) {
                matchingExpectation = expectation.decrementRemainingMatches();
            }
            if (!expectation.isStillAlive() || !expectation.hasRemainingMatches()) {
                HttpObjectCallback httpObjectCallback;
                if (this.expectations.contains(expectation)) {
                    this.expectations.remove(expectation);
                }
                if ((httpObjectCallback = expectation.getHttpObjectCallback()) != null) {
                    // empty if block
                }
            }
            if (matchingExpectation == null) continue;
            break;
        }
        return matchingExpectation;
    }

    public void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = new MatcherBuilder().transformsToMatcher(httpRequest);
            for (Expectation expectation : new ArrayList<Expectation>(this.expectations)) {
                if (!httpRequestMatcher.matches(expectation.getHttpRequest(), true) || !this.expectations.contains(expectation)) continue;
                this.expectations.remove(expectation);
            }
        } else {
            this.reset();
        }
    }

    public void reset() {
        this.expectations.clear();
    }

    public List<Expectation> retrieveExpectations(HttpRequest httpRequest) {
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        if (httpRequest != null) {
            for (Expectation expectation : new ArrayList<Expectation>(this.expectations)) {
                if (!expectation.matches(httpRequest)) continue;
                expectations.add(expectation);
            }
        } else {
            expectations.addAll(this.expectations);
        }
        return expectations;
    }
}

