/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.client.serialization.java.ExpectationToJavaSerializer;
import org.mockserver.client.serialization.java.HttpRequestToJavaSerializer;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.filters.LogFilter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.model.Action;
import org.mockserver.model.ClearType;
import org.mockserver.model.Format;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RetrieveType;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.LoggerFactory;

public class HttpStateHandler {
    private LogFilter logFilter = new LogFilter();
    private MockServerMatcher mockServerMatcher = new MockServerMatcher();
    private WebSocketClientRegistry webSocketClientRegistry = new WebSocketClientRegistry();
    private LoggingFormatter logFormatter = new LoggingFormatter(LoggerFactory.getLogger(this.getClass()));
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestToJavaSerializer httpRequestToJavaSerializer = new HttpRequestToJavaSerializer();
    private ExpectationToJavaSerializer expectationToJavaSerializer = new ExpectationToJavaSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public void clear(HttpRequest request) {
        HttpRequest httpRequest = null;
        if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
            httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        try {
            ClearType retrieveType = ClearType.valueOf((String)StringUtils.defaultIfEmpty((CharSequence)request.getFirstQueryStringParameter("type").toUpperCase(), (CharSequence)"ALL"));
            switch (retrieveType) {
                case LOG: {
                    this.logFilter.clear(httpRequest);
                    this.logFormatter.infoLog("clearing request logs that match:{}", httpRequest);
                    break;
                }
                case EXPECTATIONS: {
                    this.mockServerMatcher.clear(httpRequest);
                    this.logFormatter.infoLog("clearing expectations that match:{}", httpRequest);
                    break;
                }
                case ALL: {
                    this.logFilter.clear(httpRequest);
                    this.mockServerMatcher.clear(httpRequest);
                    this.logFormatter.infoLog("clearing expectations and request logs that match:{}", httpRequest);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + Lists.transform(Arrays.asList(ClearType.values()), (Function)new Function<ClearType, String>(){

                public String apply(ClearType input) {
                    return input.name().toLowerCase();
                }
            }));
        }
    }

    public void reset() {
        this.mockServerMatcher.reset();
        this.logFilter.reset();
        this.logFormatter.infoLog("resetting all expectations and request logs", new Object[0]);
    }

    public void add(Expectation ... expectations) {
        for (Expectation expectation : expectations) {
            KeyAndCertificateFactory.addSubjectAlternativeName(expectation.getHttpRequest().getFirstHeader(HttpHeaderNames.HOST.toString()));
            this.mockServerMatcher.add(expectation);
            this.logFormatter.infoLog("creating expectation:{}", expectation);
        }
    }

    public Expectation firstMatchingExpectation(HttpRequest request) {
        return this.mockServerMatcher.firstMatchingExpectation(request);
    }

    public void log(LogEntry logEntry) {
        this.logFilter.onRequest(logEntry);
    }

    public String retrieve(HttpRequest request) {
        HttpRequest httpRequest = null;
        if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
            httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        StringBuilder responseBody = new StringBuilder();
        try {
            Format format = Format.valueOf((String)StringUtils.defaultIfEmpty((CharSequence)request.getFirstQueryStringParameter("format").toUpperCase(), (CharSequence)"JSON"));
            RetrieveType retrieveType = RetrieveType.valueOf((String)StringUtils.defaultIfEmpty((CharSequence)request.getFirstQueryStringParameter("type").toUpperCase(), (CharSequence)"REQUESTS"));
            switch (retrieveType) {
                case REQUESTS: {
                    List<HttpRequest> httpRequests = this.logFilter.retrieveRequests(httpRequest);
                    switch (format) {
                        case JAVA: {
                            responseBody.append(this.httpRequestToJavaSerializer.serialize(httpRequests));
                            break;
                        }
                        case JSON: {
                            responseBody.append(this.httpRequestSerializer.serialize(httpRequests));
                        }
                    }
                    break;
                }
                case RECORDED_EXPECTATIONS: {
                    List<Expectation> expectations = this.logFilter.retrieveExpectations(httpRequest);
                    switch (format) {
                        case JAVA: {
                            responseBody.append(this.expectationToJavaSerializer.serialize(expectations));
                            break;
                        }
                        case JSON: {
                            responseBody.append(this.expectationSerializer.serialize(expectations));
                        }
                    }
                    break;
                }
                case ACTIVE_EXPECTATIONS: {
                    List<Expectation> expectations = this.mockServerMatcher.retrieveExpectations(httpRequest);
                    switch (format) {
                        case JAVA: {
                            responseBody.append(this.expectationToJavaSerializer.serialize(expectations));
                            break;
                        }
                        case JSON: {
                            responseBody.append(this.expectationSerializer.serialize(expectations));
                        }
                    }
                    break;
                }
            }
            this.logFormatter.infoLog("retrieving " + retrieveType.name().toLowerCase() + " in " + format.name().toLowerCase() + " that match:{}", httpRequest);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().contains(RetrieveType.class.getSimpleName())) {
                throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + Lists.transform(Arrays.asList(RetrieveType.values()), (Function)new Function<RetrieveType, String>(){

                    public String apply(RetrieveType input) {
                        return input.name().toLowerCase();
                    }
                }));
            }
            throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("format") + "\" is not a valid value for \"format\" parameter, only the following values are supported " + Lists.transform(Arrays.asList(Format.values()), (Function)new Function<Format, String>(){

                public String apply(Format input) {
                    return input.name().toLowerCase();
                }
            }));
        }
        return responseBody.toString();
    }

    public String verify(Verification verification) {
        return this.logFilter.verify(verification);
    }

    public String verify(VerificationSequence verification) {
        return this.logFilter.verify(verification);
    }

    public boolean handle(HttpRequest request, ResponseWriter responseWriter, boolean warDeployment) {
        this.logFormatter.traceLog("received request:{}", request);
        if ((ConfigurationProperties.enableCORSForAPI() || ConfigurationProperties.enableCORSForAllResponses()) && request.getMethod().getValue().equals("OPTIONS") && !request.getFirstHeader("Origin").isEmpty()) {
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
        } else if (request.matches("PUT", "/expectation")) {
            for (Expectation expectation : this.expectationSerializer.deserializeArray(request.getBodyAsString())) {
                if (warDeployment && !this.validateSupportedFeatures(expectation, request, responseWriter)) continue;
                this.add(expectation);
            }
            responseWriter.writeResponse(request, HttpResponseStatus.CREATED);
        } else if (request.matches("PUT", "/clear")) {
            this.clear(request);
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
        } else if (request.matches("PUT", "/reset")) {
            this.reset();
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
        } else if (request.matches("PUT", "/retrieve")) {
            responseWriter.writeResponse(request, HttpResponseStatus.OK, this.retrieve(request), MediaType.JSON_UTF_8.toString().replace(request.hasQueryStringParameter("format", "java") ? "json" : "", "java"));
        } else if (request.matches("PUT", "/verify")) {
            Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
            String result = this.verify(verification);
            if (StringUtils.isEmpty((CharSequence)result)) {
                responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
            } else {
                responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
            }
            this.logFormatter.infoLog("verifying requests that match:{}", verification);
        } else if (request.matches("PUT", "/verifySequence")) {
            VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
            String result = this.verify(verificationSequence);
            if (StringUtils.isEmpty((CharSequence)result)) {
                responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
            } else {
                responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
            }
            this.logFormatter.infoLog("verifying sequence that match:{}", verificationSequence);
        } else {
            return false;
        }
        return true;
    }

    private boolean validateSupportedFeatures(Expectation expectation, HttpRequest request, ResponseWriter responseWriter) {
        boolean valid = true;
        Action action = expectation.getAction();
        String NOT_SUPPORTED_MESSAGE = " is not supported by MockServer deployed as a WAR due to limitations in the JEE specification; use mockserver-netty to enable these features";
        if (action instanceof HttpResponse && ((HttpResponse)action).getConnectionOptions() != null) {
            responseWriter.writeResponse(request, HttpResponse.response("ConnectionOptions" + NOT_SUPPORTED_MESSAGE));
            valid = false;
        } else if (action instanceof HttpObjectCallback) {
            responseWriter.writeResponse(request, HttpResponse.response("HttpObjectCallback" + NOT_SUPPORTED_MESSAGE));
            valid = false;
        } else if (action instanceof HttpError) {
            responseWriter.writeResponse(request, HttpResponse.response("HttpError" + NOT_SUPPORTED_MESSAGE));
            valid = false;
        }
        return valid;
    }

    public WebSocketClientRegistry getWebSocketClientRegistry() {
        return this.webSocketClientRegistry;
    }
}

