/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.logging;

import org.mockserver.character.Character;
import org.mockserver.formatting.StringFormatter;
import org.slf4j.Logger;

public class LoggingFormatter {
    private final Logger logger;

    public LoggingFormatter(Logger logger) {
        this.logger = logger;
    }

    public void traceLog(String message, Object ... arguments) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(StringFormatter.formatLogMessage(message + Character.NEW_LINE + Character.NEW_LINE, arguments));
        }
    }

    public void infoLog(String message, Object ... arguments) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(StringFormatter.formatLogMessage(message + Character.NEW_LINE, arguments));
        }
    }

    public void errorLog(String message, Object ... arguments) {
        this.logger.error(StringFormatter.formatLogMessage(message, arguments));
    }

    public void errorLog(Throwable throwable, String message, Object ... arguments) {
        this.logger.error(StringFormatter.formatLogMessage(message, arguments), throwable);
    }
}

