/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.formatting;

import org.mockserver.character.Character;
import org.mockserver.model.HttpRequest;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;

public class StringFormatter {
    public static String[] indentAndToString(Object ... objects) {
        String[] indentedObjects = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            indentedObjects[i] = objects[i] instanceof HttpRequest ? Character.NEW_LINE + Character.NEW_LINE + String.valueOf(new HttpRequestTemplateObject((HttpRequest)objects[i])).replaceAll("(?m)^", "\t") + Character.NEW_LINE : Character.NEW_LINE + Character.NEW_LINE + String.valueOf(objects[i]).replaceAll("(?m)^", "\t") + Character.NEW_LINE;
        }
        return indentedObjects;
    }

    public static String formatLogMessage(String message, Object ... arguments) {
        StringBuilder errorMessage = new StringBuilder();
        String[] formattedArguments = StringFormatter.indentAndToString(arguments);
        String[] messageParts = (message + Character.NEW_LINE).split("\\{\\}");
        for (int messagePartIndex = 0; messagePartIndex < messageParts.length; ++messagePartIndex) {
            errorMessage.append(messageParts[messagePartIndex]);
            if (formattedArguments.length <= messagePartIndex) continue;
            errorMessage.append((Object)formattedArguments[messagePartIndex]);
        }
        return errorMessage.toString();
    }
}

