/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import com.google.common.base.Function;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.log.model.ExpectationLogEntry;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.LoggerFactory;

public class LogFilter {
    private static LoggingFormatter logFormatter = new LoggingFormatter(LoggerFactory.getLogger(LogFilter.class));
    private Queue<LogEntry> requestLog = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)100));
    private MatcherBuilder matcherBuilder = new MatcherBuilder();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private Function<LogEntry, HttpRequest> logEntryToHttpRequestFunction = new Function<LogEntry, HttpRequest>(){

        public HttpRequest apply(LogEntry logEntry) {
            return logEntry.getHttpRequest();
        }
    };

    public void onRequest(LogEntry logEntry) {
        this.requestLog.add(logEntry);
    }

    public void reset() {
        this.requestLog.clear();
    }

    public void clear(HttpRequest request) {
        if (request != null) {
            HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(request);
            for (LogEntry logEntry : new LinkedList<LogEntry>(this.requestLog)) {
                if (!requestMatcher.matches(logEntry.getHttpRequest(), false)) continue;
                this.requestLog.remove(logEntry);
            }
        } else {
            this.reset();
        }
    }

    public List<HttpRequest> retrieveRequests(HttpRequest httpRequest) {
        return Lists.transform(this.retrieveLogEntries(httpRequest), this.logEntryToHttpRequestFunction);
    }

    public List<Expectation> retrieveExpectations(HttpRequest httpRequest) {
        ArrayList<Expectation> matchingExpectations = new ArrayList<Expectation>();
        List<LogEntry> logEntries = this.retrieveLogEntries(httpRequest);
        for (LogEntry logEntry : logEntries) {
            if (!(logEntry instanceof ExpectationLogEntry)) continue;
            matchingExpectations.add(((ExpectationLogEntry)((Object)logEntry)).getExpectation());
        }
        return matchingExpectations;
    }

    public List<LogEntry> retrieveLogEntries(HttpRequest httpRequest) {
        LinkedList<LogEntry> requestLog = new LinkedList<LogEntry>(this.requestLog);
        ArrayList<LogEntry> matchingRequests = new ArrayList<LogEntry>();
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (LogEntry logEntry : requestLog) {
                if (!httpRequestMatcher.matches(logEntry.getHttpRequest(), true)) continue;
                matchingRequests.add(logEntry);
            }
        } else {
            matchingRequests.addAll(requestLog);
        }
        return matchingRequests;
    }

    public String verify(Verification verification) {
        LinkedList<LogEntry> requestLog = new LinkedList<LogEntry>(this.requestLog);
        String failureMessage = "";
        if (verification != null) {
            ArrayList<HttpRequest> matchingRequests = new ArrayList<HttpRequest>();
            if (verification.getHttpRequest() != null) {
                HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verification.getHttpRequest());
                for (LogEntry logEntry : requestLog) {
                    if (!httpRequestMatcher.matches(logEntry.getHttpRequest(), true)) continue;
                    matchingRequests.add(logEntry.getHttpRequest());
                }
            }
            boolean verified = true;
            if (verification.getTimes().getCount() != 0 && matchingRequests.isEmpty()) {
                verified = false;
            } else if (verification.getTimes().isExact() && matchingRequests.size() != verification.getTimes().getCount()) {
                verified = false;
            } else if (matchingRequests.size() < verification.getTimes().getCount()) {
                verified = false;
            }
            if (!verified) {
                List allRequestsArray = Lists.transform(requestLog, this.logEntryToHttpRequestFunction);
                String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(true, verification.getHttpRequest());
                String serializedAllRequestInLog = allRequestsArray.size() == 1 ? this.httpRequestSerializer.serialize(true, (HttpRequest)allRequestsArray.get(0)) : this.httpRequestSerializer.serialize(true, allRequestsArray);
                logFormatter.infoLog("request not found " + verification.getTimes() + ", expected:{}" + Character.NEW_LINE + " but was:{}", serializedRequestToBeVerified, serializedAllRequestInLog);
                failureMessage = "Request not found " + verification.getTimes() + ", expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
            }
        }
        return failureMessage;
    }

    public String verify(VerificationSequence verificationSequence) {
        LinkedList<LogEntry> requestLog = new LinkedList<LogEntry>(this.requestLog);
        String failureMessage = "";
        if (verificationSequence != null) {
            int requestLogCounter = 0;
            for (HttpRequest verificationHttpRequest : verificationSequence.getHttpRequests()) {
                if (verificationHttpRequest == null) continue;
                HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verificationHttpRequest);
                boolean foundRequest = false;
                while (!foundRequest && requestLogCounter < requestLog.size()) {
                    if (httpRequestMatcher.matches(requestLog.get(requestLogCounter).getHttpRequest(), true)) {
                        foundRequest = true;
                    }
                    ++requestLogCounter;
                }
                if (foundRequest) continue;
                List allRequestsArray = Lists.transform(requestLog, this.logEntryToHttpRequestFunction);
                String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(true, verificationSequence.getHttpRequests());
                String serializedAllRequestInLog = allRequestsArray.size() == 1 ? this.httpRequestSerializer.serialize(true, (HttpRequest)allRequestsArray.get(0)) : this.httpRequestSerializer.serialize(true, allRequestsArray);
                failureMessage = "Request sequence not found, expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                logFormatter.infoLog("request sequence not found, expected:{}" + Character.NEW_LINE + " but was:{}", serializedRequestToBeVerified, serializedAllRequestInLog);
                break;
            }
        }
        return failureMessage;
    }
}

