/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;

public class HopByHopHeaderFilter {
    public HttpRequest onRequest(HttpRequest request) {
        if (request != null) {
            List<String> headersToRemove = Arrays.asList("proxy-connection", "connection", "keep-alive", "transfer-encoding", "te", "trailer", "proxy-authorization", "proxy-authenticate", "upgrade");
            ArrayList<Header> filteredHeaders = new ArrayList<Header>();
            for (Header header : request.getHeaders()) {
                if (headersToRemove.contains(header.getName().getValue().toLowerCase(Locale.ENGLISH))) continue;
                filteredHeaders.add(header);
            }
            return request.clone().withHeaders(filteredHeaders);
        }
        return null;
    }
}

