/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import org.mockserver.echo.http.EchoServer;
import org.mockserver.echo.http.EchoServerHandler;
import org.mockserver.echo.http.ErrorHandler;
import org.mockserver.filters.LogFilter;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.server.netty.codec.MockServerServerCodec;
import org.mockserver.socket.NettySslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final boolean secure;
    private final EchoServer.Error error;

    public EchoServerInitializer(boolean secure, EchoServer.Error error) {
        if (!secure && error == EchoServer.Error.CLOSE_CONNECTION) {
            throw new IllegalArgumentException("Error type CLOSE_CONNECTION is not supported in non-secure mode");
        }
        this.secure = secure;
        this.error = error;
    }

    public void initChannel(SocketChannel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.error != null) {
            pipeline.addLast(new ChannelHandler[]{new ErrorHandler(this.error)});
        }
        if (this.secure) {
            pipeline.addLast(new ChannelHandler[]{NettySslContextFactory.nettySslContextFactory().createServerSslContext().newHandler(channel.alloc())});
        }
        if (this.logger.isTraceEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("EchoServer <-->")});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new MockServerServerCodec(this.secure)});
        pipeline.addLast(new ChannelHandler[]{new EchoServerHandler(this.error, (LogFilter)channel.attr(EchoServer.LOG_FILTER).get(), (EchoServer.NextResponse)channel.attr(EchoServer.NEXT_RESPONSE).get())});
    }
}

