/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.client.serialization.java.CookieToJavaSerializer;
import org.mockserver.client.serialization.java.HeaderToJavaSerializer;
import org.mockserver.client.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.client.serialization.java.ParameterToJavaSerializer;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlSchemaBody;

public class HttpRequestToJavaSerializer
implements ToJavaSerializer<HttpRequest> {
    private final Base64Converter base64Converter = new Base64Converter();

    public String serialize(List<HttpRequest> httpRequests) {
        StringBuilder output = new StringBuilder();
        for (HttpRequest httpRequest : httpRequests) {
            output.append(this.serialize(0, httpRequest));
            output.append(";");
            output.append(Character.NEW_LINE);
        }
        return output.toString();
    }

    @Override
    public String serialize(int numberOfSpacesToIndent, HttpRequest request) {
        StringBuffer output = new StringBuffer();
        if (request != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            output.append("request()");
            if (!Strings.isNullOrEmpty((String)request.getMethod().getValue())) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withMethod(\"").append(request.getMethod().getValue()).append("\")");
            }
            if (!Strings.isNullOrEmpty((String)request.getPath().getValue())) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withPath(\"").append(request.getPath().getValue()).append("\")");
            }
            this.outputHeaders(numberOfSpacesToIndent + 1, output, request.getHeaders());
            this.outputCookies(numberOfSpacesToIndent + 1, output, request.getCookies());
            this.outputQueryStringParameter(numberOfSpacesToIndent + 1, output, request.getQueryStringParameters());
            if (request.isSecure() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withSecure(").append(request.isSecure().toString()).append(")");
            }
            if (request.isKeepAlive() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withKeepAlive(").append(request.isKeepAlive().toString()).append(")");
            }
            if (request.getBody() != null) {
                if (request.getBody() instanceof JsonBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    JsonBody jsonBody = (JsonBody)request.getBody();
                    output.append("new JsonBody(\"").append(StringEscapeUtils.escapeJava((String)jsonBody.getValue())).append("\", JsonBodyMatchType.").append((Object)jsonBody.getMatchType()).append(")");
                    output.append(")");
                } else if (request.getBody() instanceof JsonSchemaBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    JsonSchemaBody jsonSchemaBody = (JsonSchemaBody)request.getBody();
                    output.append("new JsonSchemaBody(\"").append(StringEscapeUtils.escapeJava((String)jsonSchemaBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof XPathBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    XPathBody xPathBody = (XPathBody)request.getBody();
                    output.append("new XPathBody(\"").append(StringEscapeUtils.escapeJava((String)xPathBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof XmlSchemaBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    XmlSchemaBody xmlSchemaBody = (XmlSchemaBody)request.getBody();
                    output.append("new XmlSchemaBody(\"").append(StringEscapeUtils.escapeJava((String)xmlSchemaBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof RegexBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    RegexBody regexBody = (RegexBody)request.getBody();
                    output.append("new RegexBody(\"").append(StringEscapeUtils.escapeJava((String)regexBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof StringBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    StringBody stringBody = (StringBody)request.getBody();
                    output.append("new StringBody(\"").append(StringEscapeUtils.escapeJava((String)stringBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof ParameterBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output);
                    output.append("new ParameterBody(");
                    Object bodyParameters = ((ParameterBody)request.getBody()).getValue();
                    output.append(new ParameterToJavaSerializer().serializeAsJava(numberOfSpacesToIndent + 3, (List<Parameter>)bodyParameters));
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output);
                    output.append(")");
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(")");
                } else if (request.getBody() instanceof BinaryBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    BinaryBody body = (BinaryBody)request.getBody();
                    output.append(".withBody(new Base64Converter().base64StringToBytes(\"").append(this.base64Converter.bytesToBase64String(body.getRawBytes())).append("\"))");
                }
            }
        }
        return output.toString();
    }

    private void outputQueryStringParameter(int numberOfSpacesToIndent, StringBuffer output, List<Parameter> parameters) {
        if (parameters.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withQueryStringParameters(");
            this.appendObject(numberOfSpacesToIndent, output, new ParameterToJavaSerializer(), parameters);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuffer output, List<Cookie> cookies) {
        if (cookies.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withCookies(");
            this.appendObject(numberOfSpacesToIndent, output, new CookieToJavaSerializer(), cookies);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuffer output, List<Header> headers) {
        if (headers.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withHeaders(");
            this.appendObject(numberOfSpacesToIndent, output, new HeaderToJavaSerializer(), headers);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private <T extends ObjectWithReflectiveEqualsHashCodeToString> void appendObject(int numberOfSpacesToIndent, StringBuffer output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent + 1, objects));
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

