/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.client.serialization.java.NottableStringToJavaSerializer;
import org.mockserver.model.Header;
import org.mockserver.model.NottableString;

public class HeaderToJavaSerializer
implements MultiValueToJavaSerializer<Header> {
    @Override
    public String serialize(int numberOfSpacesToIndent, Header header) {
        StringBuilder output = new StringBuilder();
        output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)(numberOfSpacesToIndent * 8), (char)' '));
        output.append("new Header(").append(NottableStringToJavaSerializer.serializeNottableString(header.getName()));
        for (NottableString value : header.getValues()) {
            output.append(", ").append(NottableStringToJavaSerializer.serializeNottableString(value));
        }
        output.append(")");
        return output.toString();
    }

    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, List<Header> headers) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < headers.size(); ++i) {
            output.append(this.serialize(numberOfSpacesToIndent, headers.get(i)));
            if (i >= headers.size() - 1) continue;
            output.append(",");
        }
        return output.toString();
    }

    public String serializeAsJava(int numberOfSpacesToIndent, Header ... object) {
        return this.serializeAsJava(numberOfSpacesToIndent, Arrays.asList(object));
    }
}

