/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.server;

import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.http.ApacheHttpClient;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.server.ForwardChainExpectation;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerClient {
    private static final Logger logger = LoggerFactory.getLogger(MockServerClient.class);
    private final String uriBase;
    private ApacheHttpClient apacheHttpClient;
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();

    public MockServerClient(String host, int port) {
        this(host, port, "");
    }

    public MockServerClient(String host, int port, String contextPath) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Host can not be null or empty");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("ContextPath can not be null");
        }
        this.uriBase = "http://" + host + ":" + port + (contextPath.length() > 0 && !contextPath.startsWith("/") ? "/" : "") + contextPath;
        this.apacheHttpClient = new ApacheHttpClient();
    }

    public ForwardChainExpectation when(HttpRequest httpRequest) {
        return this.when(httpRequest, Times.unlimited());
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times));
    }

    public MockServerClient dumpToLog() {
        this.dumpToLog(null);
        return this;
    }

    public MockServerClient dumpToLog(HttpRequest httpRequest) {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/dumpToLog", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "");
        return this;
    }

    public MockServerClient reset() {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/reset", "");
        return this;
    }

    public MockServerClient stop() {
        try {
            this.apacheHttpClient.sendPUTRequest(this.uriBase, "/stop", "");
        }
        catch (Exception e) {
            logger.debug("Failed to send stop request to proxy " + e.getMessage());
        }
        return this;
    }

    public MockServerClient clear(HttpRequest httpRequest) {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/clear", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "");
        return this;
    }

    protected void sendExpectation(Expectation expectation) {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/expectation", expectation != null ? this.expectationSerializer.serialize(expectation) : "");
    }

    public MockServerClient verify(HttpRequest httpRequest) throws AssertionError {
        return this.verify(httpRequest, org.mockserver.client.proxy.Times.atLeast(1));
    }

    public MockServerClient verify(HttpRequest httpRequest, org.mockserver.client.proxy.Times times) throws AssertionError {
        if (httpRequest == null) {
            throw new IllegalArgumentException("verify(HttpRequest) requires a non null HttpRequest object");
        }
        Expectation[] expectations = this.retrieveAsExpectations(httpRequest);
        if (expectations == null) {
            throw new AssertionError((Object)("Expected " + this.httpRequestSerializer.serialize(httpRequest) + this.butFoundAssertionErrorMessage()));
        }
        if (times.isExact() ? expectations.length != times.getCount() : expectations.length < times.getCount()) {
            throw new AssertionError((Object)("Expected " + this.httpRequestSerializer.serialize(httpRequest) + this.butFoundAssertionErrorMessage()));
        }
        return this;
    }

    private String butFoundAssertionErrorMessage() {
        String allRequests = this.apacheHttpClient.sendPUTRequest(this.uriBase, "/retrieve", "");
        return " but " + (StringUtils.isNotEmpty((CharSequence)allRequests) ? "only found " + allRequests : "found no requests");
    }

    public Expectation[] retrieveAsExpectations(HttpRequest httpRequest) {
        return this.expectationSerializer.deserializeArray(this.apacheHttpClient.sendPUTRequest(this.uriBase, "/retrieve", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
    }

    public String retrieveAsJSON(HttpRequest httpRequest) {
        return this.apacheHttpClient.sendPUTRequest(this.uriBase, "/retrieve", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "");
    }
}

