/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro;

import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.ro.RoAvpFactory;
import net.java.slee.resource.diameter.ro.RoMessageFactory;
import net.java.slee.resource.diameter.ro.RoSessionActivity;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.ro.events.RoCreditControlAnswerImpl;

public abstract class RoSessionActivityImpl
extends DiameterActivityImpl
implements RoSessionActivity {
    private static final long serialVersionUID = 5037967180962414949L;
    protected transient RoMessageFactory roMessageFactory;

    public RoSessionActivityImpl(RoMessageFactory roMessageFactory, RoAvpFactory roAvpFactory, Session session, EventListener<Request, Answer> raEventListener, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(roMessageFactory.getBaseMessageFactory(), roAvpFactory.getBaseFactory(), session, raEventListener, destinationHost, destinationRealm);
        this.roMessageFactory = roMessageFactory;
    }

    public RoMessageFactory getRoMessageFactory() {
        return this.roMessageFactory;
    }

    public void setRoMessageFactory(RoMessageFactory roMessageFactory) {
        this.roMessageFactory = roMessageFactory;
    }

    public void setDestinationHost(DiameterIdentity destinationHost) {
        this.destinationHost = destinationHost;
    }

    public void setDestinationRealm(DiameterIdentity destinationRealm) {
        this.destinationRealm = destinationRealm;
    }

    public DiameterMessage sendSyncMessage(DiameterMessage message) {
        ErrorAnswerImpl answer = null;
        Message receivedMessage = this.doSendMessage(message);
        if (receivedMessage != null) {
            if (!receivedMessage.isRequest()) {
                if (receivedMessage.isError()) {
                    answer = new ErrorAnswerImpl(receivedMessage);
                } else {
                    switch (receivedMessage.getCommandCode()) {
                        case 272: {
                            answer = new RoCreditControlAnswerImpl(receivedMessage);
                            break;
                        }
                        default: {
                            logger.error((Object)("Received an unknown type of Message for Ro Activity: " + receivedMessage));
                            break;
                        }
                    }
                }
            } else {
                logger.error((Object)"Received a REQUEST message when expecting an ANSWER.");
            }
        } else {
            logger.debug((Object)"No answer received. Returning null.");
        }
        return answer;
    }
}

