/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro;

import java.io.IOException;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.base.events.avp.ReAuthRequestType;
import net.java.slee.resource.diameter.ro.RoAvpFactory;
import net.java.slee.resource.diameter.ro.RoMessageFactory;
import net.java.slee.resource.diameter.ro.RoServerSessionActivity;
import net.java.slee.resource.diameter.ro.RoSessionState;
import net.java.slee.resource.diameter.ro.events.RoCreditControlRequest;
import org.apache.log4j.Logger;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.ro.ServerRoSession;
import org.jdiameter.api.ro.events.RoCreditControlAnswer;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.ro.ServerRoSessionState;
import org.jdiameter.common.impl.app.auth.ReAuthRequestImpl;
import org.jdiameter.common.impl.app.ro.RoCreditControlAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.ro.RoMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.ro.RoSessionActivityImpl;

public class RoServerSessionActivityImpl
extends RoSessionActivityImpl
implements RoServerSessionActivity,
StateChangeListener<AppSession> {
    private static final long serialVersionUID = 5230054776594429948L;
    private static Logger logger = Logger.getLogger(RoServerSessionActivityImpl.class);
    protected transient ServerRoSession session = null;
    protected transient RoCreditControlRequest lastRequest = null;

    public RoServerSessionActivityImpl(RoMessageFactory roMessageFactory, RoAvpFactory roAvpFactory, ServerRoSession session, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, Stack stack) {
        super(roMessageFactory, roAvpFactory, null, (EventListener<Request, Answer>)((EventListener)session), destinationRealm, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)session.getSessions().get(0));
    }

    public net.java.slee.resource.diameter.ro.events.RoCreditControlAnswer createRoCreditControlAnswer() {
        if (this.lastRequest == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"No request received, cant create answer.");
            }
            return null;
        }
        net.java.slee.resource.diameter.ro.events.RoCreditControlAnswer answer = ((RoMessageFactoryImpl)this.getRoMessageFactory()).createRoCreditControlAnswer(this.lastRequest);
        return answer;
    }

    public void sendRoCreditControlAnswer(net.java.slee.resource.diameter.ro.events.RoCreditControlAnswer cca) throws IOException {
        this.fetchCurrentState(cca);
        DiameterMessageImpl msg = (DiameterMessageImpl)cca;
        try {
            this.session.sendCreditControlAnswer((RoCreditControlAnswer)new RoCreditControlAnswerImpl((Answer)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message, due to: ", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendReAuthRequest(net.java.slee.resource.diameter.base.events.ReAuthRequest rar) throws IOException {
        if (!rar.hasReAuthRequestType()) {
            rar.setReAuthRequestType(ReAuthRequestType.AUTHORIZE_ONLY);
        }
        if (!rar.hasAuthApplicationId()) {
            rar.setAuthApplicationId(4L);
        }
        DiameterMessageImpl msg = (DiameterMessageImpl)rar;
        try {
            this.session.sendReAuthRequest((ReAuthRequest)new ReAuthRequestImpl((Message)((Request)msg.getGenericData())));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message, due to: ", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Credit-Control Server FSM State Changed: " + oldState + " => " + newState));
        }
        ServerRoSessionState s = (ServerRoSessionState)newState;
        switch (s) {
            case OPEN: {
                break;
            }
            case IDLE: {
                this.setTerminateAfterProcessing(true);
                this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
                break;
            }
            default: {
                logger.error((Object)("Unexpected state in Credit-Control Server FSM: " + s));
            }
        }
    }

    public void fetchCurrentState(RoCreditControlRequest ccr) {
        this.lastRequest = ccr;
    }

    public void fetchCurrentState(net.java.slee.resource.diameter.ro.events.RoCreditControlAnswer cca) {
    }

    public ServerRoSession getSession() {
        return this.session;
    }

    public void setSession(ServerRoSession session2) {
        this.session = session2;
        this.session.addStateChangeNotification((StateChangeListener)this);
    }

    public RoSessionState getState() {
        ServerRoSessionState sessionState = (ServerRoSessionState)this.session.getState(ServerRoSessionState.class);
        switch (sessionState) {
            case OPEN: {
                return RoSessionState.OPEN;
            }
            case IDLE: {
                return RoSessionState.IDLE;
            }
        }
        logger.error((Object)("Unexpected state in Credit-Control Server FSM: " + sessionState));
        return null;
    }

    public String toString() {
        return super.toString() + " -- Event[ " + (this.lastRequest != null) + " ] Session[ " + this.session + " ] State[ " + this.getState() + " ]";
    }

    public void endActivity() {
        this.session.release();
        super.endActivity();
    }
}

