/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterHeader;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.base.events.avp.GroupedAvp;
import net.java.slee.resource.diameter.ro.RoMessageFactory;
import net.java.slee.resource.diameter.ro.events.RoCreditControlAnswer;
import net.java.slee.resource.diameter.ro.events.RoCreditControlMessage;
import net.java.slee.resource.diameter.ro.events.RoCreditControlRequest;
import org.apache.log4j.Logger;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Stack;
import org.mobicents.slee.resource.diameter.ro.events.RoCreditControlAnswerImpl;
import org.mobicents.slee.resource.diameter.ro.events.RoCreditControlRequestImpl;

public class RoMessageFactoryImpl
implements RoMessageFactory {
    protected Logger logger = Logger.getLogger(RoMessageFactoryImpl.class);
    protected static final Set<Integer> ids;
    protected DiameterMessageFactory baseFactory = null;
    protected String sessionId;
    protected Stack stack;
    private ApplicationId roAppId = ApplicationId.createByAuthAppId((long)0L, (long)4L);

    public RoMessageFactoryImpl(DiameterMessageFactory baseFactory, String sessionId, Stack stack) {
        this.baseFactory = baseFactory;
        this.sessionId = sessionId;
        this.stack = stack;
    }

    public void setApplicationId(long vendorId, long applicationId) {
        this.roAppId = ApplicationId.createByAuthAppId((long)vendorId, (long)applicationId);
    }

    public ApplicationId getApplicationId() {
        return this.roAppId;
    }

    public RoCreditControlRequest createRoCreditControlRequest() {
        RoCreditControlRequest ro = (RoCreditControlRequest)this.createRoCreditControlRequest(null, new DiameterAvp[0]);
        if (this.sessionId != null) {
            ro.setSessionId(this.sessionId);
        }
        return ro;
    }

    public RoCreditControlRequest createRoCreditControlRequest(String sessionId) {
        RoCreditControlRequest ro = this.createRoCreditControlRequest();
        ro.setSessionId(sessionId);
        return ro;
    }

    public RoCreditControlAnswer createRoCreditControlAnswer(RoCreditControlRequest request) {
        RoCreditControlRequestImpl ccr = (RoCreditControlRequestImpl)request;
        RoCreditControlAnswerImpl msg = new RoCreditControlAnswerImpl(this.createMessage(ccr.getHeader(), new DiameterAvp[0]));
        Message raw = msg.getGenericData();
        raw.setRequest(false);
        raw.setReTransmitted(false);
        raw.getAvps().removeAvp(293);
        raw.getAvps().removeAvp(283);
        raw.getAvps().removeAvp(264);
        raw.getAvps().removeAvp(296);
        msg.setSessionId(request.getSessionId());
        DiameterAvp[] messageAvps = request.getAvps();
        if (messageAvps != null) {
            for (DiameterAvp a : messageAvps) {
                try {
                    if (!ids.contains(a.getCode())) continue;
                    msg.addAvp(a);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to add AVP to answer. Code[" + a.getCode() + "]"), (Throwable)e);
                }
            }
        }
        this.addOrigin((DiameterMessage)msg);
        return msg;
    }

    public DiameterMessageFactory getBaseMessageFactory() {
        return this.baseFactory;
    }

    private RoCreditControlMessage createRoCreditControlRequest(DiameterHeader diameterHeader, DiameterAvp[] avps) throws IllegalArgumentException {
        boolean isRequest = diameterHeader == null;
        RoCreditControlRequestImpl msg = null;
        if (!isRequest) {
            Message raw = this.createMessage(diameterHeader, avps);
            raw.setProxiable(diameterHeader.isProxiable());
            raw.setRequest(false);
            raw.setReTransmitted(false);
            msg = new RoCreditControlAnswerImpl(raw);
        } else {
            Message raw = this.createMessage(null, avps);
            raw.setProxiable(true);
            raw.setRequest(true);
            msg = new RoCreditControlRequestImpl(raw);
        }
        return msg;
    }

    public Message createMessage(DiameterHeader header, DiameterAvp[] avps) throws AvpNotAllowedException {
        Message msg = this.createRawMessage(header);
        AvpSet set = msg.getAvps();
        for (DiameterAvp avp : avps) {
            this.addAvp(avp, set);
        }
        return msg;
    }

    protected Message createRawMessage(DiameterHeader header) {
        int commandCode = 0;
        long endToEndId = 0L;
        long hopByHopId = 0L;
        boolean isRequest = true;
        boolean isProxiable = true;
        boolean isError = false;
        boolean isPotentiallyRetransmitted = false;
        if (header != null) {
            commandCode = header.getCommandCode();
            endToEndId = header.getEndToEndId();
            hopByHopId = header.getHopByHopId();
            isRequest = header.isRequest();
            isProxiable = header.isProxiable();
            isError = header.isError();
            isPotentiallyRetransmitted = header.isPotentiallyRetransmitted();
        } else {
            commandCode = 272;
        }
        Message msg = null;
        try {
            msg = header != null ? this.stack.getSessionFactory().getNewRawSession().createMessage(commandCode, this.roAppId, hopByHopId, endToEndId, new Avp[0]) : this.stack.getSessionFactory().getNewRawSession().createMessage(commandCode, this.roAppId, new Avp[0]);
        }
        catch (IllegalDiameterStateException e) {
            this.logger.error((Object)"Failed to get session factory for message creation.", (Throwable)e);
        }
        catch (InternalException e) {
            this.logger.error((Object)"Failed to create new raw session for message creation.", (Throwable)e);
        }
        msg.setRequest(isRequest);
        msg.setProxiable(isProxiable);
        msg.setError(isError);
        msg.setReTransmitted(isRequest && isPotentiallyRetransmitted);
        return msg;
    }

    protected void addAvp(DiameterAvp avp, AvpSet set) {
        if (avp instanceof GroupedAvp) {
            DiameterAvp[] groupedAVPs;
            AvpSet avpSet = set.addGroupedAvp(avp.getCode(), avp.getVendorId(), avp.getMandatoryRule() == 1, avp.getProtectedRule() == 1);
            for (DiameterAvp avpFromGroup : groupedAVPs = ((GroupedAvp)avp).getExtensionAvps()) {
                this.addAvp(avpFromGroup, avpSet);
            }
        } else if (avp != null) {
            set.addAvp(avp.getCode(), avp.byteArrayValue(), avp.getVendorId(), avp.getMandatoryRule() == 1, avp.getProtectedRule() == 1);
        }
    }

    private void addOrigin(DiameterMessage msg) {
        if (!msg.hasOriginHost()) {
            msg.setOriginHost(new DiameterIdentity(this.stack.getMetaData().getLocalPeer().getUri().getFQDN().toString()));
        }
        if (!msg.hasOriginRealm()) {
            msg.setOriginRealm(new DiameterIdentity(this.stack.getMetaData().getLocalPeer().getRealmName()));
        }
    }

    static {
        HashSet<Integer> _ids = new HashSet<Integer>();
        _ids.add(416);
        _ids.add(415);
        ids = Collections.unmodifiableSet(_ids);
    }
}

