/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro;

import java.io.IOException;
import net.java.slee.resource.diameter.base.DiameterException;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.cca.events.avp.CcRequestType;
import net.java.slee.resource.diameter.ro.RoAvpFactory;
import net.java.slee.resource.diameter.ro.RoClientSessionActivity;
import net.java.slee.resource.diameter.ro.RoMessageFactory;
import net.java.slee.resource.diameter.ro.RoSessionState;
import net.java.slee.resource.diameter.ro.events.RoCreditControlRequest;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.ro.ClientRoSession;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.ro.ClientRoSessionState;
import org.jdiameter.common.impl.app.auth.ReAuthAnswerImpl;
import org.jdiameter.common.impl.app.ro.RoCreditControlRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.ro.RoSessionActivityImpl;

public class RoClientSessionActivityImpl
extends RoSessionActivityImpl
implements RoClientSessionActivity,
StateChangeListener<AppSession> {
    private static final long serialVersionUID = 6391181777305378777L;
    protected transient ClientRoSession session;

    public RoClientSessionActivityImpl(RoMessageFactory roMessageFactory, RoAvpFactory roAvpFactory, ClientRoSession session, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, Stack stack) {
        super(roMessageFactory, roAvpFactory, null, (EventListener<Request, Answer>)((EventListener)session), destinationRealm, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)session.getSessions().get(0));
    }

    public RoCreditControlRequest createRoCreditControlRequest(CcRequestType type) {
        RoCreditControlRequest request = super.getRoMessageFactory().createRoCreditControlRequest(super.getSessionId());
        request.setCcRequestType(type);
        if (this.destinationHost != null) {
            request.setDestinationHost(this.destinationHost);
        }
        if (this.destinationRealm != null) {
            request.setDestinationRealm(this.destinationRealm);
        }
        return request;
    }

    public void sendEventRoCreditControlRequest(RoCreditControlRequest ccr) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)ccr;
        this.validateState(ccr);
        try {
            this.session.sendCreditControlRequest((org.jdiameter.api.ro.events.RoCreditControlRequest)new RoCreditControlRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendInitialRoCreditControlRequest(RoCreditControlRequest ccr) throws IOException {
        this.validateState(ccr);
        DiameterMessageImpl msg = (DiameterMessageImpl)ccr;
        try {
            this.session.sendCreditControlRequest((org.jdiameter.api.ro.events.RoCreditControlRequest)new RoCreditControlRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendUpdateRoCreditControlRequest(RoCreditControlRequest ccr) throws IOException {
        this.validateState(ccr);
        DiameterMessageImpl msg = (DiameterMessageImpl)ccr;
        try {
            this.session.sendCreditControlRequest((org.jdiameter.api.ro.events.RoCreditControlRequest)new RoCreditControlRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendTerminationRoCreditControlRequest(RoCreditControlRequest ccr) throws IOException {
        this.validateState(ccr);
        DiameterMessageImpl msg = (DiameterMessageImpl)ccr;
        try {
            this.session.sendCreditControlRequest((org.jdiameter.api.ro.events.RoCreditControlRequest)new RoCreditControlRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendReAuthAnswer(net.java.slee.resource.diameter.base.events.ReAuthAnswer rar) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)rar;
        try {
            this.session.sendReAuthAnswer((ReAuthAnswer)new ReAuthAnswerImpl((Answer)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void stateChanged(AppSession arg0, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        ClientRoSessionState s = (ClientRoSessionState)newState;
        switch (s) {
            case PENDING_EVENT: {
                break;
            }
            case PENDING_BUFFERED: {
                break;
            }
            case PENDING_TERMINATION: {
                break;
            }
            case PENDING_UPDATE: {
                break;
            }
            case OPEN: {
                break;
            }
            case PENDING_INITIAL: {
                break;
            }
            case IDLE: {
                this.setTerminateAfterProcessing(true);
                this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
                break;
            }
            default: {
                logger.error((Object)("Unexpected state in Credit-Control Client FSM: " + s));
            }
        }
    }

    private void validateState(RoCreditControlRequest ccr) {
        if (ccr.getCcRequestType() == null) {
            throw new DiameterException("No request type is present!!");
        }
        int t = ccr.getCcRequestType().getValue();
        RoSessionState currentState = this.getState();
        if (t == CcRequestType._INITIAL_REQUEST ? currentState != RoSessionState.IDLE : (t == CcRequestType._UPDATE_REQUEST ? currentState != RoSessionState.OPEN : (t == CcRequestType._TERMINATION_REQUEST ? currentState != RoSessionState.OPEN : t == CcRequestType._EVENT_REQUEST && currentState != RoSessionState.IDLE))) {
            throw new DiameterException("Failed to validate, intial event, wrong state: " + currentState);
        }
    }

    public void setSession(ClientRoSession session2) {
        this.session = session2;
        this.session.addStateChangeNotification((StateChangeListener)this);
    }

    public RoSessionState getState() {
        ClientRoSessionState s = (ClientRoSessionState)this.session.getState(ClientRoSessionState.class);
        switch (s) {
            case PENDING_EVENT: {
                return RoSessionState.PENDING_EVENT;
            }
            case PENDING_BUFFERED: {
                return RoSessionState.PENDING_BUFFERED;
            }
            case PENDING_TERMINATION: {
                return RoSessionState.PENDING_TERMINATION;
            }
            case PENDING_UPDATE: {
                return RoSessionState.PENDING_UPDATE;
            }
            case OPEN: {
                return RoSessionState.OPEN;
            }
            case PENDING_INITIAL: {
                return RoSessionState.PENDING_INITIAL;
            }
            case IDLE: {
                return RoSessionState.IDLE;
            }
        }
        logger.error((Object)("Unexpected state in Credit-Control Client FSM: " + s));
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isTerminateAfterProcessing() ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RoClientSessionActivityImpl other = (RoClientSessionActivityImpl)((Object)obj);
        return this.terminateAfterProcessing == other.isTerminateAfterProcessing();
    }

    public void endActivity() {
        this.session.release();
        super.endActivity();
    }
}

