/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.Validator;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterException;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.ro.RoAvpFactory;
import net.java.slee.resource.diameter.ro.RoClientSessionActivity;
import net.java.slee.resource.diameter.ro.RoMessageFactory;
import net.java.slee.resource.diameter.ro.RoProvider;
import net.java.slee.resource.diameter.ro.RoServerSessionActivity;
import net.java.slee.resource.diameter.ro.events.RoCreditControlAnswer;
import net.java.slee.resource.diameter.ro.events.RoCreditControlRequest;
import org.jboss.mx.util.MBeanServerLocator;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.Message;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.ro.ClientRoSession;
import org.jdiameter.api.ro.ServerRoSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.server.impl.app.ro.ServerRoSessionImpl;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptor;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptorContext;
import org.mobicents.slee.resource.cluster.ReplicatedData;
import org.mobicents.slee.resource.diameter.AbstractClusteredDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.DiameterActivityManagement;
import org.mobicents.slee.resource.diameter.LocalDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.ValidatorImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterBaseMarshaler;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.EventIDFilter;
import org.mobicents.slee.resource.diameter.base.events.AbortSessionAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.AbortSessionRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.AccountingAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.AccountingRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ReAuthAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ReAuthRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.SessionTerminationAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.SessionTerminationRequestImpl;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;
import org.mobicents.slee.resource.diameter.ro.EventIDCache;
import org.mobicents.slee.resource.diameter.ro.RoAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.ro.RoClientSessionActivityImpl;
import org.mobicents.slee.resource.diameter.ro.RoMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.ro.RoServerSessionActivityImpl;
import org.mobicents.slee.resource.diameter.ro.events.RoCreditControlAnswerImpl;
import org.mobicents.slee.resource.diameter.ro.events.RoCreditControlRequestImpl;
import org.mobicents.slee.resource.diameter.ro.handlers.RoSessionFactory;

public class DiameterRoResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
DiameterRAInterface,
FaultTolerantResourceAdaptor<String, DiameterActivity> {
    private static final long serialVersionUID = 1L;
    private static final String AUTH_APPLICATION_IDS = "authApplicationIds";
    private List<ApplicationId> authApplicationIds;
    public final EventIDCache eventIdCache = new EventIDCache();
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private ResourceAdaptorContext raContext;
    private FaultTolerantResourceAdaptorContext<String, DiameterActivity> ftRAContext;
    private transient SleeEndpoint sleeEndpoint = null;
    private Tracer tracer;
    protected DiameterBaseMarshaler marshaler = new DiameterBaseMarshaler();
    private Stack stack;
    private ObjectName diameterMultiplexerObjectName = null;
    private DiameterStackMultiplexerMBean diameterMux = null;
    protected int defaultDirectDebitingFailureHandling = 0;
    protected int defaultCreditControlFailureHandling = 0;
    protected long defaultValidityTime = 30L;
    protected long defaultTxTimerValue = 10L;
    protected long activityRemoveDelay = 30000L;
    private DiameterAvpFactory baseAvpFactory = null;
    private DiameterMessageFactoryImpl baseMessageFactory;
    private SessionFactory sessionFactory = null;
    protected RoSessionFactory ccaSessionFactory = null;
    protected RoAvpFactory roAvpFactory = null;
    protected RoMessageFactory roMessageFactory;
    private transient EventLookupFacility eventLookup = null;
    private transient DiameterActivityManagement activities = null;
    protected transient RoProviderImpl raProvider = null;
    private static final int EVENT_FLAGS = DiameterRoResourceAdaptor.getEventFlags();
    private static final int DEFAULT_ACTIVITY_FLAGS = 2;
    private static final int MARSHALABLE_ACTIVITY_FLAGS = ActivityFlags.setSleeMayMarshal((int)2);

    private static int getEventFlags() {
        int eventFlags = 128;
        eventFlags = EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        eventFlags = EventFlags.setRequestProcessingSuccessfulCallback((int)eventFlags);
        return eventFlags;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.raContext = context;
        this.tracer = context.getTracer("DiameterRoResourceAdaptor");
        this.sleeEndpoint = context.getSleeEndpoint();
        this.eventLookup = context.getEventLookupFacility();
        this.raProvider = new RoProviderImpl(this);
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.tracer = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
        this.raProvider = null;
    }

    public void setFaultTolerantResourceAdaptorContext(FaultTolerantResourceAdaptorContext<String, DiameterActivity> ctx) {
        this.ftRAContext = ctx;
    }

    public void unsetFaultTolerantResourceAdaptorContext() {
        this.ftRAContext = null;
    }

    public void dataRemoved(String arg0) {
        this.activities.remove(this.getActivityHandle(arg0));
    }

    public void failOver(String arg0) {
        throw new UnsupportedOperationException();
    }

    public ApplicationId[] getSupportedApplications() {
        return null;
    }

    public void raActive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Ro RA :: raActive.");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activating Diameter Ro RA Entity");
            }
            this.diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object object = null;
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(this.diameterMultiplexerObjectName)) {
                object = ManagementFactory.getPlatformMBeanServer().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", new Object[0], new String[0]);
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Trying to get via Platform MBeanServer: " + this.diameterMultiplexerObjectName + ", object: " + object);
                }
            } else {
                object = MBeanServerLocator.locateJBoss().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", new Object[0], new String[0]);
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Trying to get via JBoss MBeanServer: " + this.diameterMultiplexerObjectName + ", object: " + object);
                }
            }
            if (object != null && object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.initStack();
            this.initActivitiesMgmt();
            this.baseAvpFactory = new DiameterAvpFactoryImpl();
            this.baseMessageFactory = new DiameterMessageFactoryImpl(this.stack);
            this.roAvpFactory = new RoAvpFactoryImpl(this.baseAvpFactory);
            this.roMessageFactory = new RoMessageFactoryImpl((DiameterMessageFactory)this.baseMessageFactory, null, this.stack);
            ApplicationId firstAppId = this.authApplicationIds.get(0);
            ((RoMessageFactoryImpl)this.roMessageFactory).setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
            this.sessionFactory = this.stack.getSessionFactory();
            this.ccaSessionFactory = new RoSessionFactory(this, this.sessionFactory, this.defaultDirectDebitingFailureHandling, this.defaultCreditControlFailureHandling, this.defaultValidityTime, this.defaultTxTimerValue);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ServerRoSession.class, (IAppSessionFactory)this.ccaSessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ClientRoSession.class, (IAppSessionFactory)this.ccaSessionFactory);
        }
        catch (Exception e) {
            this.tracer.severe("Error Activating Diameter Ro RA Entity", (Throwable)e);
        }
    }

    public void raStopping() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Ro RA :: raStopping.");
        }
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to unregister Ro RA from Diameter Mux.", (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Ro RA :: raStopping completed.");
        }
    }

    public void raInactive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Ro RA :: raInactive.");
        }
        this.activities = null;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Ro RA :: raInactive completed.");
        }
    }

    public void raConfigure(ConfigProperties properties) {
        this.parseApplicationIds((String)properties.getProperty(AUTH_APPLICATION_IDS).getValue());
    }

    private void parseApplicationIds(String appIdsStr) {
        if (appIdsStr != null) {
            appIdsStr = appIdsStr.replaceAll(" ", "");
            String[] appIdsStrings = appIdsStr.split(",");
            this.authApplicationIds = new ArrayList<ApplicationId>(appIdsStrings.length);
            for (String appId : appIdsStrings) {
                String[] vendorAndAppId = appId.split(":");
                this.authApplicationIds.add(ApplicationId.createByAuthAppId((long)Long.valueOf(vendorAndAppId[0]), (long)Long.valueOf(vendorAndAppId[1])));
            }
        }
    }

    public void raUnconfigure() {
        this.activities = null;
        this.raContext = null;
        this.eventLookup = null;
        this.raProvider = null;
        this.sleeEndpoint = null;
        this.stack = null;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.raProvider;
    }

    public Marshaler getMarshaler() {
        return this.marshaler;
    }

    public void serviceActive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceActive(serviceInfo);
    }

    public void serviceStopping(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceStopping(serviceInfo);
    }

    public void serviceInactive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceInactive(serviceInfo);
    }

    public void queryLiveness(ActivityHandle handle) {
        this.tracer.info("Diameter Ro RA :: queryLiveness :: handle[" + handle + "].");
        DiameterActivityImpl activity = (DiameterActivityImpl)this.activities.get((DiameterActivityHandle)handle);
        if (activity != null && !activity.isValid()) {
            try {
                this.sleeEndpoint.endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("Failure ending non-live activity.", (Throwable)e);
            }
        }
    }

    public Object getActivity(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Ro RA :: getActivity :: handle[" + handle + "].");
        }
        return this.activities.get((DiameterActivityHandle)handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Ro RA :: getActivityHandle :: activity[" + activity + "].");
        }
        if (!(activity instanceof DiameterActivity)) {
            return null;
        }
        DiameterActivityImpl inActivity = (DiameterActivityImpl)activity;
        return inActivity.getActivityHandle();
    }

    public void administrativeRemove(ActivityHandle handle) {
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Ro RA :: eventProcessingFailed :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Ro RA :: eventProcessingSuccessful :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Ro RA :: eventUnreferenced :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], service[" + service + "], flags[" + flags + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAfterEventDelivery(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        DiameterActivityImpl activity = (DiameterActivityImpl)this.getActivity(handle);
        if (activity != null) {
            DiameterActivityImpl diameterActivityImpl = activity;
            synchronized (diameterActivityImpl) {
                if (activity.isTerminateAfterProcessing()) {
                    activity.endActivity();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Ro RA :: activityEnded :: handle[" + handle + "].");
        }
        if (this.activities != null) {
            DiameterActivityManagement diameterActivityManagement = this.activities;
            synchronized (diameterActivityManagement) {
                this.activities.remove((DiameterActivityHandle)handle);
            }
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Ro RA :: activityUnreferenced :: handle[" + handle + "].");
        }
        if (handle instanceof DiameterActivityHandle) {
            this.endActivity((DiameterActivityHandle)handle);
        }
    }

    public boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventID, Address address, boolean useFiltering, boolean transacted) {
        if (useFiltering && this.eventIDFilter.filterEvent(eventID)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Event " + eventID + " filtered");
            }
        } else if (eventID == null) {
            this.tracer.severe("Event ID for " + eventID + " is unknown, unable to fire.");
        } else {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Firing event " + event + " on handle " + handle);
            }
            try {
                Object o = this.getActivity(handle);
                if (o == null) {
                    throw new IllegalStateException("No activity for handle: " + handle);
                }
                if (o instanceof RoServerSessionActivityImpl && event instanceof RoCreditControlRequest) {
                    ((RoServerSessionActivityImpl)((Object)o)).fetchCurrentState((RoCreditControlRequest)event);
                }
                this.raContext.getSleeEndpoint().fireEvent(handle, eventID, event, address, null, EVENT_FLAGS);
                return true;
            }
            catch (Exception e) {
                this.tracer.severe("Error firing event.", (Throwable)e);
            }
        }
        return false;
    }

    public void fireEvent(String sessionId, Message message) {
        DiameterMessage event = this.createEvent(message);
        FireableEventType eventId = this.eventIdCache.getEventId(this.eventLookup, message);
        this.fireEvent(event, (ActivityHandle)this.getActivityHandle(sessionId), eventId, null, true, message.isRequest());
    }

    public void endActivity(DiameterActivityHandle arg0) {
        this.sleeEndpoint.endActivity((ActivityHandle)arg0);
    }

    public void startActivityRemoveTimer(DiameterActivityHandle handle) {
        try {
            this.activities.startActivityRemoveTimer(handle);
        }
        catch (Exception e) {
            this.tracer.warning("Failed to start activity remove timer.", (Throwable)e);
        }
    }

    public void stopActivityRemoveTimer(DiameterActivityHandle handle) {
        try {
            this.activities.stopActivityRemoveTimer(handle);
        }
        catch (Exception e) {
            this.tracer.warning("Failed to stop activity remove timer.", (Throwable)e);
        }
    }

    public void update(DiameterActivityHandle arg0, DiameterActivity arg1) {
        this.activities.update(arg0, arg1);
    }

    private DiameterMessage createEvent(Message message) {
        if (message == null) {
            throw new NullPointerException("Message argument cannot be null while creating event.");
        }
        int commandCode = message.getCommandCode();
        if (message.isError()) {
            return new ErrorAnswerImpl(message);
        }
        boolean isRequest = message.isRequest();
        switch (commandCode) {
            case 272: {
                return isRequest ? new RoCreditControlRequestImpl(message) : new RoCreditControlAnswerImpl(message);
            }
            case 274: {
                return isRequest ? new AbortSessionRequestImpl(message) : new AbortSessionAnswerImpl(message);
            }
            case 275: {
                return isRequest ? new SessionTerminationRequestImpl(message) : new SessionTerminationAnswerImpl(message);
            }
            case 258: {
                return isRequest ? new ReAuthRequestImpl(message) : new ReAuthAnswerImpl(message);
            }
            case 271: {
                return isRequest ? new AccountingRequestImpl(message) : new AccountingAnswerImpl(message);
            }
        }
        return new ExtensionDiameterMessageImpl(message);
    }

    private void addActivity(DiameterActivity ac, boolean suspended) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            if (suspended) {
                this.sleeEndpoint.startActivitySuspended((ActivityHandle)activity.getActivityHandle(), (Object)activity, MARSHALABLE_ACTIVITY_FLAGS);
            } else {
                this.sleeEndpoint.startActivity((ActivityHandle)activity.getActivityHandle(), (Object)activity, MARSHALABLE_ACTIVITY_FLAGS);
            }
            activity.setSessionListener((Object)this);
            this.activities.put(activity.getActivityHandle(), (DiameterActivity)activity);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activity started [" + activity.getActivityHandle() + "]");
            }
        }
        catch (Exception e) {
            this.tracer.severe("Error creating activity", (Throwable)e);
            throw new RuntimeException("Error creating activity", e);
        }
    }

    private synchronized void initStack() throws Exception {
        this.diameterMux.registerListener((DiameterListener)this, this.authApplicationIds.toArray(new ApplicationId[this.authApplicationIds.size()]));
        this.stack = this.diameterMux.getStack();
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Ro RA :: Successfully initialized stack.");
        }
    }

    private void initActivitiesMgmt() {
        final DiameterRoResourceAdaptor lst = this;
        if (this.ftRAContext.isLocal()) {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info(this.raContext.getEntityName() + " -- running in LOCAL mode.");
            }
            this.activities = new LocalDiameterActivityManagement(this.raContext, this.activityRemoveDelay);
        } else {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info(this.raContext.getEntityName() + " -- running in CLUSTER mode.");
            }
            ReplicatedData clusteredData = this.ftRAContext.getReplicateData(true);
            this.activities = new AbstractClusteredDiameterActivityManagement(this.ftRAContext, this.activityRemoveDelay, this.raContext.getTracer(""), this.stack, this.raContext.getSleeTransactionManager(), clusteredData){

                protected void performBeforeReturn(DiameterActivityImpl activity) {
                    block5: {
                        try {
                            Session session = null;
                            if (activity.getClass().equals(DiameterActivityImpl.class)) {
                                session = this.diameterStack.getSessionFactory().getNewSession(activity.getSessionId());
                                this.performBeforeReturnOnBase(activity, session);
                                return;
                            }
                            if (activity instanceof RoClientSessionActivity) {
                                RoClientSessionActivityImpl acc = (RoClientSessionActivityImpl)activity;
                                ClientRoSession appSession = (ClientRoSession)this.diameterStack.getSession(activity.getSessionId(), ClientRoSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                this.performBeforeReturnRo(acc, session);
                                this.performBeforeReturnCC(acc);
                                acc.setSession(appSession);
                                break block5;
                            }
                            if (activity instanceof RoServerSessionActivity) {
                                RoServerSessionActivityImpl acc = (RoServerSessionActivityImpl)activity;
                                ServerRoSession appSession = (ServerRoSession)this.diameterStack.getSession(activity.getSessionId(), ServerRoSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                this.performBeforeReturnRo(acc, session);
                                this.performBeforeReturnCC(acc);
                                acc.setSession(appSession);
                                break block5;
                            }
                            throw new IllegalArgumentException("Unknown activity type: " + activity);
                        }
                        catch (Exception e) {
                            throw new DiameterException((Throwable)e);
                        }
                    }
                }

                private void performBeforeReturnCC(RoServerSessionActivityImpl acc) {
                }

                private void performBeforeReturnCC(RoClientSessionActivityImpl acc) {
                }

                private void performBeforeReturnRo(RoServerSessionActivityImpl acc, Session session) {
                    RoMessageFactoryImpl messageFactory = new RoMessageFactoryImpl((DiameterMessageFactory)DiameterRoResourceAdaptor.this.baseMessageFactory, session.getSessionId(), DiameterRoResourceAdaptor.this.stack);
                    ApplicationId firstAppId = (ApplicationId)DiameterRoResourceAdaptor.this.authApplicationIds.get(0);
                    messageFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
                    acc.setRoMessageFactory(messageFactory);
                }

                private void performBeforeReturnRo(RoClientSessionActivityImpl acc, Session session) {
                    RoMessageFactoryImpl messageFactory = new RoMessageFactoryImpl((DiameterMessageFactory)DiameterRoResourceAdaptor.this.baseMessageFactory, session.getSessionId(), DiameterRoResourceAdaptor.this.stack);
                    ApplicationId firstAppId = (ApplicationId)DiameterRoResourceAdaptor.this.authApplicationIds.get(0);
                    messageFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
                    acc.setRoMessageFactory(messageFactory);
                }

                private void performBeforeReturnOnBase(DiameterActivityImpl ac, Session session) {
                    DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl(session, DiameterRoResourceAdaptor.this.stack, new DiameterIdentity[0]);
                    ac.setAvpFactory(DiameterRoResourceAdaptor.this.baseAvpFactory);
                    ac.setMessageFactory((DiameterMessageFactory)msgFactory);
                    ac.setCurrentWorkingSession(session);
                    ac.setSessionListener((Object)lst);
                }

                public DiameterActivity get(DiameterActivityHandle handle) {
                    return super.get(handle);
                }

                public void put(DiameterActivityHandle handle, DiameterActivity activity) {
                    super.put(handle, activity);
                }

                public DiameterActivity remove(DiameterActivityHandle handle) {
                    return super.remove(handle);
                }
            };
        }
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    public Answer processRequest(Request request) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Ro RA :: Got Request. Command-Code[" + request.getCommandCode() + "]");
        }
        if (request.getCommandCode() == 272) {
            try {
                DiameterActivity activity = this.raProvider.createActivity((Message)request);
                if (activity == null) {
                    this.tracer.severe("Diameter Ro RA :: Failed to create session, Command-Code: " + request.getCommandCode() + ", Session-Id: " + request.getSessionId());
                } else if (activity instanceof RoServerSessionActivity) {
                    RoServerSessionActivityImpl session = (RoServerSessionActivityImpl)activity;
                    ((ServerRoSessionImpl)session.getSession()).processRequest(request);
                }
            }
            catch (CreateActivityException e) {
                this.tracer.severe("Failure trying to create Ro Activity.", (Throwable)e);
            }
            return null;
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Ro RA :: Received unexpected Request. Either its not CCR or session should exist to handle this, Command-Code: " + request.getCommandCode() + ", Session-Id: " + request.getSessionId());
        }
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Ro RA :: receivedSuccessMessage :: Request[" + request + "], Answer[" + answer + "].");
        }
        this.tracer.warning("Resource Adaptor should not receive this (receivedSuccessMessage), a session should exist to handle it.");
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Received Message Result-Code: " + answer.getResultCode().getUnsigned32());
            }
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request request) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Ro RA :: timeoutExpired :: Request[" + request + "].");
        }
        this.tracer.warning("Resource Adaptor should not receive this (timeoutExpired), a session should exist to handle it.");
        try {
            ((DiameterActivity)this.getActivity((ActivityHandle)this.getActivityHandle(request.getSessionId()))).endActivity();
        }
        catch (Exception e) {
            this.tracer.severe("Failure processing timeout message.", (Throwable)e);
        }
    }

    public void sessionCreated(ClientRoSession ccClientSession) {
        if (this.getActivity((ActivityHandle)this.getActivityHandle(((Session)ccClientSession.getSessions().get(0)).getSessionId())) != null) {
            this.tracer.warning("Activity found for created Credit-Control Client Session. Shouldn't exist. Aborting.");
            return;
        }
        RoClientSessionActivityImpl activity = new RoClientSessionActivityImpl(this.roMessageFactory, this.roAvpFactory, ccClientSession, null, null, this.stack);
        activity.setSessionListener(this);
        this.addActivity((DiameterActivity)activity, false);
    }

    public void sessionCreated(ServerRoSession ccServerSession) {
        if (this.getActivity((ActivityHandle)this.getActivityHandle(((Session)ccServerSession.getSessions().get(0)).getSessionId())) != null) {
            this.tracer.warning("Activity found for created Credit-Control Server Session. Shouldn't exist. Aborting.");
            return;
        }
        RoServerSessionActivityImpl activity = new RoServerSessionActivityImpl(this.roMessageFactory, this.roAvpFactory, ccServerSession, null, null, this.stack);
        activity.setSessionListener(this);
        this.addActivity((DiameterActivity)activity, false);
    }

    public boolean sessionExists(String sessionId) {
        return this.activities.containsKey(this.getActivityHandle(sessionId));
    }

    public void sessionDestroyed(String sessionId, Object appSession) {
        try {
            this.sleeEndpoint.endActivity((ActivityHandle)this.getActivityHandle(sessionId));
        }
        catch (Exception e) {
            this.tracer.severe("Failure Ending Activity with Session-Id[" + sessionId + "]", (Throwable)e);
        }
    }

    public DiameterIdentity[] getConnectedPeers() {
        if (this.stack != null) {
            try {
                List peers = ((PeerTable)this.stack.unwrap(PeerTable.class)).getPeerTable();
                DiameterIdentity[] result = new DiameterIdentity[peers.size()];
                int i = 0;
                for (Peer peer : peers) {
                    DiameterIdentity identity = new DiameterIdentity(peer.getUri().toString());
                    result[i++] = identity;
                }
                return result;
            }
            catch (Exception e) {
                this.tracer.severe("Failure getting peer list.", (Throwable)e);
            }
        }
        return new DiameterIdentity[0];
    }

    private class RoProviderImpl
    implements RoProvider {
        private DiameterRoResourceAdaptor ra;
        private Validator validator = new ValidatorImpl();

        public RoProviderImpl(DiameterRoResourceAdaptor ra) {
            this.ra = ra;
        }

        public RoClientSessionActivity createRoClientSessionActivity() throws CreateActivityException {
            try {
                ClientRoSession session = (ClientRoSession)((ISessionFactory)DiameterRoResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, (ApplicationId)DiameterRoResourceAdaptor.this.authApplicationIds.get(0), ClientRoSession.class, new Object[0]);
                DiameterRoResourceAdaptor.this.sessionCreated(session);
                if (session == null) {
                    DiameterRoResourceAdaptor.this.tracer.severe("Failure creating Ro Client Session (null).");
                    return null;
                }
                return (RoClientSessionActivity)DiameterRoResourceAdaptor.this.getActivity((ActivityHandle)DiameterRoResourceAdaptor.this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId()));
            }
            catch (Exception e) {
                throw new CreateActivityException((Throwable)e);
            }
        }

        public RoClientSessionActivity createRoClientSessionActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm) throws CreateActivityException {
            RoClientSessionActivityImpl clientSession = (RoClientSessionActivityImpl)this.createRoClientSessionActivity();
            clientSession.setDestinationHost(destinationHost);
            clientSession.setDestinationRealm(destinationRealm);
            return clientSession;
        }

        public RoAvpFactory getRoAvpFactory() {
            return this.ra.roAvpFactory;
        }

        public RoMessageFactory getRoMessageFactory() {
            return this.ra.roMessageFactory;
        }

        public RoCreditControlAnswer sendRoCreditControlRequest(RoCreditControlRequest ccr) throws IOException {
            try {
                DiameterActivityImpl activity = (DiameterActivityImpl)DiameterRoResourceAdaptor.this.getActivity((ActivityHandle)DiameterRoResourceAdaptor.this.getActivityHandle(ccr.getSessionId()));
                if (activity == null) {
                    activity = (DiameterActivityImpl)this.createActivity(((DiameterMessageImpl)ccr).getGenericData());
                }
                return (RoCreditControlAnswer)activity.sendSyncMessage((DiameterMessage)ccr);
            }
            catch (Exception e) {
                DiameterRoResourceAdaptor.this.tracer.severe("Failure sending sync request.", (Throwable)e);
                return null;
            }
        }

        private DiameterActivity createActivity(Message message) throws CreateActivityException {
            DiameterActivity activity = DiameterRoResourceAdaptor.this.activities.get(DiameterRoResourceAdaptor.this.getActivityHandle(message.getSessionId()));
            if (activity == null) {
                if (message.isRequest()) {
                    return this.createRoServerSessionActivity((Request)message);
                }
                AvpSet avps = message.getAvps();
                Avp avp = null;
                DiameterIdentity destinationHost = null;
                DiameterIdentity destinationRealm = null;
                avp = avps.getAvp(293);
                if (avp != null) {
                    try {
                        destinationHost = new DiameterIdentity(avp.getDiameterIdentity());
                    }
                    catch (AvpDataException e) {
                        DiameterRoResourceAdaptor.this.tracer.severe("Failed to extract Destination-Host from Message.", (Throwable)e);
                    }
                }
                if ((avp = avps.getAvp(283)) != null) {
                    try {
                        destinationRealm = new DiameterIdentity(avp.getDiameterIdentity());
                    }
                    catch (AvpDataException e) {
                        DiameterRoResourceAdaptor.this.tracer.severe("Failed to extract Destination-Realm from Message.", (Throwable)e);
                    }
                }
                return this.createRoClientSessionActivity(destinationHost, destinationRealm);
            }
            return activity;
        }

        private DiameterActivity createRoServerSessionActivity(Request message) throws CreateActivityException {
            try {
                ServerRoSession session = (ServerRoSession)((ISessionFactory)DiameterRoResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(message.getSessionId(), (ApplicationId)DiameterRoResourceAdaptor.this.authApplicationIds.get(0), ServerRoSession.class, new Object[0]);
                DiameterRoResourceAdaptor.this.sessionCreated(session);
                if (session == null) {
                    DiameterRoResourceAdaptor.this.tracer.severe("Failure creating Ro Server Session (null).");
                    return null;
                }
                return (DiameterActivity)DiameterRoResourceAdaptor.this.getActivity((ActivityHandle)DiameterRoResourceAdaptor.this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId()));
            }
            catch (Exception e) {
                throw new CreateActivityException((Throwable)e);
            }
        }

        public DiameterIdentity[] getConnectedPeers() {
            return this.ra.getConnectedPeers();
        }

        public int getPeerCount() {
            return this.ra.getConnectedPeers().length;
        }

        public Validator getValidator() {
            return this.validator;
        }
    }
}

