/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.mgcp.ra;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.AuditConnection;
import jain.protocol.ip.mgcp.message.AuditEndpoint;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.EndpointConfiguration;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.RestartInProgress;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import net.java.slee.resource.mgcp.event.TransactionTimeout;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackProviderImpl;
import org.mobicents.slee.resource.mgcp.ra.EventIDCache;
import org.mobicents.slee.resource.mgcp.ra.EventIDFilter;
import org.mobicents.slee.resource.mgcp.ra.JainMgcpProviderImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpActivityManager;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityImpl;

public class MgcpResourceAdaptor
implements ResourceAdaptor {
    private MgcpActivityManager mgcpActivityManager = null;
    private ResourceAdaptorContext resourceAdaptorContext;
    private Tracer tracer;
    private int port = 2427;
    private String stackAddress = null;
    private JainMgcpStackImpl stack;
    private final EventIDCache eventIdCache = new EventIDCache();
    private JainMgcpProviderImpl mgcpProvider;
    private transient SleeEndpoint sleeEndpoint = null;
    private static final String MGCP_BIND_ADDRESS = "jain.mgcp.IP_ADDRESS";
    private static final String MGCP_BIND_PORT = "jain.mgcp.PORT";
    private static final transient Address address = new Address(AddressPlan.IP, "localhost");
    public static final int ACTIVITY_FLAGS = 2;
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private static final int EVENT_FLAGS = MgcpResourceAdaptor.getEventFlags();

    private static int getEventFlags() {
        int eventFlags = 128;
        EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        return eventFlags;
    }

    public void activityEnded(ActivityHandle handle) {
        this.mgcpActivityManager.removeMgcpActivity(handle);
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Activity with handle " + handle + " ended");
        }
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public void administrativeRemove(ActivityHandle arg0) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public Object getActivity(ActivityHandle handle) {
        return this.mgcpActivityManager.getActivity(handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        return this.mgcpActivityManager.getActivityHandle(activity);
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.mgcpProvider;
    }

    public void queryLiveness(ActivityHandle handle) {
    }

    public void raActive() {
        try {
            InetAddress inetAddress = InetAddress.getByName(this.stackAddress);
            this.stack = new JainMgcpStackImpl(inetAddress, this.port);
            this.mgcpProvider.setProvider((JainMgcpStackProviderImpl)this.stack.createProvider());
            this.sleeEndpoint = this.resourceAdaptorContext.getSleeEndpoint();
            this.mgcpActivityManager = new MgcpActivityManager();
        }
        catch (Throwable ex) {
            String msg = "error in initializing resource adaptor";
            this.tracer.severe(msg, ex);
            throw new RuntimeException(msg, ex);
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("MGCP Resource Adaptor entity active.");
        }
    }

    public void raConfigurationUpdate(ConfigProperties arg0) {
    }

    public void raConfigure(ConfigProperties properties) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Configuring RA.");
        }
        this.port = (Integer)properties.getProperty(MGCP_BIND_PORT).getValue();
        this.stackAddress = (String)properties.getProperty(MGCP_BIND_ADDRESS).getValue();
        if (this.stackAddress.equals("null")) {
            this.stackAddress = System.getProperty("jboss.bind.address");
        }
        this.tracer.info("MGCP RA will bound to " + this.stackAddress + ":" + this.port);
    }

    public void raInactive() {
        try {
            this.mgcpProvider.delete();
            this.stack = null;
        }
        catch (Throwable ex) {
            String msg = "error in de-activating resource adaptor";
            this.tracer.severe(msg, ex);
            throw new RuntimeException(msg, ex);
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("MGCP Resource Adaptor entity de-activated.");
        }
    }

    public void raStopping() {
    }

    public void raUnconfigure() {
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        try {
            Integer port = (Integer)properties.getProperty(MGCP_BIND_PORT).getValue();
            String stackAddress = (String)properties.getProperty(MGCP_BIND_ADDRESS).getValue();
            if (stackAddress.equals("null")) {
                stackAddress = System.getProperty("jboss.bind.address");
            }
            InetSocketAddress sockAddress = new InetSocketAddress(stackAddress, (int)port);
            new DatagramSocket(sockAddress).close();
        }
        catch (Throwable e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    public void serviceActive(ReceivableService receivableService) {
        this.eventIDFilter.serviceActive(receivableService);
    }

    public void serviceInactive(ReceivableService receivableService) {
        this.eventIDFilter.serviceInactive(receivableService);
    }

    public void serviceStopping(ReceivableService receivableService) {
        this.eventIDFilter.serviceStopping(receivableService);
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        this.resourceAdaptorContext = raContext;
        this.tracer = this.resourceAdaptorContext.getTracer(MgcpResourceAdaptor.class.getSimpleName());
        this.mgcpProvider = new JainMgcpProviderImpl(this, this.tracer);
    }

    public void unsetResourceAdaptorContext() {
        this.resourceAdaptorContext = null;
        this.mgcpProvider = null;
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent event) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine(this.resourceAdaptorContext.getEntityName() + " received event of type " + event.getObjectIdentifier() + ". Request TX ID = " + event.getTransactionHandle());
        }
        switch (event.getObjectIdentifier()) {
            case 101: {
                AuditConnection auditConnection = (AuditConnection)event;
                this.processNonCreateConnectionMgcpEvent(auditConnection.getConnectionIdentifier(), event.getEndpointIdentifier(), event.getTransactionHandle(), "net.java.slee.resource.mgcp.AUDIT_CONNECTION", event, false);
                break;
            }
            case 102: {
                AuditEndpoint auditEndpoint = (AuditEndpoint)event;
                this.processEndpointMgcpEvent(auditEndpoint.getEndpointIdentifier(), "net.java.slee.resource.mgcp.AUDIT_ENDPOINT", event, false);
                break;
            }
            case 103: {
                CreateConnection createConnection = (CreateConnection)event;
                this.processCreateConnectionMgcpEvent(createConnection);
                break;
            }
            case 104: {
                DeleteConnection deleteConnection = (DeleteConnection)event;
                if (deleteConnection.getConnectionIdentifier() != null) {
                    this.processNonCreateConnectionMgcpEvent(deleteConnection.getConnectionIdentifier(), event.getEndpointIdentifier(), event.getTransactionHandle(), "net.java.slee.resource.mgcp.DELETE_CONNECTION", event, false);
                    break;
                }
                this.processEndpointMgcpEvent(deleteConnection.getEndpointIdentifier(), "net.java.slee.resource.mgcp.DELETE_CONNECTION", event, false);
                break;
            }
            case 105: {
                EndpointConfiguration endpointConfiguration = (EndpointConfiguration)event;
                this.processEndpointMgcpEvent(endpointConfiguration.getEndpointIdentifier(), "net.java.slee.resource.mgcp.ENDPOINT_CONFIGURATION", event, false);
                break;
            }
            case 106: {
                ModifyConnection modifyConnection = (ModifyConnection)event;
                this.processNonCreateConnectionMgcpEvent(modifyConnection.getConnectionIdentifier(), event.getEndpointIdentifier(), event.getTransactionHandle(), "net.java.slee.resource.mgcp.MODIFY_CONNECTION", event, false);
                break;
            }
            case 107: {
                EventName[] signalEvents;
                ConnectionIdentifier connectionIdentifier;
                NotificationRequest notificationRequest = (NotificationRequest)event;
                boolean processOnEndpoint = false;
                ArrayList<String> connectionIds = new ArrayList<String>();
                RequestedEvent[] requestedEvents = notificationRequest.getRequestedEvents();
                if (requestedEvents != null) {
                    for (RequestedEvent requestedEvent : requestedEvents) {
                        EventName detectEvent = requestedEvent.getEventName();
                        connectionIdentifier = detectEvent.getConnectionIdentifier();
                        if (connectionIdentifier != null) {
                            if (connectionIds.contains(connectionIdentifier.toString())) continue;
                            connectionIds.add(connectionIdentifier.toString());
                            continue;
                        }
                        processOnEndpoint = true;
                    }
                }
                if ((signalEvents = notificationRequest.getSignalRequests()) != null) {
                    for (EventName signalEvent : signalEvents) {
                        connectionIdentifier = signalEvent.getConnectionIdentifier();
                        if (connectionIdentifier != null) {
                            if (connectionIds.contains(connectionIdentifier.toString())) continue;
                            connectionIds.add(connectionIdentifier.toString());
                            continue;
                        }
                        processOnEndpoint = true;
                    }
                }
                for (String s : connectionIds) {
                    this.processNonCreateConnectionMgcpEvent(new ConnectionIdentifier(s), event.getEndpointIdentifier(), event.getTransactionHandle(), "net.java.slee.resource.mgcp.NOTIFICATION_REQUEST", event, false);
                }
                if ((requestedEvents != null || signalEvents != null) && !processOnEndpoint) break;
                this.processEndpointMgcpEvent(notificationRequest.getEndpointIdentifier(), "net.java.slee.resource.mgcp.NOTIFICATION_REQUEST", event, false);
                break;
            }
            case 108: {
                Notify notify = (Notify)event;
                boolean processOnEndpointNtfy = false;
                ArrayList<String> connectionIdsNtfy = new ArrayList<String>();
                EventName[] observedEvents = notify.getObservedEvents();
                if (observedEvents != null) {
                    for (int i = 0; i < observedEvents.length; ++i) {
                        EventName observedEvent = observedEvents[i];
                        ConnectionIdentifier connectionIdentifier = observedEvent.getConnectionIdentifier();
                        if (connectionIdentifier != null) {
                            if (connectionIdsNtfy.contains(connectionIdentifier.toString())) continue;
                            connectionIdsNtfy.add(connectionIdentifier.toString());
                            continue;
                        }
                        processOnEndpointNtfy = true;
                    }
                } else {
                    processOnEndpointNtfy = true;
                }
                for (String s : connectionIdsNtfy) {
                    this.processNonCreateConnectionMgcpEvent(new ConnectionIdentifier(s), notify.getEndpointIdentifier(), notify.getTransactionHandle(), "net.java.slee.resource.mgcp.NOTIFY", event, false);
                }
                if (!processOnEndpointNtfy) break;
                this.processEndpointMgcpEvent(notify.getEndpointIdentifier(), "net.java.slee.resource.mgcp.NOTIFY", event, false);
                break;
            }
            case 109: {
                RestartInProgress restartInProgress = (RestartInProgress)event;
                this.processEndpointMgcpEvent(restartInProgress.getEndpointIdentifier(), "net.java.slee.resource.mgcp.RESTART_IN_PROGRESS", event, false);
                break;
            }
            default: {
                this.tracer.warning("Unexpected event type: " + event.getObjectIdentifier());
            }
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent response, JainMgcpEvent command) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Receive response TX ID = " + response.getTransactionHandle());
        }
        switch (response.getObjectIdentifier()) {
            case 201: {
                AuditConnection auditConnection = (AuditConnection)command;
                this.processNonCreateConnectionMgcpEvent(auditConnection.getConnectionIdentifier(), auditConnection.getEndpointIdentifier(), response.getTransactionHandle(), "net.java.slee.resource.mgcp.AUDIT_CONNECTION_RESPONSE", response, false);
                break;
            }
            case 202: {
                this.processEndpointMgcpEvent(((AuditEndpoint)command).getEndpointIdentifier(), "net.java.slee.resource.mgcp.AUDIT_ENDPOINT_RESPONSE", response, false);
                break;
            }
            case 203: {
                ConnectionIdentifier cId = null;
                EndpointIdentifier endpointIdentifier = null;
                CreateConnectionResponse createConnectionResponse = (CreateConnectionResponse)response;
                cId = createConnectionResponse.getConnectionIdentifier();
                endpointIdentifier = createConnectionResponse.getSpecificEndpointIdentifier();
                if (endpointIdentifier == null) {
                    endpointIdentifier = ((CreateConnection)command).getEndpointIdentifier();
                }
                this.processNonCreateConnectionMgcpEvent(cId, endpointIdentifier, response.getTransactionHandle(), "net.java.slee.resource.mgcp.CREATE_CONNECTION_RESPONSE", response, false);
                if (!MgcpResourceAdaptor.isFailure(response.getReturnCode())) break;
                this.endActivity(this.mgcpActivityManager.getMgcpConnectionActivityHandle(cId, endpointIdentifier, response.getTransactionHandle()));
                break;
            }
            case 204: {
                DeleteConnection deleteConnection = (DeleteConnection)command;
                if (deleteConnection.getConnectionIdentifier() != null) {
                    this.processNonCreateConnectionMgcpEvent(deleteConnection.getConnectionIdentifier(), deleteConnection.getEndpointIdentifier(), response.getTransactionHandle(), "net.java.slee.resource.mgcp.DELETE_CONNECTION_RESPONSE", response, false);
                    break;
                }
                this.processEndpointMgcpEvent(deleteConnection.getEndpointIdentifier(), "net.java.slee.resource.mgcp.DELETE_CONNECTION_RESPONSE", response, false);
                List<MgcpConnectionActivity> connActivities = this.mgcpProvider.getConnectionActivities(deleteConnection.getEndpointIdentifier());
                for (MgcpConnectionActivity connActivitiy : connActivities) {
                    this.processNonCreateConnectionMgcpEvent(new ConnectionIdentifier(connActivitiy.getConnectionIdentifier()), connActivitiy.getEndpointIdentifier(), response.getTransactionHandle(), "net.java.slee.resource.mgcp.DELETE_CONNECTION_RESPONSE", response, false);
                }
                break;
            }
            case 205: {
                this.processEndpointMgcpEvent(((EndpointConfiguration)command).getEndpointIdentifier(), "net.java.slee.resource.mgcp.ENDPOINT_CONFIGURATION_RESPONSE", response, false);
                break;
            }
            case 206: {
                ModifyConnection modifyConnection = (ModifyConnection)command;
                this.processNonCreateConnectionMgcpEvent(modifyConnection.getConnectionIdentifier(), modifyConnection.getEndpointIdentifier(), response.getTransactionHandle(), "net.java.slee.resource.mgcp.MODIFY_CONNECTION_RESPONSE", response, false);
                break;
            }
            case 207: {
                EventName[] signalEvents;
                NotificationRequest notificationRequest = (NotificationRequest)command;
                boolean processOnEndpoint = false;
                ArrayList<String> connectionIds = new ArrayList<String>();
                RequestedEvent[] requestedEvents = notificationRequest.getRequestedEvents();
                if (requestedEvents != null) {
                    for (RequestedEvent requestedEvent : requestedEvents) {
                        EventName detectEvent = requestedEvent.getEventName();
                        ConnectionIdentifier connectionIdentifier = detectEvent.getConnectionIdentifier();
                        if (connectionIdentifier != null) {
                            if (connectionIds.contains(connectionIdentifier.toString())) continue;
                            connectionIds.add(connectionIdentifier.toString());
                            continue;
                        }
                        processOnEndpoint = true;
                    }
                }
                if ((signalEvents = notificationRequest.getSignalRequests()) != null) {
                    for (int i = 0; i < signalEvents.length; ++i) {
                        EventName signalEvent = signalEvents[i];
                        ConnectionIdentifier connectionIdentifier = signalEvent.getConnectionIdentifier();
                        if (connectionIdentifier != null) {
                            if (connectionIds.contains(connectionIdentifier.toString())) continue;
                            connectionIds.add(connectionIdentifier.toString());
                            continue;
                        }
                        processOnEndpoint = true;
                    }
                }
                for (String s : connectionIds) {
                    this.processNonCreateConnectionMgcpEvent(new ConnectionIdentifier(s), notificationRequest.getEndpointIdentifier(), response.getTransactionHandle(), "net.java.slee.resource.mgcp.NOTIFICATION_REQUEST_RESPONSE", response, false);
                }
                if ((requestedEvents != null || signalEvents != null) && !processOnEndpoint) break;
                this.processEndpointMgcpEvent(notificationRequest.getEndpointIdentifier(), "net.java.slee.resource.mgcp.NOTIFICATION_REQUEST_RESPONSE", response, false);
                break;
            }
            case 208: {
                Notify notify = (Notify)command;
                boolean processOnEndpointNtfy = false;
                ArrayList<String> connectionIdsNtfy = new ArrayList<String>();
                EventName[] observedEvents = notify.getObservedEvents();
                if (observedEvents != null) {
                    for (int i = 0; i < observedEvents.length; ++i) {
                        EventName observedEvent = observedEvents[i];
                        ConnectionIdentifier connectionIdentifier = observedEvent.getConnectionIdentifier();
                        if (connectionIdentifier != null) {
                            if (connectionIdsNtfy.contains(connectionIdentifier.toString())) continue;
                            connectionIdsNtfy.add(connectionIdentifier.toString());
                            continue;
                        }
                        processOnEndpointNtfy = true;
                    }
                } else {
                    processOnEndpointNtfy = true;
                }
                for (String s : connectionIdsNtfy) {
                    this.processNonCreateConnectionMgcpEvent(new ConnectionIdentifier(s), notify.getEndpointIdentifier(), notify.getTransactionHandle(), "net.java.slee.resource.mgcp.NOTIFY_RESPONSE", response, false);
                }
                if (!processOnEndpointNtfy) break;
                this.processEndpointMgcpEvent(notify.getEndpointIdentifier(), "net.java.slee.resource.mgcp.NOTIFY_RESPONSE", response, false);
                break;
            }
            case 209: {
                this.processEndpointMgcpEvent(((RestartInProgress)command).getEndpointIdentifier(), "net.java.slee.resource.mgcp.RESTART_IN_PROGRESS_RESPONSE", response, false);
                break;
            }
            default: {
                this.tracer.warning("Unexpected event type: " + response.getObjectIdentifier());
            }
        }
    }

    protected void endActivity(ActivityHandle handle) {
        if (handle != null && this.mgcpActivityManager.containsActivityHandle(handle)) {
            try {
                this.getSleeEndpoint().endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("Failed to end activity with handle " + handle, (Throwable)e);
            }
        }
    }

    private void processNonCreateConnectionMgcpEvent(ConnectionIdentifier connectionIdentifier, EndpointIdentifier endpointIdentifier, int transactionHandle, String eventName, Object eventObject, boolean killActivity) {
        MgcpConnectionActivityHandle handle = this.mgcpActivityManager.getMgcpConnectionActivityHandle(connectionIdentifier, endpointIdentifier, transactionHandle);
        if (handle != null) {
            this.fireEvent(eventName, handle, eventObject);
            if (eventObject instanceof DeleteConnection || eventObject instanceof DeleteConnectionResponse || killActivity) {
                try {
                    this.getSleeEndpoint().endActivity((ActivityHandle)handle);
                }
                catch (Exception e) {
                    this.tracer.severe("Failed to end activity with handle " + handle, (Throwable)e);
                }
            }
        } else {
            FireableEventType eventID = this.eventIdCache.getEventId(this.resourceAdaptorContext.getEventLookupFacility(), eventName);
            if (this.eventIDFilter.isInitialEvent(eventID)) {
                MgcpConnectionActivityImpl newConnectionActivity = (MgcpConnectionActivityImpl)this.mgcpProvider.getConnectionActivity(connectionIdentifier, endpointIdentifier, true);
                if (newConnectionActivity != null) {
                    handle = newConnectionActivity.getActivityHandle();
                    this.fireEvent(eventName, handle, eventObject);
                    if (eventObject instanceof DeleteConnection || eventObject instanceof DeleteConnectionResponse) {
                        try {
                            this.getSleeEndpoint().endActivity((ActivityHandle)handle);
                        }
                        catch (Exception e) {
                            this.tracer.severe("Failed to end activity with handle " + handle, (Throwable)e);
                        }
                    }
                }
            } else if (this.tracer.isInfoEnabled()) {
                this.tracer.info("No MgcpConnectionActivity found for transactionHandle " + transactionHandle + " Not firirng event " + eventName);
            }
        }
    }

    private void processEndpointMgcpEvent(EndpointIdentifier endpointIdentifier, String eventName, Object eventObject, boolean killActivity) {
        MgcpEndpointActivityHandle handle = new MgcpEndpointActivityHandle(endpointIdentifier.toString());
        if (this.mgcpActivityManager.containsMgcpEndpointActivityHandle(handle)) {
            this.fireEvent(eventName, handle, eventObject);
            if (eventObject instanceof DeleteConnection || eventObject instanceof DeleteConnectionResponse || killActivity) {
                try {
                    this.getSleeEndpoint().endActivity((ActivityHandle)handle);
                }
                catch (Exception e) {
                    this.tracer.severe("Failed to end activity with handle " + handle, (Throwable)e);
                }
            }
        } else {
            FireableEventType eventID = this.eventIdCache.getEventId(this.resourceAdaptorContext.getEventLookupFacility(), eventName);
            if (this.eventIDFilter.isInitialEvent(eventID)) {
                MgcpEndpointActivityImpl mgcpEndpointActivity = (MgcpEndpointActivityImpl)this.mgcpProvider.getEndpointActivity(endpointIdentifier, true);
                if (mgcpEndpointActivity != null) {
                    handle = mgcpEndpointActivity.getActivityHandle();
                    this.fireEvent(eventName, handle, eventObject);
                    if (eventObject instanceof DeleteConnection || eventObject instanceof DeleteConnectionResponse) {
                        try {
                            this.getSleeEndpoint().endActivity((ActivityHandle)handle);
                        }
                        catch (Exception e) {
                            this.tracer.severe("Failed to end activity with handle " + handle, (Throwable)e);
                        }
                    }
                }
            } else if (this.tracer.isInfoEnabled()) {
                this.tracer.info("No MgcpEndpointActivity found for EndpointIdentifier " + endpointIdentifier + " Not firirng event " + eventName);
            }
        }
    }

    private void processCreateConnectionMgcpEvent(CreateConnection createConnection) {
        MgcpConnectionActivityImpl newConnectionActivity = (MgcpConnectionActivityImpl)this.mgcpProvider.getConnectionActivity(createConnection.getTransactionHandle(), createConnection.getEndpointIdentifier(), true);
        MgcpConnectionActivityHandle handle = newConnectionActivity.getActivityHandle();
        this.fireEvent("net.java.slee.resource.mgcp.CREATE_CONNECTION", handle, createConnection);
    }

    protected SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    protected MgcpActivityManager getMgcpActivityManager() {
        return this.mgcpActivityManager;
    }

    protected void sendingCreateConnectionResponse(CreateConnectionResponse event) {
        this.mgcpActivityManager.updateMgcpConnectionActivity(event.getTransactionHandle(), event.getConnectionIdentifier(), event.getSpecificEndpointIdentifier());
    }

    private static boolean isFailure(ReturnCode rc) {
        int rval = rc.getValue();
        return rval > 299;
    }

    public void processTxRxTimeout(JainMgcpCommandEvent event) {
        switch (event.getObjectIdentifier()) {
            case 101: {
                AuditConnection auditConnection = (AuditConnection)event;
                this.processNonCreateConnectionMgcpEvent(auditConnection.getConnectionIdentifier(), auditConnection.getEndpointIdentifier(), event.getTransactionHandle(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)auditConnection), true);
                break;
            }
            case 102: {
                AuditEndpoint auditEndpoint = (AuditEndpoint)event;
                this.processEndpointMgcpEvent(auditEndpoint.getEndpointIdentifier(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)auditEndpoint), true);
                break;
            }
            case 103: {
                EndpointIdentifier endpointIdentifier = null;
                CreateConnection createConnection = (CreateConnection)event;
                endpointIdentifier = createConnection.getEndpointIdentifier();
                this.processNonCreateConnectionMgcpEvent(null, endpointIdentifier, createConnection.getTransactionHandle(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)createConnection), true);
                break;
            }
            case 104: {
                DeleteConnection deleteConnection = (DeleteConnection)event;
                if (deleteConnection.getConnectionIdentifier() != null) {
                    this.processNonCreateConnectionMgcpEvent(deleteConnection.getConnectionIdentifier(), deleteConnection.getEndpointIdentifier(), deleteConnection.getTransactionHandle(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)deleteConnection), true);
                    break;
                }
                this.processEndpointMgcpEvent(deleteConnection.getEndpointIdentifier(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)deleteConnection), true);
                List<MgcpConnectionActivity> connActivities = this.mgcpProvider.getConnectionActivities(deleteConnection.getEndpointIdentifier());
                for (MgcpConnectionActivity connActivitiy : connActivities) {
                    this.processNonCreateConnectionMgcpEvent(new ConnectionIdentifier(connActivitiy.getConnectionIdentifier()), deleteConnection.getEndpointIdentifier(), deleteConnection.getTransactionHandle(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)deleteConnection), true);
                }
                break;
            }
            case 105: {
                EndpointConfiguration endpointConfiguration = (EndpointConfiguration)event;
                this.processEndpointMgcpEvent(endpointConfiguration.getEndpointIdentifier(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)endpointConfiguration), true);
                break;
            }
            case 106: {
                ModifyConnection modifyConnection = (ModifyConnection)event;
                this.processNonCreateConnectionMgcpEvent(modifyConnection.getConnectionIdentifier(), modifyConnection.getEndpointIdentifier(), modifyConnection.getTransactionHandle(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)modifyConnection), true);
                break;
            }
            case 107: {
                EventName[] signalEvents;
                NotificationRequest notificationRequest = (NotificationRequest)event;
                boolean processOnEndpoint = false;
                ArrayList<String> connectionIds = new ArrayList<String>();
                RequestedEvent[] requestedEvents = notificationRequest.getRequestedEvents();
                if (requestedEvents != null) {
                    for (RequestedEvent requestedEvent : requestedEvents) {
                        EventName detectEvent = requestedEvent.getEventName();
                        ConnectionIdentifier connectionIdentifier = detectEvent.getConnectionIdentifier();
                        if (connectionIdentifier != null) {
                            if (connectionIds.contains(connectionIdentifier.toString())) continue;
                            connectionIds.add(connectionIdentifier.toString());
                            continue;
                        }
                        processOnEndpoint = true;
                    }
                }
                if ((signalEvents = notificationRequest.getSignalRequests()) != null) {
                    for (int i = 0; i < signalEvents.length; ++i) {
                        EventName signalEvent = signalEvents[i];
                        ConnectionIdentifier connectionIdentifier = signalEvent.getConnectionIdentifier();
                        if (connectionIdentifier != null) {
                            if (connectionIds.contains(connectionIdentifier.toString())) continue;
                            connectionIds.add(connectionIdentifier.toString());
                            continue;
                        }
                        processOnEndpoint = true;
                    }
                }
                for (String s : connectionIds) {
                    this.processNonCreateConnectionMgcpEvent(new ConnectionIdentifier(s), notificationRequest.getEndpointIdentifier(), notificationRequest.getTransactionHandle(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)notificationRequest), true);
                }
                if ((requestedEvents != null || signalEvents != null) && !processOnEndpoint) break;
                this.processEndpointMgcpEvent(notificationRequest.getEndpointIdentifier(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)notificationRequest), true);
                break;
            }
            case 108: {
                Notify notify = (Notify)event;
                boolean processOnEndpointNtfy = false;
                ArrayList<String> connectionIdsNtfy = new ArrayList<String>();
                EventName[] observedEvents = notify.getObservedEvents();
                if (observedEvents != null) {
                    for (int i = 0; i < observedEvents.length; ++i) {
                        EventName observedEvent = observedEvents[i];
                        ConnectionIdentifier connectionIdentifier = observedEvent.getConnectionIdentifier();
                        if (connectionIdentifier != null) {
                            if (connectionIdsNtfy.contains(connectionIdentifier.toString())) continue;
                            connectionIdsNtfy.add(connectionIdentifier.toString());
                            continue;
                        }
                        processOnEndpointNtfy = true;
                    }
                } else {
                    processOnEndpointNtfy = true;
                }
                for (String s : connectionIdsNtfy) {
                    this.processNonCreateConnectionMgcpEvent(new ConnectionIdentifier(s), notify.getEndpointIdentifier(), notify.getTransactionHandle(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)notify), true);
                }
                if (!processOnEndpointNtfy) break;
                this.processEndpointMgcpEvent(notify.getEndpointIdentifier(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)notify), true);
                break;
            }
            case 109: {
                RestartInProgress restartInProgress = (RestartInProgress)event;
                this.processEndpointMgcpEvent(restartInProgress.getEndpointIdentifier(), "net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", new TransactionTimeout((JainMgcpCommandEvent)restartInProgress), true);
                break;
            }
            default: {
                this.tracer.severe("Unexpected event type: " + event.getObjectIdentifier());
            }
        }
    }

    public void processRxTimeout(JainMgcpCommandEvent event) {
        this.processTxRxTimeout(event);
    }

    public void processTxTimeout(JainMgcpCommandEvent event) {
        this.processTxRxTimeout(event);
    }

    private void fireEvent(String eventName, ActivityHandle handle, Object event) {
        FireableEventType eventID = this.eventIdCache.getEventId(this.resourceAdaptorContext.getEventLookupFacility(), eventName);
        if (eventID == null) {
            this.tracer.severe("Event id for " + eventID + " is unknown, cant fire!!!");
        } else {
            this.fireEvent(event, handle, eventID, address, true, false);
        }
    }

    private boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventID, Address address, boolean useFiltering, boolean transacted) {
        if (useFiltering && this.eventIDFilter.filterEvent(eventID)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Event " + eventID + " filtered");
            }
        } else {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Firing event " + event + " on handle " + handle);
            }
            try {
                if (transacted) {
                    this.resourceAdaptorContext.getSleeEndpoint().fireEventTransacted(handle, eventID, event, address, null, EVENT_FLAGS);
                } else {
                    this.resourceAdaptorContext.getSleeEndpoint().fireEvent(handle, eventID, event, address, null, EVENT_FLAGS);
                }
                return true;
            }
            catch (Exception e) {
                this.tracer.severe("Error firing event.", (Throwable)e);
            }
        }
        return false;
    }
}

