/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.en.us;

import com.sun.speech.freetts.VoiceManager;
import com.sun.speech.freetts.lexicon.LexiconImpl;
import com.sun.speech.freetts.util.BulkTimer;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class CMULexicon
extends LexiconImpl {
    private static final String VOWELS = "aeiou";
    private static final String GLIDES_LIQUIDS = "wylr";
    private static final String NASALS = "nm";
    private static final String VOICED_OBSTRUENTS = "bdgjlmnnnrvwyz";

    public CMULexicon(URL compiledURL, URL addendaURL, URL letterToSoundURL, boolean binary) {
        this.setLexiconParameters(compiledURL, addendaURL, letterToSoundURL, binary);
    }

    public CMULexicon() {
        this("cmulex");
    }

    public CMULexicon(String basename) {
        this(basename, true);
    }

    public CMULexicon(String basename, boolean useBinaryIO) {
        URLClassLoader classLoader = VoiceManager.getVoiceClassLoader();
        String type = useBinaryIO ? "bin" : "txt";
        URL letterToSoundURL = classLoader.getResource("com/sun/speech/freetts/en/us/" + basename + "_lts." + type);
        URL compiledURL = classLoader.getResource("com/sun/speech/freetts/en/us/" + basename + "_compiled." + type);
        URL addendaURL = classLoader.getResource("com/sun/speech/freetts/en/us/" + basename + "_addenda." + type);
        if (letterToSoundURL == null) {
            Class<CMULexicon> cls = CMULexicon.class;
            letterToSoundURL = cls.getResource(basename + "_lts." + type);
            compiledURL = cls.getResource(basename + "_compiled." + type);
            addendaURL = cls.getResource(basename + "_addenda." + type);
            if (letterToSoundURL == null) {
                System.err.println("CMULexicon: Oh no!  Couldn't find lexicon data!");
            }
        }
        this.setLexiconParameters(compiledURL, addendaURL, letterToSoundURL, useBinaryIO);
    }

    public static CMULexicon getInstance(boolean useBinaryIO) throws IOException {
        return CMULexicon.getInstance("cmulex", useBinaryIO);
    }

    public static CMULexicon getInstance(String basename, boolean useBinaryIO) throws IOException {
        CMULexicon lexicon = new CMULexicon(basename, useBinaryIO);
        lexicon.load();
        return lexicon;
    }

    public boolean isSyllableBoundary(List syllablePhones, String[] wordPhones, int currentWordPhone) {
        if (currentWordPhone >= wordPhones.length) {
            return true;
        }
        if (CMULexicon.isSilence(wordPhones[currentWordPhone])) {
            return true;
        }
        if (!CMULexicon.hasVowel(wordPhones, currentWordPhone)) {
            return false;
        }
        if (!CMULexicon.hasVowel(syllablePhones)) {
            return false;
        }
        if (CMULexicon.isVowel(wordPhones[currentWordPhone])) {
            return true;
        }
        if (currentWordPhone == wordPhones.length - 1) {
            return false;
        }
        int p = CMULexicon.getSonority((String)syllablePhones.get(syllablePhones.size() - 1));
        int n = CMULexicon.getSonority(wordPhones[currentWordPhone]);
        int nn = CMULexicon.getSonority(wordPhones[currentWordPhone + 1]);
        return p <= n && n <= nn;
    }

    protected static boolean isSilence(String phone) {
        return phone.equals("pau");
    }

    protected static boolean hasVowel(String[] phones, int index) {
        for (int i = index; i < phones.length; ++i) {
            if (!CMULexicon.isVowel(phones[i])) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasVowel(List phones) {
        for (int i = 0; i < phones.size(); ++i) {
            if (!CMULexicon.isVowel((String)phones.get(i))) continue;
            return true;
        }
        return false;
    }

    protected static boolean isVowel(String phone) {
        return VOWELS.indexOf(phone.substring(0, 1)) != -1;
    }

    protected static int getSonority(String phone) {
        if (CMULexicon.isVowel(phone) || CMULexicon.isSilence(phone)) {
            return 5;
        }
        if (GLIDES_LIQUIDS.indexOf(phone.substring(0, 1)) != -1) {
            return 4;
        }
        if (NASALS.indexOf(phone.substring(0, 1)) != -1) {
            return 3;
        }
        if (VOICED_OBSTRUENTS.indexOf(phone.substring(0, 1)) != -1) {
            return 2;
        }
        return 1;
    }

    public static void main(String[] args) {
        boolean showTimes = false;
        String srcPath = ".";
        String destPath = ".";
        String baseName = "cmulex";
        try {
            if (args.length > 0) {
                BulkTimer.LOAD.start();
                for (int i = 0; i < args.length; ++i) {
                    CMULexicon lex;
                    if (args[i].equals("-src")) {
                        srcPath = args[++i];
                        continue;
                    }
                    if (args[i].equals("-dest")) {
                        destPath = args[++i];
                        continue;
                    }
                    if (args[i].equals("-name") && i < args.length - 1) {
                        baseName = args[++i];
                        continue;
                    }
                    if (args[i].equals("-generate_binary")) {
                        System.out.println("Loading " + baseName);
                        String path = "file:" + srcPath + "/" + baseName;
                        lex = new CMULexicon(new URL(path + "_compiled.txt"), new URL(path + "_addenda.txt"), new URL(path + "_lts.txt"), false);
                        BulkTimer.LOAD.start("load_text");
                        lex.load();
                        BulkTimer.LOAD.stop("load_text");
                        System.out.println("Dumping " + baseName);
                        BulkTimer.LOAD.start("dump_text");
                        lex.dumpBinary(destPath + "/" + baseName);
                        BulkTimer.LOAD.stop("dump_text");
                        continue;
                    }
                    if (args[i].equals("-compare")) {
                        BulkTimer.LOAD.start("load_text");
                        lex = CMULexicon.getInstance(baseName, false);
                        BulkTimer.LOAD.stop("load_text");
                        BulkTimer.LOAD.start("load_binary");
                        CMULexicon lex2 = CMULexicon.getInstance(baseName, true);
                        BulkTimer.LOAD.stop("load_binary");
                        BulkTimer.LOAD.start("compare");
                        lex.compare(lex2);
                        BulkTimer.LOAD.stop("compare");
                        continue;
                    }
                    if (args[i].equals("-showtimes")) {
                        showTimes = true;
                        continue;
                    }
                    System.out.println("Unknown option " + args[i]);
                }
                BulkTimer.LOAD.stop();
                if (showTimes) {
                    BulkTimer.LOAD.show("CMULexicon loading and dumping");
                }
            } else {
                System.out.println("Options: ");
                System.out.println("    -src path");
                System.out.println("    -dest path");
                System.out.println("    -compare");
                System.out.println("    -generate_binary");
                System.out.println("    -showtimes");
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
    }
}

