/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.demo;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.mgcp.JainMgcpProvider;
import net.java.slee.resource.mgcp.MgcpActivityContextInterfaceFactory;
import org.mobicents.mgcp.demo.events.CustomEvent;

public abstract class ConfLegSbb
implements Sbb {
    public static final String ENDPOINT_NAME = "mobicents/ivr/$";
    public static final String JBOSS_BIND_ADDRESS = System.getProperty("jboss.bind.address", "127.0.0.1");
    public static final int MGCP_PEER_PORT = 2427;
    public static final int MGCP_PORT = 2727;
    private SbbContext sbbContext;
    private JainMgcpProvider mgcpProvider;
    private MgcpActivityContextInterfaceFactory mgcpAcif;
    private Tracer logger;

    public void onCallCreated(CustomEvent evt, ActivityContextInterface aci) {
        this.logger.info("Custom Event received Endpoint = " + evt.getEndpointID() + " Connection Id " + evt.getConnectionID().toString() + "Call Id = " + evt.getCallID().toString());
        this.setEndpointIdentifier(evt.getEndpointID());
        this.setConnectionIdentifier(evt.getConnectionID());
        this.setCallIdentifier(evt.getCallID());
    }

    public void onCallTerminated(CustomEvent evt, ActivityContextInterface aci) {
        this.logger.info("Conference Terminated " + this.getEndpointIdentifier() + " Connection Id " + this.getConnectionIdentifier().toString() + " callId = " + this.getCallIdentifier().toString());
        EndpointIdentifier endpointID = this.getEndpointIdentifier();
        ConnectionIdentifier connectionID = this.getConnectionIdentifier();
        DeleteConnection deleteConnection = new DeleteConnection((Object)this, this.getCallIdentifier(), endpointID, connectionID);
        deleteConnection.setTransactionHandle(this.mgcpProvider.getUniqueTransactionHandler());
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{deleteConnection});
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        this.logger = sbbContext.getTracer(ConfLegSbb.class.getSimpleName());
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.mgcpProvider = (JainMgcpProvider)ctx.lookup("slee/resources/jainmgcp/2.0/provider/demo");
            this.mgcpAcif = (MgcpActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainmgcp/2.0/acifactory/demo");
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public abstract EndpointIdentifier getEndpointIdentifier();

    public abstract void setEndpointIdentifier(EndpointIdentifier var1);

    public abstract CallIdentifier getCallIdentifier();

    public abstract void setCallIdentifier(CallIdentifier var1);

    public abstract ConnectionIdentifier getConnectionIdentifier();

    public abstract void setConnectionIdentifier(ConnectionIdentifier var1);

    public void unsetSbbContext() {
        this.sbbContext = null;
        this.logger = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbRemove() {
    }

    public void sbbExceptionThrown(Exception exception, Object object, ActivityContextInterface activityContextInterface) {
    }

    public void sbbRolledBack(RolledBackContext rolledBackContext) {
    }
}

