/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.commons.fsm;

import org.mobicents.commons.fsm.Condition;
import org.mobicents.commons.fsm.State;

public final class Transition {
    private final Condition condition;
    private final State stateOnEnter;
    private final State stateOnExit;

    public Transition(State stateOnEnter, State stateOnExit, Condition condition) {
        this.checkNotNull(stateOnEnter, stateOnExit);
        this.condition = condition;
        this.stateOnEnter = stateOnEnter;
        this.stateOnExit = stateOnExit;
    }

    private void checkNotNull(State stateOnEnter, State stateOnExit) throws NullPointerException {
        if (stateOnEnter == null || stateOnExit == null) {
            StringBuilder buffer = new StringBuilder();
            if (stateOnEnter == null) {
                buffer.append("A transition can not be built with a null value for the state on enter.");
            } else if (stateOnExit == null) {
                buffer.append("A transition can not be built with a null value for the state on exit.");
            }
            buffer.append(this.getClass().getName());
            throw new NullPointerException(buffer.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Transition transition = (Transition)object;
        if (!this.stateOnEnter.equals(transition.getStateOnEnter())) {
            return false;
        }
        return this.stateOnExit.equals(transition.getStateOnExit());
    }

    public Condition getCondition() {
        return this.condition;
    }

    public State getStateOnEnter() {
        return this.stateOnEnter;
    }

    public State getStateOnExit() {
        return this.stateOnExit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.stateOnEnter.hashCode();
        result = 31 * result + this.stateOnExit.hashCode();
        return result;
    }
}

