/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.commons.event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event<T> {
    private final Object source;
    private final Long timestamp;
    private final T type;

    public Event(Object source, Long timestamp, T type) {
        this.checkNotNull(source, timestamp, type);
        this.source = source;
        this.timestamp = timestamp;
        this.type = type;
    }

    private void checkNotNull(Object source, Long timestamp, T type) throws NullPointerException {
        if (source == null) {
            throw new NullPointerException("An event may not have a null source.");
        }
        if (timestamp == null) {
            throw new NullPointerException("An event may not have a null timestamp.");
        }
        if (type == null) {
            throw new NullPointerException("An event may not have a null type.");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Event event = (Event)object;
        if (!this.source.equals(event.getSource())) {
            return false;
        }
        if (!this.timestamp.equals(event.getTimestamp())) {
            return false;
        }
        return this.type.equals(event.getType());
    }

    public Object getSource() {
        return this.source;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public T getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 5;
        int result = 1;
        result = 5 * result + this.source.hashCode();
        result = 5 * result + this.timestamp.hashCode();
        result = 5 * result + this.type.hashCode();
        return result;
    }
}

