/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.ttp_1;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.data_marking.marking_1.MarkingType;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.mitre.stix.common_1.InformationSourceType;
import org.mitre.stix.common_1.KillChainPhasesReferenceType;
import org.mitre.stix.common_1.KillChainsType;
import org.mitre.stix.common_1.RelatedPackageRefsType;
import org.mitre.stix.common_1.StatementType;
import org.mitre.stix.common_1.StructuredTextType;
import org.mitre.stix.common_1.TTPBaseType;
import org.mitre.stix.ttp_1.BehaviorType;
import org.mitre.stix.ttp_1.ExploitTargetsType;
import org.mitre.stix.ttp_1.RelatedTTPsType;
import org.mitre.stix.ttp_1.ResourceType;
import org.mitre.stix.ttp_1.VictimTargetingType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TTPType", propOrder={"title", "descriptions", "shortDescriptions", "intendedEffects", "behavior", "resources", "victimTargeting", "exploitTargets", "relatedTTPs", "killChainPhases", "informationSource", "killChains", "handling", "relatedPackages"})
@XmlRootElement(name="TTP")
public class TTP
extends TTPBaseType
implements Equals,
HashCode,
ToString {
    @XmlElement(name="Title")
    protected String title;
    @XmlElement(name="Description")
    protected List<StructuredTextType> descriptions;
    @XmlElement(name="Short_Description")
    protected List<StructuredTextType> shortDescriptions;
    @XmlElement(name="Intended_Effect")
    protected List<StatementType> intendedEffects;
    @XmlElement(name="Behavior")
    protected BehaviorType behavior;
    @XmlElement(name="Resources")
    protected ResourceType resources;
    @XmlElement(name="Victim_Targeting")
    protected VictimTargetingType victimTargeting;
    @XmlElement(name="Exploit_Targets")
    protected ExploitTargetsType exploitTargets;
    @XmlElement(name="Related_TTPs")
    protected RelatedTTPsType relatedTTPs;
    @XmlElement(name="Kill_Chain_Phases")
    protected KillChainPhasesReferenceType killChainPhases;
    @XmlElement(name="Information_Source")
    protected InformationSourceType informationSource;
    @XmlElement(name="Kill_Chains")
    protected KillChainsType killChains;
    @XmlElement(name="Handling")
    protected MarkingType handling;
    @XmlElement(name="Related_Packages")
    protected RelatedPackageRefsType relatedPackages;
    @XmlAttribute(name="version")
    protected String version;

    public TTP() {
    }

    public TTP(QName id, QName idref, XMLGregorianCalendar timestamp, String title, List<StructuredTextType> descriptions, List<StructuredTextType> shortDescriptions, List<StatementType> intendedEffects, BehaviorType behavior, ResourceType resources, VictimTargetingType victimTargeting, ExploitTargetsType exploitTargets, RelatedTTPsType relatedTTPs, KillChainPhasesReferenceType killChainPhases, InformationSourceType informationSource, KillChainsType killChains, MarkingType handling, RelatedPackageRefsType relatedPackages, String version) {
        super(id, idref, timestamp);
        this.title = title;
        this.descriptions = descriptions;
        this.shortDescriptions = shortDescriptions;
        this.intendedEffects = intendedEffects;
        this.behavior = behavior;
        this.resources = resources;
        this.victimTargeting = victimTargeting;
        this.exploitTargets = exploitTargets;
        this.relatedTTPs = relatedTTPs;
        this.killChainPhases = killChainPhases;
        this.informationSource = informationSource;
        this.killChains = killChains;
        this.handling = handling;
        this.relatedPackages = relatedPackages;
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public List<StructuredTextType> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<StructuredTextType>();
        }
        return this.descriptions;
    }

    public List<StructuredTextType> getShortDescriptions() {
        if (this.shortDescriptions == null) {
            this.shortDescriptions = new ArrayList<StructuredTextType>();
        }
        return this.shortDescriptions;
    }

    public List<StatementType> getIntendedEffects() {
        if (this.intendedEffects == null) {
            this.intendedEffects = new ArrayList<StatementType>();
        }
        return this.intendedEffects;
    }

    public BehaviorType getBehavior() {
        return this.behavior;
    }

    public void setBehavior(BehaviorType value) {
        this.behavior = value;
    }

    public ResourceType getResources() {
        return this.resources;
    }

    public void setResources(ResourceType value) {
        this.resources = value;
    }

    public VictimTargetingType getVictimTargeting() {
        return this.victimTargeting;
    }

    public void setVictimTargeting(VictimTargetingType value) {
        this.victimTargeting = value;
    }

    public ExploitTargetsType getExploitTargets() {
        return this.exploitTargets;
    }

    public void setExploitTargets(ExploitTargetsType value) {
        this.exploitTargets = value;
    }

    public RelatedTTPsType getRelatedTTPs() {
        return this.relatedTTPs;
    }

    public void setRelatedTTPs(RelatedTTPsType value) {
        this.relatedTTPs = value;
    }

    public KillChainPhasesReferenceType getKillChainPhases() {
        return this.killChainPhases;
    }

    public void setKillChainPhases(KillChainPhasesReferenceType value) {
        this.killChainPhases = value;
    }

    public InformationSourceType getInformationSource() {
        return this.informationSource;
    }

    public void setInformationSource(InformationSourceType value) {
        this.informationSource = value;
    }

    public KillChainsType getKillChains() {
        return this.killChains;
    }

    public void setKillChains(KillChainsType value) {
        this.killChains = value;
    }

    public MarkingType getHandling() {
        return this.handling;
    }

    public void setHandling(MarkingType value) {
        this.handling = value;
    }

    public RelatedPackageRefsType getRelatedPackages() {
        return this.relatedPackages;
    }

    public void setRelatedPackages(RelatedPackageRefsType value) {
        this.relatedPackages = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<StatementType> rhsIntendedEffects;
        List<StructuredTextType> rhsShortDescriptions;
        List<StructuredTextType> rhsDescriptions;
        if (!(object instanceof TTP)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        TTP that = (TTP)object;
        String lhsTitle = this.getTitle();
        String rhsTitle = that.getTitle();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"title", (Object)lhsTitle), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"title", (Object)rhsTitle), (Object)lhsTitle, (Object)rhsTitle)) {
            return false;
        }
        List<StructuredTextType> lhsDescriptions = this.descriptions != null && !this.descriptions.isEmpty() ? this.getDescriptions() : null;
        List<StructuredTextType> list = rhsDescriptions = that.descriptions != null && !that.descriptions.isEmpty() ? that.getDescriptions() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"descriptions", lhsDescriptions), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"descriptions", rhsDescriptions), lhsDescriptions, rhsDescriptions)) {
            return false;
        }
        List<StructuredTextType> lhsShortDescriptions = this.shortDescriptions != null && !this.shortDescriptions.isEmpty() ? this.getShortDescriptions() : null;
        List<StructuredTextType> list2 = rhsShortDescriptions = that.shortDescriptions != null && !that.shortDescriptions.isEmpty() ? that.getShortDescriptions() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"shortDescriptions", lhsShortDescriptions), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"shortDescriptions", rhsShortDescriptions), lhsShortDescriptions, rhsShortDescriptions)) {
            return false;
        }
        List<StatementType> lhsIntendedEffects = this.intendedEffects != null && !this.intendedEffects.isEmpty() ? this.getIntendedEffects() : null;
        List<StatementType> list3 = rhsIntendedEffects = that.intendedEffects != null && !that.intendedEffects.isEmpty() ? that.getIntendedEffects() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"intendedEffects", lhsIntendedEffects), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"intendedEffects", rhsIntendedEffects), lhsIntendedEffects, rhsIntendedEffects)) {
            return false;
        }
        BehaviorType lhsBehavior = this.getBehavior();
        BehaviorType rhsBehavior = that.getBehavior();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"behavior", (Object)lhsBehavior), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"behavior", (Object)rhsBehavior), (Object)lhsBehavior, (Object)rhsBehavior)) {
            return false;
        }
        ResourceType lhsResources = this.getResources();
        ResourceType rhsResources = that.getResources();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"resources", (Object)lhsResources), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"resources", (Object)rhsResources), (Object)lhsResources, (Object)rhsResources)) {
            return false;
        }
        VictimTargetingType lhsVictimTargeting = this.getVictimTargeting();
        VictimTargetingType rhsVictimTargeting = that.getVictimTargeting();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"victimTargeting", (Object)lhsVictimTargeting), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"victimTargeting", (Object)rhsVictimTargeting), (Object)lhsVictimTargeting, (Object)rhsVictimTargeting)) {
            return false;
        }
        ExploitTargetsType lhsExploitTargets = this.getExploitTargets();
        ExploitTargetsType rhsExploitTargets = that.getExploitTargets();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"exploitTargets", (Object)lhsExploitTargets), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"exploitTargets", (Object)rhsExploitTargets), (Object)lhsExploitTargets, (Object)rhsExploitTargets)) {
            return false;
        }
        RelatedTTPsType lhsRelatedTTPs = this.getRelatedTTPs();
        RelatedTTPsType rhsRelatedTTPs = that.getRelatedTTPs();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"relatedTTPs", (Object)lhsRelatedTTPs), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"relatedTTPs", (Object)rhsRelatedTTPs), (Object)lhsRelatedTTPs, (Object)rhsRelatedTTPs)) {
            return false;
        }
        KillChainPhasesReferenceType lhsKillChainPhases = this.getKillChainPhases();
        KillChainPhasesReferenceType rhsKillChainPhases = that.getKillChainPhases();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"killChainPhases", (Object)lhsKillChainPhases), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"killChainPhases", (Object)rhsKillChainPhases), (Object)lhsKillChainPhases, (Object)rhsKillChainPhases)) {
            return false;
        }
        InformationSourceType lhsInformationSource = this.getInformationSource();
        InformationSourceType rhsInformationSource = that.getInformationSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"informationSource", (Object)lhsInformationSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"informationSource", (Object)rhsInformationSource), (Object)lhsInformationSource, (Object)rhsInformationSource)) {
            return false;
        }
        KillChainsType lhsKillChains = this.getKillChains();
        KillChainsType rhsKillChains = that.getKillChains();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"killChains", (Object)lhsKillChains), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"killChains", (Object)rhsKillChains), (Object)lhsKillChains, (Object)rhsKillChains)) {
            return false;
        }
        MarkingType lhsHandling = this.getHandling();
        MarkingType rhsHandling = that.getHandling();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"handling", (Object)lhsHandling), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"handling", (Object)rhsHandling), (Object)lhsHandling, (Object)rhsHandling)) {
            return false;
        }
        RelatedPackageRefsType lhsRelatedPackages = this.getRelatedPackages();
        RelatedPackageRefsType rhsRelatedPackages = that.getRelatedPackages();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"relatedPackages", (Object)lhsRelatedPackages), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"relatedPackages", (Object)rhsRelatedPackages), (Object)lhsRelatedPackages, (Object)rhsRelatedPackages)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theTitle = this.getTitle();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"title", (Object)theTitle), currentHashCode, (Object)theTitle);
        List<StructuredTextType> theDescriptions = this.descriptions != null && !this.descriptions.isEmpty() ? this.getDescriptions() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"descriptions", theDescriptions), currentHashCode, theDescriptions);
        List<StructuredTextType> theShortDescriptions = this.shortDescriptions != null && !this.shortDescriptions.isEmpty() ? this.getShortDescriptions() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"shortDescriptions", theShortDescriptions), currentHashCode, theShortDescriptions);
        List<StatementType> theIntendedEffects = this.intendedEffects != null && !this.intendedEffects.isEmpty() ? this.getIntendedEffects() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"intendedEffects", theIntendedEffects), currentHashCode, theIntendedEffects);
        BehaviorType theBehavior = this.getBehavior();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"behavior", (Object)theBehavior), currentHashCode, (Object)theBehavior);
        ResourceType theResources = this.getResources();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"resources", (Object)theResources), currentHashCode, (Object)theResources);
        VictimTargetingType theVictimTargeting = this.getVictimTargeting();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"victimTargeting", (Object)theVictimTargeting), currentHashCode, (Object)theVictimTargeting);
        ExploitTargetsType theExploitTargets = this.getExploitTargets();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"exploitTargets", (Object)theExploitTargets), currentHashCode, (Object)theExploitTargets);
        RelatedTTPsType theRelatedTTPs = this.getRelatedTTPs();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"relatedTTPs", (Object)theRelatedTTPs), currentHashCode, (Object)theRelatedTTPs);
        KillChainPhasesReferenceType theKillChainPhases = this.getKillChainPhases();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"killChainPhases", (Object)theKillChainPhases), currentHashCode, (Object)theKillChainPhases);
        InformationSourceType theInformationSource = this.getInformationSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"informationSource", (Object)theInformationSource), currentHashCode, (Object)theInformationSource);
        KillChainsType theKillChains = this.getKillChains();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"killChains", (Object)theKillChains), currentHashCode, (Object)theKillChains);
        MarkingType theHandling = this.getHandling();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"handling", (Object)theHandling), currentHashCode, (Object)theHandling);
        RelatedPackageRefsType theRelatedPackages = this.getRelatedPackages();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"relatedPackages", (Object)theRelatedPackages), currentHashCode, (Object)theRelatedPackages);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"version", (Object)theVersion), currentHashCode, (Object)theVersion);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public TTP withTitle(String value) {
        this.setTitle(value);
        return this;
    }

    public TTP withDescriptions(StructuredTextType ... values) {
        if (values != null) {
            for (StructuredTextType value : values) {
                this.getDescriptions().add(value);
            }
        }
        return this;
    }

    public TTP withDescriptions(Collection<StructuredTextType> values) {
        if (values != null) {
            this.getDescriptions().addAll(values);
        }
        return this;
    }

    public TTP withShortDescriptions(StructuredTextType ... values) {
        if (values != null) {
            for (StructuredTextType value : values) {
                this.getShortDescriptions().add(value);
            }
        }
        return this;
    }

    public TTP withShortDescriptions(Collection<StructuredTextType> values) {
        if (values != null) {
            this.getShortDescriptions().addAll(values);
        }
        return this;
    }

    public TTP withIntendedEffects(StatementType ... values) {
        if (values != null) {
            for (StatementType value : values) {
                this.getIntendedEffects().add(value);
            }
        }
        return this;
    }

    public TTP withIntendedEffects(Collection<StatementType> values) {
        if (values != null) {
            this.getIntendedEffects().addAll(values);
        }
        return this;
    }

    public TTP withBehavior(BehaviorType value) {
        this.setBehavior(value);
        return this;
    }

    public TTP withResources(ResourceType value) {
        this.setResources(value);
        return this;
    }

    public TTP withVictimTargeting(VictimTargetingType value) {
        this.setVictimTargeting(value);
        return this;
    }

    public TTP withExploitTargets(ExploitTargetsType value) {
        this.setExploitTargets(value);
        return this;
    }

    public TTP withRelatedTTPs(RelatedTTPsType value) {
        this.setRelatedTTPs(value);
        return this;
    }

    public TTP withKillChainPhases(KillChainPhasesReferenceType value) {
        this.setKillChainPhases(value);
        return this;
    }

    public TTP withInformationSource(InformationSourceType value) {
        this.setInformationSource(value);
        return this;
    }

    public TTP withKillChains(KillChainsType value) {
        this.setKillChains(value);
        return this;
    }

    public TTP withHandling(MarkingType value) {
        this.setHandling(value);
        return this;
    }

    public TTP withRelatedPackages(RelatedPackageRefsType value) {
        this.setRelatedPackages(value);
        return this;
    }

    public TTP withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    @Override
    public TTP withId(QName value) {
        this.setId(value);
        return this;
    }

    @Override
    public TTP withIdref(QName value) {
        this.setIdref(value);
        return this;
    }

    @Override
    public TTP withTimestamp(XMLGregorianCalendar value) {
        this.setTimestamp(value);
        return this;
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        String theTitle = this.getTitle();
        strategy.appendField(locator, (Object)this, "title", buffer, (Object)theTitle);
        List<StructuredTextType> theDescriptions = this.descriptions != null && !this.descriptions.isEmpty() ? this.getDescriptions() : null;
        strategy.appendField(locator, (Object)this, "descriptions", buffer, theDescriptions);
        List<StructuredTextType> theShortDescriptions = this.shortDescriptions != null && !this.shortDescriptions.isEmpty() ? this.getShortDescriptions() : null;
        strategy.appendField(locator, (Object)this, "shortDescriptions", buffer, theShortDescriptions);
        List<StatementType> theIntendedEffects = this.intendedEffects != null && !this.intendedEffects.isEmpty() ? this.getIntendedEffects() : null;
        strategy.appendField(locator, (Object)this, "intendedEffects", buffer, theIntendedEffects);
        BehaviorType theBehavior = this.getBehavior();
        strategy.appendField(locator, (Object)this, "behavior", buffer, (Object)theBehavior);
        ResourceType theResources = this.getResources();
        strategy.appendField(locator, (Object)this, "resources", buffer, (Object)theResources);
        VictimTargetingType theVictimTargeting = this.getVictimTargeting();
        strategy.appendField(locator, (Object)this, "victimTargeting", buffer, (Object)theVictimTargeting);
        ExploitTargetsType theExploitTargets = this.getExploitTargets();
        strategy.appendField(locator, (Object)this, "exploitTargets", buffer, (Object)theExploitTargets);
        RelatedTTPsType theRelatedTTPs = this.getRelatedTTPs();
        strategy.appendField(locator, (Object)this, "relatedTTPs", buffer, (Object)theRelatedTTPs);
        KillChainPhasesReferenceType theKillChainPhases = this.getKillChainPhases();
        strategy.appendField(locator, (Object)this, "killChainPhases", buffer, (Object)theKillChainPhases);
        InformationSourceType theInformationSource = this.getInformationSource();
        strategy.appendField(locator, (Object)this, "informationSource", buffer, (Object)theInformationSource);
        KillChainsType theKillChains = this.getKillChains();
        strategy.appendField(locator, (Object)this, "killChains", buffer, (Object)theKillChains);
        MarkingType theHandling = this.getHandling();
        strategy.appendField(locator, (Object)this, "handling", buffer, (Object)theHandling);
        RelatedPackageRefsType theRelatedPackages = this.getRelatedPackages();
        strategy.appendField(locator, (Object)this, "relatedPackages", buffer, (Object)theRelatedPackages);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion);
        return buffer;
    }

    @Override
    public Document toDocument() {
        return this.toDocument(false);
    }

    @Override
    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    @Override
    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, TTP.class, (Object)this);
    }

    @Override
    public String toXMLString() {
        return this.toXMLString(false);
    }

    @Override
    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static TTP fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)TTP.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (TTP)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

