/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.ttp_1;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.mitre.stix.ttp_1.AttackPatternType;
import org.mitre.stix.ttp_1.AttackPatternsType;
import org.mitre.stix.ttp_1.BehaviorType;
import org.mitre.stix.ttp_1.ExploitTargetsType;
import org.mitre.stix.ttp_1.ExploitType;
import org.mitre.stix.ttp_1.ExploitsType;
import org.mitre.stix.ttp_1.InfrastructureType;
import org.mitre.stix.ttp_1.MalwareInstanceType;
import org.mitre.stix.ttp_1.MalwareType;
import org.mitre.stix.ttp_1.PersonasType;
import org.mitre.stix.ttp_1.RelatedTTPsType;
import org.mitre.stix.ttp_1.ResourceType;
import org.mitre.stix.ttp_1.TTP;
import org.mitre.stix.ttp_1.ToolsType;
import org.mitre.stix.ttp_1.VictimTargetingType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlRegistry
public class ObjectFactory {
    public TTP createTTP() {
        return new TTP();
    }

    public BehaviorType createBehaviorType() {
        return new BehaviorType();
    }

    public ResourceType createResourceType() {
        return new ResourceType();
    }

    public VictimTargetingType createVictimTargetingType() {
        return new VictimTargetingType();
    }

    public ExploitTargetsType createExploitTargetsType() {
        return new ExploitTargetsType();
    }

    public RelatedTTPsType createRelatedTTPsType() {
        return new RelatedTTPsType();
    }

    public PersonasType createPersonasType() {
        return new PersonasType();
    }

    public AttackPatternType createAttackPatternType() {
        return new AttackPatternType();
    }

    public ToolsType createToolsType() {
        return new ToolsType();
    }

    public MalwareType createMalwareType() {
        return new MalwareType();
    }

    public MalwareInstanceType createMalwareInstanceType() {
        return new MalwareInstanceType();
    }

    public ExploitType createExploitType() {
        return new ExploitType();
    }

    public AttackPatternsType createAttackPatternsType() {
        return new AttackPatternsType();
    }

    public InfrastructureType createInfrastructureType() {
        return new InfrastructureType();
    }

    public ExploitsType createExploitsType() {
        return new ExploitsType();
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, ObjectFactory.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static ObjectFactory fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (ObjectFactory)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

