/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.report_1;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.mitre.stix.report_1.CampaignsType;
import org.mitre.stix.report_1.CoursesOfActionType;
import org.mitre.stix.report_1.HeaderType;
import org.mitre.stix.report_1.IncidentsType;
import org.mitre.stix.report_1.IndicatorsType;
import org.mitre.stix.report_1.RelatedReportsType;
import org.mitre.stix.report_1.Report;
import org.mitre.stix.report_1.TTPsType;
import org.mitre.stix.report_1.ThreatActorsType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlRegistry
public class ObjectFactory {
    public Report createReport() {
        return new Report();
    }

    public HeaderType createHeaderType() {
        return new HeaderType();
    }

    public IndicatorsType createIndicatorsType() {
        return new IndicatorsType();
    }

    public TTPsType createTTPsType() {
        return new TTPsType();
    }

    public IncidentsType createIncidentsType() {
        return new IncidentsType();
    }

    public CoursesOfActionType createCoursesOfActionType() {
        return new CoursesOfActionType();
    }

    public CampaignsType createCampaignsType() {
        return new CampaignsType();
    }

    public ThreatActorsType createThreatActorsType() {
        return new ThreatActorsType();
    }

    public RelatedReportsType createRelatedReportsType() {
        return new RelatedReportsType();
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, ObjectFactory.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static ObjectFactory fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (ObjectFactory)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

