/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.indicator_2;

import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.mitre.stix.indicator_2.SightingType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SightingsType", propOrder={"sightings"})
public class SightingsType
implements Equals,
HashCode,
ToString {
    @XmlElement(name="Sighting")
    protected List<SightingType> sightings;
    @XmlAttribute(name="sightings_count")
    protected BigInteger sightingsCount;

    public SightingsType() {
    }

    public SightingsType(List<SightingType> sightings, BigInteger sightingsCount) {
        this.sightings = sightings;
        this.sightingsCount = sightingsCount;
    }

    public List<SightingType> getSightings() {
        if (this.sightings == null) {
            this.sightings = new ArrayList<SightingType>();
        }
        return this.sightings;
    }

    public BigInteger getSightingsCount() {
        return this.sightingsCount;
    }

    public void setSightingsCount(BigInteger value) {
        this.sightingsCount = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<SightingType> rhsSightings;
        if (!(object instanceof SightingsType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        SightingsType that = (SightingsType)object;
        List<SightingType> lhsSightings = this.sightings != null && !this.sightings.isEmpty() ? this.getSightings() : null;
        List<SightingType> list = rhsSightings = that.sightings != null && !that.sightings.isEmpty() ? that.getSightings() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"sightings", lhsSightings), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"sightings", rhsSightings), lhsSightings, rhsSightings)) {
            return false;
        }
        BigInteger lhsSightingsCount = this.getSightingsCount();
        BigInteger rhsSightingsCount = that.getSightingsCount();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"sightingsCount", (Object)lhsSightingsCount), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"sightingsCount", (Object)rhsSightingsCount), (Object)lhsSightingsCount, (Object)rhsSightingsCount);
    }

    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        List<SightingType> theSightings = this.sightings != null && !this.sightings.isEmpty() ? this.getSightings() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"sightings", theSightings), currentHashCode, theSightings);
        BigInteger theSightingsCount = this.getSightingsCount();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"sightingsCount", (Object)theSightingsCount), currentHashCode, (Object)theSightingsCount);
        return currentHashCode;
    }

    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public SightingsType withSightings(SightingType ... values) {
        if (values != null) {
            for (SightingType value : values) {
                this.getSightings().add(value);
            }
        }
        return this;
    }

    public SightingsType withSightings(Collection<SightingType> values) {
        if (values != null) {
            this.getSightings().addAll(values);
        }
        return this;
    }

    public SightingsType withSightingsCount(BigInteger value) {
        this.setSightingsCount(value);
        return this;
    }

    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        List<SightingType> theSightings = this.sightings != null && !this.sightings.isEmpty() ? this.getSightings() : null;
        strategy.appendField(locator, (Object)this, "sightings", buffer, theSightings);
        BigInteger theSightingsCount = this.getSightingsCount();
        strategy.appendField(locator, (Object)this, "sightingsCount", buffer, (Object)theSightingsCount);
        return buffer;
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, SightingsType.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static SightingsType fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)SightingsType.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (SightingsType)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

