/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.incident_1;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.mitre.stix.incident_1.AffectedAssetType;
import org.mitre.stix.incident_1.AffectedAssetsType;
import org.mitre.stix.incident_1.AssetTypeType;
import org.mitre.stix.incident_1.AttributedThreatActorsType;
import org.mitre.stix.incident_1.COARequestedType;
import org.mitre.stix.incident_1.COATakenType;
import org.mitre.stix.incident_1.COATimeType;
import org.mitre.stix.incident_1.CategoriesType;
import org.mitre.stix.incident_1.ContributorsType;
import org.mitre.stix.incident_1.DirectImpactSummaryType;
import org.mitre.stix.incident_1.EffectsType;
import org.mitre.stix.incident_1.ExternalIDType;
import org.mitre.stix.incident_1.HistoryItemType;
import org.mitre.stix.incident_1.HistoryType;
import org.mitre.stix.incident_1.ImpactAssessmentType;
import org.mitre.stix.incident_1.Incident;
import org.mitre.stix.incident_1.IndirectImpactSummaryType;
import org.mitre.stix.incident_1.JournalEntryType;
import org.mitre.stix.incident_1.LeveragedTTPsType;
import org.mitre.stix.incident_1.LossEstimationType;
import org.mitre.stix.incident_1.NatureOfSecurityEffectType;
import org.mitre.stix.incident_1.NonPublicDataCompromisedType;
import org.mitre.stix.incident_1.PropertyAffectedType;
import org.mitre.stix.incident_1.RelatedIncidentsType;
import org.mitre.stix.incident_1.RelatedIndicatorsType;
import org.mitre.stix.incident_1.RelatedObservablesType;
import org.mitre.stix.incident_1.TimeType;
import org.mitre.stix.incident_1.TotalLossEstimationType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlRegistry
public class ObjectFactory {
    public Incident createIncident() {
        return new Incident();
    }

    public ExternalIDType createExternalIDType() {
        return new ExternalIDType();
    }

    public TimeType createTimeType() {
        return new TimeType();
    }

    public CategoriesType createCategoriesType() {
        return new CategoriesType();
    }

    public AffectedAssetsType createAffectedAssetsType() {
        return new AffectedAssetsType();
    }

    public ImpactAssessmentType createImpactAssessmentType() {
        return new ImpactAssessmentType();
    }

    public RelatedIndicatorsType createRelatedIndicatorsType() {
        return new RelatedIndicatorsType();
    }

    public RelatedObservablesType createRelatedObservablesType() {
        return new RelatedObservablesType();
    }

    public LeveragedTTPsType createLeveragedTTPsType() {
        return new LeveragedTTPsType();
    }

    public AttributedThreatActorsType createAttributedThreatActorsType() {
        return new AttributedThreatActorsType();
    }

    public RelatedIncidentsType createRelatedIncidentsType() {
        return new RelatedIncidentsType();
    }

    public COARequestedType createCOARequestedType() {
        return new COARequestedType();
    }

    public COATakenType createCOATakenType() {
        return new COATakenType();
    }

    public HistoryType createHistoryType() {
        return new HistoryType();
    }

    public EffectsType createEffectsType() {
        return new EffectsType();
    }

    public HistoryItemType createHistoryItemType() {
        return new HistoryItemType();
    }

    public AffectedAssetType createAffectedAssetType() {
        return new AffectedAssetType();
    }

    public LossEstimationType createLossEstimationType() {
        return new LossEstimationType();
    }

    public AssetTypeType createAssetTypeType() {
        return new AssetTypeType();
    }

    public DirectImpactSummaryType createDirectImpactSummaryType() {
        return new DirectImpactSummaryType();
    }

    public NonPublicDataCompromisedType createNonPublicDataCompromisedType() {
        return new NonPublicDataCompromisedType();
    }

    public ContributorsType createContributorsType() {
        return new ContributorsType();
    }

    public TotalLossEstimationType createTotalLossEstimationType() {
        return new TotalLossEstimationType();
    }

    public IndirectImpactSummaryType createIndirectImpactSummaryType() {
        return new IndirectImpactSummaryType();
    }

    public NatureOfSecurityEffectType createNatureOfSecurityEffectType() {
        return new NatureOfSecurityEffectType();
    }

    public JournalEntryType createJournalEntryType() {
        return new JournalEntryType();
    }

    public COATimeType createCOATimeType() {
        return new COATimeType();
    }

    public PropertyAffectedType createPropertyAffectedType() {
        return new PropertyAffectedType();
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, ObjectFactory.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static ObjectFactory fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (ObjectFactory)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

