/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.extensions.testmechanism;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.mitre.stix.common_1.EncodedCDATAType;
import org.mitre.stix.common_1.InformationSourceType;
import org.mitre.stix.common_1.StatementType;
import org.mitre.stix.indicator_2.TestMechanismType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SnortTestMechanismType", namespace="http://stix.mitre.org/extensions/TestMechanism#Snort-1", propOrder={"productName", "version", "rules", "eventFilters", "rateFilters", "eventSuppressions"})
public class SnortTestMechanismType
extends TestMechanismType
implements Equals,
HashCode,
ToString {
    @XmlElement(name="Product_Name")
    protected String productName;
    @XmlElement(name="Version")
    protected String version;
    @XmlElement(name="Rule")
    protected List<EncodedCDATAType> rules;
    @XmlElement(name="Event_Filter")
    protected List<EncodedCDATAType> eventFilters;
    @XmlElement(name="Rate_Filter")
    protected List<EncodedCDATAType> rateFilters;
    @XmlElement(name="Event_Suppression")
    protected List<EncodedCDATAType> eventSuppressions;

    public SnortTestMechanismType() {
    }

    public SnortTestMechanismType(StatementType efficacy, InformationSourceType producer, QName id, QName idref, String productName, String version, List<EncodedCDATAType> rules, List<EncodedCDATAType> eventFilters, List<EncodedCDATAType> rateFilters, List<EncodedCDATAType> eventSuppressions) {
        super(efficacy, producer, id, idref);
        this.productName = productName;
        this.version = version;
        this.rules = rules;
        this.eventFilters = eventFilters;
        this.rateFilters = rateFilters;
        this.eventSuppressions = eventSuppressions;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String value) {
        this.productName = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public List<EncodedCDATAType> getRules() {
        if (this.rules == null) {
            this.rules = new ArrayList<EncodedCDATAType>();
        }
        return this.rules;
    }

    public List<EncodedCDATAType> getEventFilters() {
        if (this.eventFilters == null) {
            this.eventFilters = new ArrayList<EncodedCDATAType>();
        }
        return this.eventFilters;
    }

    public List<EncodedCDATAType> getRateFilters() {
        if (this.rateFilters == null) {
            this.rateFilters = new ArrayList<EncodedCDATAType>();
        }
        return this.rateFilters;
    }

    public List<EncodedCDATAType> getEventSuppressions() {
        if (this.eventSuppressions == null) {
            this.eventSuppressions = new ArrayList<EncodedCDATAType>();
        }
        return this.eventSuppressions;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<EncodedCDATAType> rhsEventSuppressions;
        List<EncodedCDATAType> rhsRateFilters;
        List<EncodedCDATAType> rhsEventFilters;
        List<EncodedCDATAType> rhsRules;
        if (!(object instanceof SnortTestMechanismType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        SnortTestMechanismType that = (SnortTestMechanismType)object;
        String lhsProductName = this.getProductName();
        String rhsProductName = that.getProductName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"productName", (Object)lhsProductName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"productName", (Object)rhsProductName), (Object)lhsProductName, (Object)rhsProductName)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion)) {
            return false;
        }
        List<EncodedCDATAType> lhsRules = this.rules != null && !this.rules.isEmpty() ? this.getRules() : null;
        List<EncodedCDATAType> list = rhsRules = that.rules != null && !that.rules.isEmpty() ? that.getRules() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"rules", lhsRules), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"rules", rhsRules), lhsRules, rhsRules)) {
            return false;
        }
        List<EncodedCDATAType> lhsEventFilters = this.eventFilters != null && !this.eventFilters.isEmpty() ? this.getEventFilters() : null;
        List<EncodedCDATAType> list2 = rhsEventFilters = that.eventFilters != null && !that.eventFilters.isEmpty() ? that.getEventFilters() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"eventFilters", lhsEventFilters), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"eventFilters", rhsEventFilters), lhsEventFilters, rhsEventFilters)) {
            return false;
        }
        List<EncodedCDATAType> lhsRateFilters = this.rateFilters != null && !this.rateFilters.isEmpty() ? this.getRateFilters() : null;
        List<EncodedCDATAType> list3 = rhsRateFilters = that.rateFilters != null && !that.rateFilters.isEmpty() ? that.getRateFilters() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"rateFilters", lhsRateFilters), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"rateFilters", rhsRateFilters), lhsRateFilters, rhsRateFilters)) {
            return false;
        }
        List<EncodedCDATAType> lhsEventSuppressions = this.eventSuppressions != null && !this.eventSuppressions.isEmpty() ? this.getEventSuppressions() : null;
        List<EncodedCDATAType> list4 = rhsEventSuppressions = that.eventSuppressions != null && !that.eventSuppressions.isEmpty() ? that.getEventSuppressions() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"eventSuppressions", lhsEventSuppressions), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"eventSuppressions", rhsEventSuppressions), lhsEventSuppressions, rhsEventSuppressions);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theProductName = this.getProductName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"productName", (Object)theProductName), currentHashCode, (Object)theProductName);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"version", (Object)theVersion), currentHashCode, (Object)theVersion);
        List<EncodedCDATAType> theRules = this.rules != null && !this.rules.isEmpty() ? this.getRules() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"rules", theRules), currentHashCode, theRules);
        List<EncodedCDATAType> theEventFilters = this.eventFilters != null && !this.eventFilters.isEmpty() ? this.getEventFilters() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"eventFilters", theEventFilters), currentHashCode, theEventFilters);
        List<EncodedCDATAType> theRateFilters = this.rateFilters != null && !this.rateFilters.isEmpty() ? this.getRateFilters() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"rateFilters", theRateFilters), currentHashCode, theRateFilters);
        List<EncodedCDATAType> theEventSuppressions = this.eventSuppressions != null && !this.eventSuppressions.isEmpty() ? this.getEventSuppressions() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"eventSuppressions", theEventSuppressions), currentHashCode, theEventSuppressions);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public SnortTestMechanismType withProductName(String value) {
        this.setProductName(value);
        return this;
    }

    public SnortTestMechanismType withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public SnortTestMechanismType withRules(EncodedCDATAType ... values) {
        if (values != null) {
            for (EncodedCDATAType value : values) {
                this.getRules().add(value);
            }
        }
        return this;
    }

    public SnortTestMechanismType withRules(Collection<EncodedCDATAType> values) {
        if (values != null) {
            this.getRules().addAll(values);
        }
        return this;
    }

    public SnortTestMechanismType withEventFilters(EncodedCDATAType ... values) {
        if (values != null) {
            for (EncodedCDATAType value : values) {
                this.getEventFilters().add(value);
            }
        }
        return this;
    }

    public SnortTestMechanismType withEventFilters(Collection<EncodedCDATAType> values) {
        if (values != null) {
            this.getEventFilters().addAll(values);
        }
        return this;
    }

    public SnortTestMechanismType withRateFilters(EncodedCDATAType ... values) {
        if (values != null) {
            for (EncodedCDATAType value : values) {
                this.getRateFilters().add(value);
            }
        }
        return this;
    }

    public SnortTestMechanismType withRateFilters(Collection<EncodedCDATAType> values) {
        if (values != null) {
            this.getRateFilters().addAll(values);
        }
        return this;
    }

    public SnortTestMechanismType withEventSuppressions(EncodedCDATAType ... values) {
        if (values != null) {
            for (EncodedCDATAType value : values) {
                this.getEventSuppressions().add(value);
            }
        }
        return this;
    }

    public SnortTestMechanismType withEventSuppressions(Collection<EncodedCDATAType> values) {
        if (values != null) {
            this.getEventSuppressions().addAll(values);
        }
        return this;
    }

    @Override
    public SnortTestMechanismType withEfficacy(StatementType value) {
        this.setEfficacy(value);
        return this;
    }

    @Override
    public SnortTestMechanismType withProducer(InformationSourceType value) {
        this.setProducer(value);
        return this;
    }

    @Override
    public SnortTestMechanismType withId(QName value) {
        this.setId(value);
        return this;
    }

    @Override
    public SnortTestMechanismType withIdref(QName value) {
        this.setIdref(value);
        return this;
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        String theProductName = this.getProductName();
        strategy.appendField(locator, (Object)this, "productName", buffer, (Object)theProductName);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion);
        List<EncodedCDATAType> theRules = this.rules != null && !this.rules.isEmpty() ? this.getRules() : null;
        strategy.appendField(locator, (Object)this, "rules", buffer, theRules);
        List<EncodedCDATAType> theEventFilters = this.eventFilters != null && !this.eventFilters.isEmpty() ? this.getEventFilters() : null;
        strategy.appendField(locator, (Object)this, "eventFilters", buffer, theEventFilters);
        List<EncodedCDATAType> theRateFilters = this.rateFilters != null && !this.rateFilters.isEmpty() ? this.getRateFilters() : null;
        strategy.appendField(locator, (Object)this, "rateFilters", buffer, theRateFilters);
        List<EncodedCDATAType> theEventSuppressions = this.eventSuppressions != null && !this.eventSuppressions.isEmpty() ? this.getEventSuppressions() : null;
        strategy.appendField(locator, (Object)this, "eventSuppressions", buffer, theEventSuppressions);
        return buffer;
    }

    @Override
    public Document toDocument() {
        return this.toDocument(false);
    }

    @Override
    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    @Override
    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, SnortTestMechanismType.class, (Object)this);
    }

    @Override
    public String toXMLString() {
        return this.toXMLString(false);
    }

    @Override
    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static SnortTestMechanismType fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)SnortTestMechanismType.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (SnortTestMechanismType)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

