/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.extensions.testmechanism;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.mitre.stix.extensions.testmechanism.GenericTestMechanismType;
import org.mitre.stix.extensions.testmechanism.OVAL510TestMechanismType;
import org.mitre.stix.extensions.testmechanism.OpenIOC2010TestMechanismType;
import org.mitre.stix.extensions.testmechanism.SnortTestMechanismType;
import org.mitre.stix.extensions.testmechanism.YaraTestMechanismType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlRegistry
public class ObjectFactory {
    public OVAL510TestMechanismType createOVAL510TestMechanismType() {
        return new OVAL510TestMechanismType();
    }

    public YaraTestMechanismType createYaraTestMechanismType() {
        return new YaraTestMechanismType();
    }

    public GenericTestMechanismType createGenericTestMechanismType() {
        return new GenericTestMechanismType();
    }

    public SnortTestMechanismType createSnortTestMechanismType() {
        return new SnortTestMechanismType();
    }

    public OpenIOC2010TestMechanismType createOpenIOC2010TestMechanismType() {
        return new OpenIOC2010TestMechanismType();
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, ObjectFactory.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static ObjectFactory fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (ObjectFactory)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

