/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.exploittarget_1;

import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.mitre.stix.common_1.DateTimeWithPrecisionType;
import org.mitre.stix.common_1.ReferencesType;
import org.mitre.stix.common_1.StructuredTextType;
import org.mitre.stix.exploittarget_1.AffectedSoftwareType;
import org.mitre.stix.exploittarget_1.CVSSVectorType;
import org.mitre.stix.extensions.vulnerability.CVRF11InstanceType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="VulnerabilityType", propOrder={"title", "descriptions", "shortDescriptions", "cveid", "osvdbid", "source", "cvssScore", "discoveredDateTime", "publishedDateTime", "affectedSoftware", "references"})
@XmlSeeAlso(value={CVRF11InstanceType.class})
public class VulnerabilityType
implements Equals,
HashCode,
ToString {
    @XmlElement(name="Title")
    protected String title;
    @XmlElement(name="Description")
    protected List<StructuredTextType> descriptions;
    @XmlElement(name="Short_Description")
    protected List<StructuredTextType> shortDescriptions;
    @XmlElement(name="CVE_ID")
    protected String cveid;
    @XmlElement(name="OSVDB_ID")
    @XmlSchemaType(name="positiveInteger")
    protected BigInteger osvdbid;
    @XmlElement(name="Source")
    protected String source;
    @XmlElement(name="CVSS_Score")
    protected CVSSVectorType cvssScore;
    @XmlElement(name="Discovered_DateTime")
    protected DateTimeWithPrecisionType discoveredDateTime;
    @XmlElement(name="Published_DateTime")
    protected DateTimeWithPrecisionType publishedDateTime;
    @XmlElement(name="Affected_Software")
    protected AffectedSoftwareType affectedSoftware;
    @XmlElement(name="References")
    protected ReferencesType references;
    @XmlAttribute(name="is_known")
    protected Boolean isKnown;
    @XmlAttribute(name="is_publicly_acknowledged")
    protected Boolean isPubliclyAcknowledged;

    public VulnerabilityType() {
    }

    public VulnerabilityType(String title, List<StructuredTextType> descriptions, List<StructuredTextType> shortDescriptions, String cveid, BigInteger osvdbid, String source, CVSSVectorType cvssScore, DateTimeWithPrecisionType discoveredDateTime, DateTimeWithPrecisionType publishedDateTime, AffectedSoftwareType affectedSoftware, ReferencesType references, Boolean isKnown, Boolean isPubliclyAcknowledged) {
        this.title = title;
        this.descriptions = descriptions;
        this.shortDescriptions = shortDescriptions;
        this.cveid = cveid;
        this.osvdbid = osvdbid;
        this.source = source;
        this.cvssScore = cvssScore;
        this.discoveredDateTime = discoveredDateTime;
        this.publishedDateTime = publishedDateTime;
        this.affectedSoftware = affectedSoftware;
        this.references = references;
        this.isKnown = isKnown;
        this.isPubliclyAcknowledged = isPubliclyAcknowledged;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public List<StructuredTextType> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<StructuredTextType>();
        }
        return this.descriptions;
    }

    public List<StructuredTextType> getShortDescriptions() {
        if (this.shortDescriptions == null) {
            this.shortDescriptions = new ArrayList<StructuredTextType>();
        }
        return this.shortDescriptions;
    }

    public String getCVEID() {
        return this.cveid;
    }

    public void setCVEID(String value) {
        this.cveid = value;
    }

    public BigInteger getOSVDBID() {
        return this.osvdbid;
    }

    public void setOSVDBID(BigInteger value) {
        this.osvdbid = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public CVSSVectorType getCVSSScore() {
        return this.cvssScore;
    }

    public void setCVSSScore(CVSSVectorType value) {
        this.cvssScore = value;
    }

    public DateTimeWithPrecisionType getDiscoveredDateTime() {
        return this.discoveredDateTime;
    }

    public void setDiscoveredDateTime(DateTimeWithPrecisionType value) {
        this.discoveredDateTime = value;
    }

    public DateTimeWithPrecisionType getPublishedDateTime() {
        return this.publishedDateTime;
    }

    public void setPublishedDateTime(DateTimeWithPrecisionType value) {
        this.publishedDateTime = value;
    }

    public AffectedSoftwareType getAffectedSoftware() {
        return this.affectedSoftware;
    }

    public void setAffectedSoftware(AffectedSoftwareType value) {
        this.affectedSoftware = value;
    }

    public ReferencesType getReferences() {
        return this.references;
    }

    public void setReferences(ReferencesType value) {
        this.references = value;
    }

    public Boolean isIsKnown() {
        return this.isKnown;
    }

    public void setIsKnown(Boolean value) {
        this.isKnown = value;
    }

    public Boolean isIsPubliclyAcknowledged() {
        return this.isPubliclyAcknowledged;
    }

    public void setIsPubliclyAcknowledged(Boolean value) {
        this.isPubliclyAcknowledged = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<StructuredTextType> rhsShortDescriptions;
        List<StructuredTextType> rhsDescriptions;
        if (!(object instanceof VulnerabilityType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VulnerabilityType that = (VulnerabilityType)object;
        String lhsTitle = this.getTitle();
        String rhsTitle = that.getTitle();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"title", (Object)lhsTitle), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"title", (Object)rhsTitle), (Object)lhsTitle, (Object)rhsTitle)) {
            return false;
        }
        List<StructuredTextType> lhsDescriptions = this.descriptions != null && !this.descriptions.isEmpty() ? this.getDescriptions() : null;
        List<StructuredTextType> list = rhsDescriptions = that.descriptions != null && !that.descriptions.isEmpty() ? that.getDescriptions() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"descriptions", lhsDescriptions), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"descriptions", rhsDescriptions), lhsDescriptions, rhsDescriptions)) {
            return false;
        }
        List<StructuredTextType> lhsShortDescriptions = this.shortDescriptions != null && !this.shortDescriptions.isEmpty() ? this.getShortDescriptions() : null;
        List<StructuredTextType> list2 = rhsShortDescriptions = that.shortDescriptions != null && !that.shortDescriptions.isEmpty() ? that.getShortDescriptions() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"shortDescriptions", lhsShortDescriptions), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"shortDescriptions", rhsShortDescriptions), lhsShortDescriptions, rhsShortDescriptions)) {
            return false;
        }
        String lhsCVEID = this.getCVEID();
        String rhsCVEID = that.getCVEID();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"cveid", (Object)lhsCVEID), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"cveid", (Object)rhsCVEID), (Object)lhsCVEID, (Object)rhsCVEID)) {
            return false;
        }
        BigInteger lhsOSVDBID = this.getOSVDBID();
        BigInteger rhsOSVDBID = that.getOSVDBID();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"osvdbid", (Object)lhsOSVDBID), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"osvdbid", (Object)rhsOSVDBID), (Object)lhsOSVDBID, (Object)rhsOSVDBID)) {
            return false;
        }
        String lhsSource = this.getSource();
        String rhsSource = that.getSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"source", (Object)lhsSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"source", (Object)rhsSource), (Object)lhsSource, (Object)rhsSource)) {
            return false;
        }
        CVSSVectorType lhsCVSSScore = this.getCVSSScore();
        CVSSVectorType rhsCVSSScore = that.getCVSSScore();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"cvssScore", (Object)lhsCVSSScore), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"cvssScore", (Object)rhsCVSSScore), (Object)lhsCVSSScore, (Object)rhsCVSSScore)) {
            return false;
        }
        DateTimeWithPrecisionType lhsDiscoveredDateTime = this.getDiscoveredDateTime();
        DateTimeWithPrecisionType rhsDiscoveredDateTime = that.getDiscoveredDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"discoveredDateTime", (Object)lhsDiscoveredDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"discoveredDateTime", (Object)rhsDiscoveredDateTime), (Object)lhsDiscoveredDateTime, (Object)rhsDiscoveredDateTime)) {
            return false;
        }
        DateTimeWithPrecisionType lhsPublishedDateTime = this.getPublishedDateTime();
        DateTimeWithPrecisionType rhsPublishedDateTime = that.getPublishedDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"publishedDateTime", (Object)lhsPublishedDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"publishedDateTime", (Object)rhsPublishedDateTime), (Object)lhsPublishedDateTime, (Object)rhsPublishedDateTime)) {
            return false;
        }
        AffectedSoftwareType lhsAffectedSoftware = this.getAffectedSoftware();
        AffectedSoftwareType rhsAffectedSoftware = that.getAffectedSoftware();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"affectedSoftware", (Object)lhsAffectedSoftware), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"affectedSoftware", (Object)rhsAffectedSoftware), (Object)lhsAffectedSoftware, (Object)rhsAffectedSoftware)) {
            return false;
        }
        ReferencesType lhsReferences = this.getReferences();
        ReferencesType rhsReferences = that.getReferences();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"references", (Object)lhsReferences), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"references", (Object)rhsReferences), (Object)lhsReferences, (Object)rhsReferences)) {
            return false;
        }
        Boolean lhsIsKnown = this.isIsKnown();
        Boolean rhsIsKnown = that.isIsKnown();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"isKnown", (Object)lhsIsKnown), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"isKnown", (Object)rhsIsKnown), (Object)lhsIsKnown, (Object)rhsIsKnown)) {
            return false;
        }
        Boolean lhsIsPubliclyAcknowledged = this.isIsPubliclyAcknowledged();
        Boolean rhsIsPubliclyAcknowledged = that.isIsPubliclyAcknowledged();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"isPubliclyAcknowledged", (Object)lhsIsPubliclyAcknowledged), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"isPubliclyAcknowledged", (Object)rhsIsPubliclyAcknowledged), (Object)lhsIsPubliclyAcknowledged, (Object)rhsIsPubliclyAcknowledged);
    }

    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        String theTitle = this.getTitle();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"title", (Object)theTitle), currentHashCode, (Object)theTitle);
        List<StructuredTextType> theDescriptions = this.descriptions != null && !this.descriptions.isEmpty() ? this.getDescriptions() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"descriptions", theDescriptions), currentHashCode, theDescriptions);
        List<StructuredTextType> theShortDescriptions = this.shortDescriptions != null && !this.shortDescriptions.isEmpty() ? this.getShortDescriptions() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"shortDescriptions", theShortDescriptions), currentHashCode, theShortDescriptions);
        String theCVEID = this.getCVEID();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"cveid", (Object)theCVEID), currentHashCode, (Object)theCVEID);
        BigInteger theOSVDBID = this.getOSVDBID();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"osvdbid", (Object)theOSVDBID), currentHashCode, (Object)theOSVDBID);
        String theSource = this.getSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"source", (Object)theSource), currentHashCode, (Object)theSource);
        CVSSVectorType theCVSSScore = this.getCVSSScore();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"cvssScore", (Object)theCVSSScore), currentHashCode, (Object)theCVSSScore);
        DateTimeWithPrecisionType theDiscoveredDateTime = this.getDiscoveredDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"discoveredDateTime", (Object)theDiscoveredDateTime), currentHashCode, (Object)theDiscoveredDateTime);
        DateTimeWithPrecisionType thePublishedDateTime = this.getPublishedDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"publishedDateTime", (Object)thePublishedDateTime), currentHashCode, (Object)thePublishedDateTime);
        AffectedSoftwareType theAffectedSoftware = this.getAffectedSoftware();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"affectedSoftware", (Object)theAffectedSoftware), currentHashCode, (Object)theAffectedSoftware);
        ReferencesType theReferences = this.getReferences();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"references", (Object)theReferences), currentHashCode, (Object)theReferences);
        Boolean theIsKnown = this.isIsKnown();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"isKnown", (Object)theIsKnown), currentHashCode, (Object)theIsKnown);
        Boolean theIsPubliclyAcknowledged = this.isIsPubliclyAcknowledged();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"isPubliclyAcknowledged", (Object)theIsPubliclyAcknowledged), currentHashCode, (Object)theIsPubliclyAcknowledged);
        return currentHashCode;
    }

    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public VulnerabilityType withTitle(String value) {
        this.setTitle(value);
        return this;
    }

    public VulnerabilityType withDescriptions(StructuredTextType ... values) {
        if (values != null) {
            for (StructuredTextType value : values) {
                this.getDescriptions().add(value);
            }
        }
        return this;
    }

    public VulnerabilityType withDescriptions(Collection<StructuredTextType> values) {
        if (values != null) {
            this.getDescriptions().addAll(values);
        }
        return this;
    }

    public VulnerabilityType withShortDescriptions(StructuredTextType ... values) {
        if (values != null) {
            for (StructuredTextType value : values) {
                this.getShortDescriptions().add(value);
            }
        }
        return this;
    }

    public VulnerabilityType withShortDescriptions(Collection<StructuredTextType> values) {
        if (values != null) {
            this.getShortDescriptions().addAll(values);
        }
        return this;
    }

    public VulnerabilityType withCVEID(String value) {
        this.setCVEID(value);
        return this;
    }

    public VulnerabilityType withOSVDBID(BigInteger value) {
        this.setOSVDBID(value);
        return this;
    }

    public VulnerabilityType withSource(String value) {
        this.setSource(value);
        return this;
    }

    public VulnerabilityType withCVSSScore(CVSSVectorType value) {
        this.setCVSSScore(value);
        return this;
    }

    public VulnerabilityType withDiscoveredDateTime(DateTimeWithPrecisionType value) {
        this.setDiscoveredDateTime(value);
        return this;
    }

    public VulnerabilityType withPublishedDateTime(DateTimeWithPrecisionType value) {
        this.setPublishedDateTime(value);
        return this;
    }

    public VulnerabilityType withAffectedSoftware(AffectedSoftwareType value) {
        this.setAffectedSoftware(value);
        return this;
    }

    public VulnerabilityType withReferences(ReferencesType value) {
        this.setReferences(value);
        return this;
    }

    public VulnerabilityType withIsKnown(Boolean value) {
        this.setIsKnown(value);
        return this;
    }

    public VulnerabilityType withIsPubliclyAcknowledged(Boolean value) {
        this.setIsPubliclyAcknowledged(value);
        return this;
    }

    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        String theTitle = this.getTitle();
        strategy.appendField(locator, (Object)this, "title", buffer, (Object)theTitle);
        List<StructuredTextType> theDescriptions = this.descriptions != null && !this.descriptions.isEmpty() ? this.getDescriptions() : null;
        strategy.appendField(locator, (Object)this, "descriptions", buffer, theDescriptions);
        List<StructuredTextType> theShortDescriptions = this.shortDescriptions != null && !this.shortDescriptions.isEmpty() ? this.getShortDescriptions() : null;
        strategy.appendField(locator, (Object)this, "shortDescriptions", buffer, theShortDescriptions);
        String theCVEID = this.getCVEID();
        strategy.appendField(locator, (Object)this, "cveid", buffer, (Object)theCVEID);
        BigInteger theOSVDBID = this.getOSVDBID();
        strategy.appendField(locator, (Object)this, "osvdbid", buffer, (Object)theOSVDBID);
        String theSource = this.getSource();
        strategy.appendField(locator, (Object)this, "source", buffer, (Object)theSource);
        CVSSVectorType theCVSSScore = this.getCVSSScore();
        strategy.appendField(locator, (Object)this, "cvssScore", buffer, (Object)theCVSSScore);
        DateTimeWithPrecisionType theDiscoveredDateTime = this.getDiscoveredDateTime();
        strategy.appendField(locator, (Object)this, "discoveredDateTime", buffer, (Object)theDiscoveredDateTime);
        DateTimeWithPrecisionType thePublishedDateTime = this.getPublishedDateTime();
        strategy.appendField(locator, (Object)this, "publishedDateTime", buffer, (Object)thePublishedDateTime);
        AffectedSoftwareType theAffectedSoftware = this.getAffectedSoftware();
        strategy.appendField(locator, (Object)this, "affectedSoftware", buffer, (Object)theAffectedSoftware);
        ReferencesType theReferences = this.getReferences();
        strategy.appendField(locator, (Object)this, "references", buffer, (Object)theReferences);
        Boolean theIsKnown = this.isIsKnown();
        strategy.appendField(locator, (Object)this, "isKnown", buffer, (Object)theIsKnown);
        Boolean theIsPubliclyAcknowledged = this.isIsPubliclyAcknowledged();
        strategy.appendField(locator, (Object)this, "isPubliclyAcknowledged", buffer, (Object)theIsPubliclyAcknowledged);
        return buffer;
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, VulnerabilityType.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static VulnerabilityType fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)VulnerabilityType.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (VulnerabilityType)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

