/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.exploittarget_1;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.data_marking.marking_1.MarkingType;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.mitre.stix.common_1.ExploitTargetBaseType;
import org.mitre.stix.common_1.InformationSourceType;
import org.mitre.stix.common_1.RelatedPackageRefsType;
import org.mitre.stix.common_1.StructuredTextType;
import org.mitre.stix.exploittarget_1.ConfigurationType;
import org.mitre.stix.exploittarget_1.PotentialCOAsType;
import org.mitre.stix.exploittarget_1.RelatedExploitTargetsType;
import org.mitre.stix.exploittarget_1.VulnerabilityType;
import org.mitre.stix.exploittarget_1.WeaknessType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ExploitTargetType", propOrder={"title", "descriptions", "shortDescriptions", "vulnerabilities", "weaknesses", "configurations", "potentialCOAs", "informationSource", "handling", "relatedExploitTargets", "relatedPackages"})
@XmlRootElement(name="Exploit_Target")
public class ExploitTarget
extends ExploitTargetBaseType
implements Equals,
HashCode,
ToString {
    @XmlElement(name="Title")
    protected String title;
    @XmlElement(name="Description")
    protected List<StructuredTextType> descriptions;
    @XmlElement(name="Short_Description")
    protected List<StructuredTextType> shortDescriptions;
    @XmlElement(name="Vulnerability")
    protected List<VulnerabilityType> vulnerabilities;
    @XmlElement(name="Weakness")
    protected List<WeaknessType> weaknesses;
    @XmlElement(name="Configuration")
    protected List<ConfigurationType> configurations;
    @XmlElement(name="Potential_COAs")
    protected PotentialCOAsType potentialCOAs;
    @XmlElement(name="Information_Source")
    protected InformationSourceType informationSource;
    @XmlElement(name="Handling")
    protected MarkingType handling;
    @XmlElement(name="Related_Exploit_Targets")
    protected RelatedExploitTargetsType relatedExploitTargets;
    @XmlElement(name="Related_Packages")
    protected RelatedPackageRefsType relatedPackages;
    @XmlAttribute(name="version")
    protected String version;

    public ExploitTarget() {
    }

    public ExploitTarget(QName id, QName idref, XMLGregorianCalendar timestamp, String title, List<StructuredTextType> descriptions, List<StructuredTextType> shortDescriptions, List<VulnerabilityType> vulnerabilities, List<WeaknessType> weaknesses, List<ConfigurationType> configurations, PotentialCOAsType potentialCOAs, InformationSourceType informationSource, MarkingType handling, RelatedExploitTargetsType relatedExploitTargets, RelatedPackageRefsType relatedPackages, String version) {
        super(id, idref, timestamp);
        this.title = title;
        this.descriptions = descriptions;
        this.shortDescriptions = shortDescriptions;
        this.vulnerabilities = vulnerabilities;
        this.weaknesses = weaknesses;
        this.configurations = configurations;
        this.potentialCOAs = potentialCOAs;
        this.informationSource = informationSource;
        this.handling = handling;
        this.relatedExploitTargets = relatedExploitTargets;
        this.relatedPackages = relatedPackages;
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public List<StructuredTextType> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<StructuredTextType>();
        }
        return this.descriptions;
    }

    public List<StructuredTextType> getShortDescriptions() {
        if (this.shortDescriptions == null) {
            this.shortDescriptions = new ArrayList<StructuredTextType>();
        }
        return this.shortDescriptions;
    }

    public List<VulnerabilityType> getVulnerabilities() {
        if (this.vulnerabilities == null) {
            this.vulnerabilities = new ArrayList<VulnerabilityType>();
        }
        return this.vulnerabilities;
    }

    public List<WeaknessType> getWeaknesses() {
        if (this.weaknesses == null) {
            this.weaknesses = new ArrayList<WeaknessType>();
        }
        return this.weaknesses;
    }

    public List<ConfigurationType> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new ArrayList<ConfigurationType>();
        }
        return this.configurations;
    }

    public PotentialCOAsType getPotentialCOAs() {
        return this.potentialCOAs;
    }

    public void setPotentialCOAs(PotentialCOAsType value) {
        this.potentialCOAs = value;
    }

    public InformationSourceType getInformationSource() {
        return this.informationSource;
    }

    public void setInformationSource(InformationSourceType value) {
        this.informationSource = value;
    }

    public MarkingType getHandling() {
        return this.handling;
    }

    public void setHandling(MarkingType value) {
        this.handling = value;
    }

    public RelatedExploitTargetsType getRelatedExploitTargets() {
        return this.relatedExploitTargets;
    }

    public void setRelatedExploitTargets(RelatedExploitTargetsType value) {
        this.relatedExploitTargets = value;
    }

    public RelatedPackageRefsType getRelatedPackages() {
        return this.relatedPackages;
    }

    public void setRelatedPackages(RelatedPackageRefsType value) {
        this.relatedPackages = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ConfigurationType> rhsConfigurations;
        List<WeaknessType> rhsWeaknesses;
        List<VulnerabilityType> rhsVulnerabilities;
        List<StructuredTextType> rhsShortDescriptions;
        List<StructuredTextType> rhsDescriptions;
        if (!(object instanceof ExploitTarget)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ExploitTarget that = (ExploitTarget)object;
        String lhsTitle = this.getTitle();
        String rhsTitle = that.getTitle();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"title", (Object)lhsTitle), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"title", (Object)rhsTitle), (Object)lhsTitle, (Object)rhsTitle)) {
            return false;
        }
        List<StructuredTextType> lhsDescriptions = this.descriptions != null && !this.descriptions.isEmpty() ? this.getDescriptions() : null;
        List<StructuredTextType> list = rhsDescriptions = that.descriptions != null && !that.descriptions.isEmpty() ? that.getDescriptions() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"descriptions", lhsDescriptions), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"descriptions", rhsDescriptions), lhsDescriptions, rhsDescriptions)) {
            return false;
        }
        List<StructuredTextType> lhsShortDescriptions = this.shortDescriptions != null && !this.shortDescriptions.isEmpty() ? this.getShortDescriptions() : null;
        List<StructuredTextType> list2 = rhsShortDescriptions = that.shortDescriptions != null && !that.shortDescriptions.isEmpty() ? that.getShortDescriptions() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"shortDescriptions", lhsShortDescriptions), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"shortDescriptions", rhsShortDescriptions), lhsShortDescriptions, rhsShortDescriptions)) {
            return false;
        }
        List<VulnerabilityType> lhsVulnerabilities = this.vulnerabilities != null && !this.vulnerabilities.isEmpty() ? this.getVulnerabilities() : null;
        List<VulnerabilityType> list3 = rhsVulnerabilities = that.vulnerabilities != null && !that.vulnerabilities.isEmpty() ? that.getVulnerabilities() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"vulnerabilities", lhsVulnerabilities), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"vulnerabilities", rhsVulnerabilities), lhsVulnerabilities, rhsVulnerabilities)) {
            return false;
        }
        List<WeaknessType> lhsWeaknesses = this.weaknesses != null && !this.weaknesses.isEmpty() ? this.getWeaknesses() : null;
        List<WeaknessType> list4 = rhsWeaknesses = that.weaknesses != null && !that.weaknesses.isEmpty() ? that.getWeaknesses() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"weaknesses", lhsWeaknesses), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"weaknesses", rhsWeaknesses), lhsWeaknesses, rhsWeaknesses)) {
            return false;
        }
        List<ConfigurationType> lhsConfigurations = this.configurations != null && !this.configurations.isEmpty() ? this.getConfigurations() : null;
        List<ConfigurationType> list5 = rhsConfigurations = that.configurations != null && !that.configurations.isEmpty() ? that.getConfigurations() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"configurations", lhsConfigurations), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"configurations", rhsConfigurations), lhsConfigurations, rhsConfigurations)) {
            return false;
        }
        PotentialCOAsType lhsPotentialCOAs = this.getPotentialCOAs();
        PotentialCOAsType rhsPotentialCOAs = that.getPotentialCOAs();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"potentialCOAs", (Object)lhsPotentialCOAs), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"potentialCOAs", (Object)rhsPotentialCOAs), (Object)lhsPotentialCOAs, (Object)rhsPotentialCOAs)) {
            return false;
        }
        InformationSourceType lhsInformationSource = this.getInformationSource();
        InformationSourceType rhsInformationSource = that.getInformationSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"informationSource", (Object)lhsInformationSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"informationSource", (Object)rhsInformationSource), (Object)lhsInformationSource, (Object)rhsInformationSource)) {
            return false;
        }
        MarkingType lhsHandling = this.getHandling();
        MarkingType rhsHandling = that.getHandling();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"handling", (Object)lhsHandling), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"handling", (Object)rhsHandling), (Object)lhsHandling, (Object)rhsHandling)) {
            return false;
        }
        RelatedExploitTargetsType lhsRelatedExploitTargets = this.getRelatedExploitTargets();
        RelatedExploitTargetsType rhsRelatedExploitTargets = that.getRelatedExploitTargets();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"relatedExploitTargets", (Object)lhsRelatedExploitTargets), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"relatedExploitTargets", (Object)rhsRelatedExploitTargets), (Object)lhsRelatedExploitTargets, (Object)rhsRelatedExploitTargets)) {
            return false;
        }
        RelatedPackageRefsType lhsRelatedPackages = this.getRelatedPackages();
        RelatedPackageRefsType rhsRelatedPackages = that.getRelatedPackages();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"relatedPackages", (Object)lhsRelatedPackages), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"relatedPackages", (Object)rhsRelatedPackages), (Object)lhsRelatedPackages, (Object)rhsRelatedPackages)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theTitle = this.getTitle();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"title", (Object)theTitle), currentHashCode, (Object)theTitle);
        List<StructuredTextType> theDescriptions = this.descriptions != null && !this.descriptions.isEmpty() ? this.getDescriptions() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"descriptions", theDescriptions), currentHashCode, theDescriptions);
        List<StructuredTextType> theShortDescriptions = this.shortDescriptions != null && !this.shortDescriptions.isEmpty() ? this.getShortDescriptions() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"shortDescriptions", theShortDescriptions), currentHashCode, theShortDescriptions);
        List<VulnerabilityType> theVulnerabilities = this.vulnerabilities != null && !this.vulnerabilities.isEmpty() ? this.getVulnerabilities() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"vulnerabilities", theVulnerabilities), currentHashCode, theVulnerabilities);
        List<WeaknessType> theWeaknesses = this.weaknesses != null && !this.weaknesses.isEmpty() ? this.getWeaknesses() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"weaknesses", theWeaknesses), currentHashCode, theWeaknesses);
        List<ConfigurationType> theConfigurations = this.configurations != null && !this.configurations.isEmpty() ? this.getConfigurations() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"configurations", theConfigurations), currentHashCode, theConfigurations);
        PotentialCOAsType thePotentialCOAs = this.getPotentialCOAs();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"potentialCOAs", (Object)thePotentialCOAs), currentHashCode, (Object)thePotentialCOAs);
        InformationSourceType theInformationSource = this.getInformationSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"informationSource", (Object)theInformationSource), currentHashCode, (Object)theInformationSource);
        MarkingType theHandling = this.getHandling();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"handling", (Object)theHandling), currentHashCode, (Object)theHandling);
        RelatedExploitTargetsType theRelatedExploitTargets = this.getRelatedExploitTargets();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"relatedExploitTargets", (Object)theRelatedExploitTargets), currentHashCode, (Object)theRelatedExploitTargets);
        RelatedPackageRefsType theRelatedPackages = this.getRelatedPackages();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"relatedPackages", (Object)theRelatedPackages), currentHashCode, (Object)theRelatedPackages);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"version", (Object)theVersion), currentHashCode, (Object)theVersion);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public ExploitTarget withTitle(String value) {
        this.setTitle(value);
        return this;
    }

    public ExploitTarget withDescriptions(StructuredTextType ... values) {
        if (values != null) {
            for (StructuredTextType value : values) {
                this.getDescriptions().add(value);
            }
        }
        return this;
    }

    public ExploitTarget withDescriptions(Collection<StructuredTextType> values) {
        if (values != null) {
            this.getDescriptions().addAll(values);
        }
        return this;
    }

    public ExploitTarget withShortDescriptions(StructuredTextType ... values) {
        if (values != null) {
            for (StructuredTextType value : values) {
                this.getShortDescriptions().add(value);
            }
        }
        return this;
    }

    public ExploitTarget withShortDescriptions(Collection<StructuredTextType> values) {
        if (values != null) {
            this.getShortDescriptions().addAll(values);
        }
        return this;
    }

    public ExploitTarget withVulnerabilities(VulnerabilityType ... values) {
        if (values != null) {
            for (VulnerabilityType value : values) {
                this.getVulnerabilities().add(value);
            }
        }
        return this;
    }

    public ExploitTarget withVulnerabilities(Collection<VulnerabilityType> values) {
        if (values != null) {
            this.getVulnerabilities().addAll(values);
        }
        return this;
    }

    public ExploitTarget withWeaknesses(WeaknessType ... values) {
        if (values != null) {
            for (WeaknessType value : values) {
                this.getWeaknesses().add(value);
            }
        }
        return this;
    }

    public ExploitTarget withWeaknesses(Collection<WeaknessType> values) {
        if (values != null) {
            this.getWeaknesses().addAll(values);
        }
        return this;
    }

    public ExploitTarget withConfigurations(ConfigurationType ... values) {
        if (values != null) {
            for (ConfigurationType value : values) {
                this.getConfigurations().add(value);
            }
        }
        return this;
    }

    public ExploitTarget withConfigurations(Collection<ConfigurationType> values) {
        if (values != null) {
            this.getConfigurations().addAll(values);
        }
        return this;
    }

    public ExploitTarget withPotentialCOAs(PotentialCOAsType value) {
        this.setPotentialCOAs(value);
        return this;
    }

    public ExploitTarget withInformationSource(InformationSourceType value) {
        this.setInformationSource(value);
        return this;
    }

    public ExploitTarget withHandling(MarkingType value) {
        this.setHandling(value);
        return this;
    }

    public ExploitTarget withRelatedExploitTargets(RelatedExploitTargetsType value) {
        this.setRelatedExploitTargets(value);
        return this;
    }

    public ExploitTarget withRelatedPackages(RelatedPackageRefsType value) {
        this.setRelatedPackages(value);
        return this;
    }

    public ExploitTarget withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    @Override
    public ExploitTarget withId(QName value) {
        this.setId(value);
        return this;
    }

    @Override
    public ExploitTarget withIdref(QName value) {
        this.setIdref(value);
        return this;
    }

    @Override
    public ExploitTarget withTimestamp(XMLGregorianCalendar value) {
        this.setTimestamp(value);
        return this;
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        String theTitle = this.getTitle();
        strategy.appendField(locator, (Object)this, "title", buffer, (Object)theTitle);
        List<StructuredTextType> theDescriptions = this.descriptions != null && !this.descriptions.isEmpty() ? this.getDescriptions() : null;
        strategy.appendField(locator, (Object)this, "descriptions", buffer, theDescriptions);
        List<StructuredTextType> theShortDescriptions = this.shortDescriptions != null && !this.shortDescriptions.isEmpty() ? this.getShortDescriptions() : null;
        strategy.appendField(locator, (Object)this, "shortDescriptions", buffer, theShortDescriptions);
        List<VulnerabilityType> theVulnerabilities = this.vulnerabilities != null && !this.vulnerabilities.isEmpty() ? this.getVulnerabilities() : null;
        strategy.appendField(locator, (Object)this, "vulnerabilities", buffer, theVulnerabilities);
        List<WeaknessType> theWeaknesses = this.weaknesses != null && !this.weaknesses.isEmpty() ? this.getWeaknesses() : null;
        strategy.appendField(locator, (Object)this, "weaknesses", buffer, theWeaknesses);
        List<ConfigurationType> theConfigurations = this.configurations != null && !this.configurations.isEmpty() ? this.getConfigurations() : null;
        strategy.appendField(locator, (Object)this, "configurations", buffer, theConfigurations);
        PotentialCOAsType thePotentialCOAs = this.getPotentialCOAs();
        strategy.appendField(locator, (Object)this, "potentialCOAs", buffer, (Object)thePotentialCOAs);
        InformationSourceType theInformationSource = this.getInformationSource();
        strategy.appendField(locator, (Object)this, "informationSource", buffer, (Object)theInformationSource);
        MarkingType theHandling = this.getHandling();
        strategy.appendField(locator, (Object)this, "handling", buffer, (Object)theHandling);
        RelatedExploitTargetsType theRelatedExploitTargets = this.getRelatedExploitTargets();
        strategy.appendField(locator, (Object)this, "relatedExploitTargets", buffer, (Object)theRelatedExploitTargets);
        RelatedPackageRefsType theRelatedPackages = this.getRelatedPackages();
        strategy.appendField(locator, (Object)this, "relatedPackages", buffer, (Object)theRelatedPackages);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion);
        return buffer;
    }

    @Override
    public Document toDocument() {
        return this.toDocument(false);
    }

    @Override
    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    @Override
    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, ExploitTarget.class, (Object)this);
    }

    @Override
    public String toXMLString() {
        return this.toXMLString(false);
    }

    @Override
    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static ExploitTarget fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)ExploitTarget.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (ExploitTarget)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

