/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.examples;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mitre.cybox.common_2.ToolInformationType;
import org.mitre.cybox.common_2.ToolsInformationType;
import org.mitre.stix.common_1.InformationSourceType;
import org.mitre.stix.common_1.StructuredTextType;
import org.mitre.stix.stix_1.STIXHeaderType;
import org.mitre.stix.stix_1.STIXPackage;
import org.xml.sax.SAXException;

public class CreationToolMetadata {
    public static void main(String[] args) {
        try {
            XMLGregorianCalendar now = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar(TimeZone.getTimeZone("UTC")));
            STIXHeaderType header = new STIXHeaderType().withDescriptions(new StructuredTextType().withValue("Example")).withInformationSource(new InformationSourceType().withTools(new ToolsInformationType().withTools(new ToolInformationType().withName("org.mitre.stix.examples.CreationToolMetadata").withVendor("The MITRE Corporation"))));
            STIXPackage stixPackage = new STIXPackage().withSTIXHeader(header).withVersion("1.2").withTimestamp(now).withId(new QName("http://example.com/", "package-" + UUID.randomUUID().toString(), "example"));
            System.out.println(stixPackage.toXMLString(true));
            System.out.println(StringUtils.repeat((String)"-", (int)120));
            System.out.println("Validates: " + stixPackage.validate());
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

