/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix.campaign_1;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.mitre.stix.campaign_1.AssociatedCampaignsType;
import org.mitre.stix.campaign_1.AttributionType;
import org.mitre.stix.campaign_1.Campaign;
import org.mitre.stix.campaign_1.NamesType;
import org.mitre.stix.campaign_1.RelatedIncidentsType;
import org.mitre.stix.campaign_1.RelatedIndicatorsType;
import org.mitre.stix.campaign_1.RelatedTTPsType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlRegistry
public class ObjectFactory {
    public Campaign createCampaign() {
        return new Campaign();
    }

    public NamesType createNamesType() {
        return new NamesType();
    }

    public RelatedTTPsType createRelatedTTPsType() {
        return new RelatedTTPsType();
    }

    public RelatedIncidentsType createRelatedIncidentsType() {
        return new RelatedIncidentsType();
    }

    public RelatedIndicatorsType createRelatedIndicatorsType() {
        return new RelatedIndicatorsType();
    }

    public AttributionType createAttributionType() {
        return new AttributionType();
    }

    public AssociatedCampaignsType createAssociatedCampaignsType() {
        return new AssociatedCampaignsType();
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, ObjectFactory.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static ObjectFactory fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (ObjectFactory)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

