/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.mitre.stix.ValidationErrorHandler;
import org.mitre.stix.Version;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class STIXSchema {
    private static final Logger LOGGER = Logger.getLogger(STIXSchema.class.getName());
    private String version = this.getClass().getPackage().getAnnotation(Version.class).schema();
    private static STIXSchema instance;
    private Map<String, String> prefixSchemaBindings;
    private Validator validator;
    private Schema schema;

    public static synchronized STIXSchema getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new STIXSchema();
        return instance;
    }

    private STIXSchema() {
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());
        try {
            Resource[] schemaResources = patternResolver.getResources("classpath:schemas/v" + this.version + "/**/*.xsd");
            this.prefixSchemaBindings = new HashMap<String, String>();
            for (Resource resource : schemaResources) {
                String url = resource.getURL().toString();
                Document schemaDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(resource.getInputStream());
                schemaDocument.getDocumentElement().normalize();
                NamedNodeMap attributes = schemaDocument.getDocumentElement().getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String prefix;
                    Node attribute = attributes.item(i);
                    String targetNamespace = schemaDocument.getDocumentElement().getAttribute("targetNamespace");
                    if (!attribute.getNodeName().startsWith("xmlns:") || !attribute.getNodeValue().equals(targetNamespace) || this.prefixSchemaBindings.containsKey(prefix = attributes.item(i).getNodeName().split(":")[1]) && this.prefixSchemaBindings.get(prefix).split("schemas/v" + this.version + "/")[1].startsWith("external")) continue;
                    LOGGER.fine("     adding: " + prefix + " :: " + url);
                    this.prefixSchemaBindings.put(prefix, url);
                }
            }
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Source[] schemas = new Source[this.prefixSchemaBindings.values().size()];
            int i = 0;
            for (String schemaLocation : this.prefixSchemaBindings.values()) {
                schemas[i++] = new StreamSource(schemaLocation);
            }
            this.schema = factory.newSchema(schemas);
            this.validator = this.schema.newValidator();
            this.validator.setErrorHandler(new ValidationErrorHandler());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setValidationErrorHandler(ErrorHandler customErrorHandler) {
        this.validator.setErrorHandler(customErrorHandler);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean validate(URL url) throws SAXException {
        String xmlText = null;
        try {
            xmlText = IOUtils.toString((InputStream)url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.validate(xmlText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(String xmlText) throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder b = factory.newDocumentBuilder();
            Document document = b.parse(new ByteArrayInputStream(xmlText.getBytes()));
            Element root = document.getDocumentElement();
            root.removeAttribute("xsi:schemaLocation");
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.transform(new DOMSource(root), new StreamResult(buffer));
            xmlText = buffer.toString();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            STIXSchema e = this;
            synchronized (e) {
                this.validator.validate(new StreamSource(new ByteArrayInputStream(xmlText.getBytes(StandardCharsets.UTF_8))));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            if (this.validator.getErrorHandler() != null) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        STIXSchema schema = STIXSchema.getInstance();
        System.out.println(schema.validate(new URL("https://raw.githubusercontent.com/STIXProject/python-stix/v1.2.0.0/examples/sample.xml")));
        System.out.println(schema.getVersion());
    }

    public static String getNamespaceURI(Object obj) {
        Package pkg = obj.getClass().getPackage();
        XmlSchema xmlSchemaAnnotation = pkg.getAnnotation(XmlSchema.class);
        return xmlSchemaAnnotation.namespace();
    }

    public static String getName(Object obj) {
        try {
            return obj.getClass().getAnnotation(XmlRootElement.class).name();
        }
        catch (NullPointerException e) {
            return obj.getClass().getAnnotation(XmlType.class).name();
        }
    }

    public static QName getQualifiedName(Object obj) {
        return new QName(STIXSchema.getNamespaceURI(obj), STIXSchema.getName(obj));
    }
}

