/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.stix;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mitre.stix.STIXSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentUtilities {
    private static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XML_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private static final Logger LOGGER = Logger.getLogger(DocumentUtilities.class.getName());

    public static String toXMLString(JAXBElement<?> jaxbElement) {
        return DocumentUtilities.toXMLString(jaxbElement, true);
    }

    public static Document toDocument(JAXBElement<?> jaxbElement) {
        return DocumentUtilities.toDocument(jaxbElement, false);
    }

    public static Document toDocument(JAXBElement<?> jaxbElement, boolean prettyPrint) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.isIgnoringComments();
            documentBuilderFactory.setCoalescing(true);
            document = documentBuilderFactory.newDocumentBuilder().newDocument();
            JAXBContext jaxbContext = JAXBContext.newInstance((String)jaxbElement.getDeclaredType().getPackage().getName());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)prettyPrint);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            try {
                marshaller.marshal(jaxbElement, (Node)document);
            }
            catch (JAXBException e) {
                QName qualifiedName = new QName(STIXSchema.getNamespaceURI(jaxbElement), jaxbElement.getClass().getSimpleName());
                JAXBElement root = new JAXBElement(qualifiedName, jaxbElement.getClass(), jaxbElement);
                marshaller.marshal((Object)root, (Node)document);
            }
            DocumentUtilities.removeUnusedNamespaces(document);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return document;
    }

    public static String toXMLString(JAXBElement<?> jaxbElement, boolean prettyPrint) {
        Document document = DocumentUtilities.toDocument(jaxbElement);
        return DocumentUtilities.toXMLString(document, prettyPrint);
    }

    public static String toXMLString(Document document) {
        return DocumentUtilities.toXMLString(document, false);
    }

    public static String toXMLString(Document document, boolean prettyPrint) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer serializaer = domImplementationLS.createLSSerializer();
            if (prettyPrint) {
                serializaer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                serializaer.getDomConfig().setParameter("xml-declaration", Boolean.TRUE);
            }
            LSOutput lsOutput = domImplementationLS.createLSOutput();
            lsOutput.setEncoding("UTF-8");
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            lsOutput.setByteStream(byteStream);
            serializaer.write(document, lsOutput);
            return new String(byteStream.toByteArray(), "UTF-8");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static final void traverse(Element element, ElementVisitor visitor) {
        visitor.visit(element);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            DocumentUtilities.traverse((Element)node, visitor);
        }
    }

    public static void removeUnusedNamespaces(Document document) {
        final HashSet namespaces = new HashSet();
        document.normalizeDocument();
        Element element = document.getDocumentElement();
        DocumentUtilities.traverse(element, new ElementVisitor(){

            @Override
            public void visit(Element element) {
                String namespace = element.getNamespaceURI();
                if (namespace == null) {
                    namespace = "";
                }
                namespaces.add(namespace);
                NamedNodeMap attributes = element.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String prefix;
                    String value;
                    Node attribute = attributes.item(i);
                    if (DocumentUtilities.XML_NAMESPACE.equals(attribute.getNamespaceURI())) continue;
                    if (DocumentUtilities.XML_SCHEMA_INSTANCE.equals(attribute.getNamespaceURI())) {
                        if (!"type".equals(attribute.getLocalName())) continue;
                        value = attribute.getNodeValue();
                        prefix = value.contains(":") ? value.substring(0, value.indexOf(":")) : null;
                    } else {
                        value = attribute.getNodeValue();
                        prefix = value.contains(":") ? value.substring(0, value.indexOf(":")) : attribute.getPrefix();
                    }
                    namespace = element.lookupNamespaceURI(prefix);
                    if (namespace == null) continue;
                    namespaces.add(namespace);
                }
            }
        });
        DocumentUtilities.traverse(element, new ElementVisitor(){

            @Override
            public void visit(Element element) {
                HashSet<String> removeLocalNames = new HashSet<String>();
                NamedNodeMap attributes = element.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    if (!DocumentUtilities.XML_NAMESPACE.equals(attribute.getNamespaceURI()) || namespaces.contains(attribute.getNodeValue())) continue;
                    removeLocalNames.add(attribute.getLocalName());
                }
                for (String localName : removeLocalNames) {
                    element.removeAttributeNS(DocumentUtilities.XML_NAMESPACE, localName);
                }
            }
        });
    }

    public static Document toDocument(String xml) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.isIgnoringComments();
            documentBuilderFactory.setCoalescing(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(xml));
            Document document = documentBuilder.parse(inputSource);
            DocumentUtilities.removeUnusedNamespaces(document);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String stripFormattingfromXMLString(String xml) {
        try {
            Document document = DocumentUtilities.toDocument(xml);
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer serializaer = domImplementationLS.createLSSerializer();
            serializaer.getDomConfig().setParameter("format-pretty-print", Boolean.FALSE);
            serializaer.getDomConfig().setParameter("xml-declaration", Boolean.TRUE);
            LSOutput lsOutput = domImplementationLS.createLSOutput();
            lsOutput.setEncoding("UTF-8");
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            lsOutput.setByteStream(byteStream);
            serializaer.write(document, lsOutput);
            return new String(byteStream.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface ElementVisitor {
        public void visit(Element var1);
    }
}

