/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.maec.xmlschema.maec_bundle_4;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.maec.xmlschema.maec_bundle_4.CVEVulnerabilityType;
import org.mitre.maec.xmlschema.maec_bundle_4.PlatformListType;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ExploitType", propOrder={"cve", "cweids", "targetedPlatforms"})
public class ExploitType
implements Equals,
HashCode,
ToString {
    @XmlElement(name="CVE")
    protected CVEVulnerabilityType cve;
    @XmlElement(name="CWE_ID")
    protected List<String> cweids;
    @XmlElement(name="Targeted_Platforms")
    protected PlatformListType targetedPlatforms;
    @XmlAttribute(name="known_vulnerability")
    protected Boolean knownVulnerability;

    public ExploitType() {
    }

    public ExploitType(CVEVulnerabilityType cve, List<String> cweids, PlatformListType targetedPlatforms, Boolean knownVulnerability) {
        this.cve = cve;
        this.cweids = cweids;
        this.targetedPlatforms = targetedPlatforms;
        this.knownVulnerability = knownVulnerability;
    }

    public CVEVulnerabilityType getCVE() {
        return this.cve;
    }

    public void setCVE(CVEVulnerabilityType value) {
        this.cve = value;
    }

    public List<String> getCWEIDS() {
        if (this.cweids == null) {
            this.cweids = new ArrayList<String>();
        }
        return this.cweids;
    }

    public PlatformListType getTargetedPlatforms() {
        return this.targetedPlatforms;
    }

    public void setTargetedPlatforms(PlatformListType value) {
        this.targetedPlatforms = value;
    }

    public Boolean isKnownVulnerability() {
        return this.knownVulnerability;
    }

    public void setKnownVulnerability(Boolean value) {
        this.knownVulnerability = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<String> rhsCWEIDS;
        if (!(object instanceof ExploitType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ExploitType that = (ExploitType)object;
        CVEVulnerabilityType lhsCVE = this.getCVE();
        CVEVulnerabilityType rhsCVE = that.getCVE();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"cve", (Object)lhsCVE), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"cve", (Object)rhsCVE), (Object)lhsCVE, (Object)rhsCVE)) {
            return false;
        }
        List<String> lhsCWEIDS = this.cweids != null && !this.cweids.isEmpty() ? this.getCWEIDS() : null;
        List<String> list = rhsCWEIDS = that.cweids != null && !that.cweids.isEmpty() ? that.getCWEIDS() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"cweids", lhsCWEIDS), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"cweids", rhsCWEIDS), lhsCWEIDS, rhsCWEIDS)) {
            return false;
        }
        PlatformListType lhsTargetedPlatforms = this.getTargetedPlatforms();
        PlatformListType rhsTargetedPlatforms = that.getTargetedPlatforms();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"targetedPlatforms", (Object)lhsTargetedPlatforms), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"targetedPlatforms", (Object)rhsTargetedPlatforms), (Object)lhsTargetedPlatforms, (Object)rhsTargetedPlatforms)) {
            return false;
        }
        Boolean lhsKnownVulnerability = this.isKnownVulnerability();
        Boolean rhsKnownVulnerability = that.isKnownVulnerability();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"knownVulnerability", (Object)lhsKnownVulnerability), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"knownVulnerability", (Object)rhsKnownVulnerability), (Object)lhsKnownVulnerability, (Object)rhsKnownVulnerability);
    }

    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        CVEVulnerabilityType theCVE = this.getCVE();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"cve", (Object)theCVE), currentHashCode, (Object)theCVE);
        List<String> theCWEIDS = this.cweids != null && !this.cweids.isEmpty() ? this.getCWEIDS() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"cweids", theCWEIDS), currentHashCode, theCWEIDS);
        PlatformListType theTargetedPlatforms = this.getTargetedPlatforms();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"targetedPlatforms", (Object)theTargetedPlatforms), currentHashCode, (Object)theTargetedPlatforms);
        Boolean theKnownVulnerability = this.isKnownVulnerability();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"knownVulnerability", (Object)theKnownVulnerability), currentHashCode, (Object)theKnownVulnerability);
        return currentHashCode;
    }

    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public ExploitType withCVE(CVEVulnerabilityType value) {
        this.setCVE(value);
        return this;
    }

    public ExploitType withCWEIDS(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getCWEIDS().add(value);
            }
        }
        return this;
    }

    public ExploitType withCWEIDS(Collection<String> values) {
        if (values != null) {
            this.getCWEIDS().addAll(values);
        }
        return this;
    }

    public ExploitType withTargetedPlatforms(PlatformListType value) {
        this.setTargetedPlatforms(value);
        return this;
    }

    public ExploitType withKnownVulnerability(Boolean value) {
        this.setKnownVulnerability(value);
        return this;
    }

    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        CVEVulnerabilityType theCVE = this.getCVE();
        strategy.appendField(locator, (Object)this, "cve", buffer, (Object)theCVE);
        List<String> theCWEIDS = this.cweids != null && !this.cweids.isEmpty() ? this.getCWEIDS() : null;
        strategy.appendField(locator, (Object)this, "cweids", buffer, theCWEIDS);
        PlatformListType theTargetedPlatforms = this.getTargetedPlatforms();
        strategy.appendField(locator, (Object)this, "targetedPlatforms", buffer, (Object)theTargetedPlatforms);
        Boolean theKnownVulnerability = this.isKnownVulnerability();
        strategy.appendField(locator, (Object)this, "knownVulnerability", buffer, (Object)theKnownVulnerability);
        return buffer;
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, ExploitType.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static ExploitType fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)ExploitType.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (ExploitType)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

