/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.cybox.objects;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.cybox.common_2.CustomPropertiesType;
import org.mitre.cybox.common_2.ObjectPropertiesType;
import org.mitre.cybox.objects.InternetLayerType;
import org.mitre.cybox.objects.LinkLayerType;
import org.mitre.cybox.objects.TransportLayerType;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NetworkPacketObjectType", propOrder={"transportLayer", "internetLayer", "linkLayer"})
@XmlRootElement(name="Network_Packet")
public class NetworkPacket
extends ObjectPropertiesType
implements Equals,
HashCode,
ToString {
    @XmlElement(name="Transport_Layer")
    protected TransportLayerType transportLayer;
    @XmlElement(name="Internet_Layer")
    protected InternetLayerType internetLayer;
    @XmlElement(name="Link_Layer")
    protected LinkLayerType linkLayer;

    public NetworkPacket() {
    }

    public NetworkPacket(CustomPropertiesType customProperties, QName objectReference, TransportLayerType transportLayer, InternetLayerType internetLayer, LinkLayerType linkLayer) {
        super(customProperties, objectReference);
        this.transportLayer = transportLayer;
        this.internetLayer = internetLayer;
        this.linkLayer = linkLayer;
    }

    public TransportLayerType getTransportLayer() {
        return this.transportLayer;
    }

    public void setTransportLayer(TransportLayerType value) {
        this.transportLayer = value;
    }

    public InternetLayerType getInternetLayer() {
        return this.internetLayer;
    }

    public void setInternetLayer(InternetLayerType value) {
        this.internetLayer = value;
    }

    public LinkLayerType getLinkLayer() {
        return this.linkLayer;
    }

    public void setLinkLayer(LinkLayerType value) {
        this.linkLayer = value;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof NetworkPacket)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        NetworkPacket that = (NetworkPacket)object;
        TransportLayerType lhsTransportLayer = this.getTransportLayer();
        TransportLayerType rhsTransportLayer = that.getTransportLayer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"transportLayer", (Object)lhsTransportLayer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"transportLayer", (Object)rhsTransportLayer), (Object)lhsTransportLayer, (Object)rhsTransportLayer)) {
            return false;
        }
        InternetLayerType lhsInternetLayer = this.getInternetLayer();
        InternetLayerType rhsInternetLayer = that.getInternetLayer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"internetLayer", (Object)lhsInternetLayer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"internetLayer", (Object)rhsInternetLayer), (Object)lhsInternetLayer, (Object)rhsInternetLayer)) {
            return false;
        }
        LinkLayerType lhsLinkLayer = this.getLinkLayer();
        LinkLayerType rhsLinkLayer = that.getLinkLayer();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"linkLayer", (Object)lhsLinkLayer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"linkLayer", (Object)rhsLinkLayer), (Object)lhsLinkLayer, (Object)rhsLinkLayer);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        TransportLayerType theTransportLayer = this.getTransportLayer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"transportLayer", (Object)theTransportLayer), currentHashCode, (Object)theTransportLayer);
        InternetLayerType theInternetLayer = this.getInternetLayer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"internetLayer", (Object)theInternetLayer), currentHashCode, (Object)theInternetLayer);
        LinkLayerType theLinkLayer = this.getLinkLayer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"linkLayer", (Object)theLinkLayer), currentHashCode, (Object)theLinkLayer);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public NetworkPacket withTransportLayer(TransportLayerType value) {
        this.setTransportLayer(value);
        return this;
    }

    public NetworkPacket withInternetLayer(InternetLayerType value) {
        this.setInternetLayer(value);
        return this;
    }

    public NetworkPacket withLinkLayer(LinkLayerType value) {
        this.setLinkLayer(value);
        return this;
    }

    @Override
    public NetworkPacket withCustomProperties(CustomPropertiesType value) {
        this.setCustomProperties(value);
        return this;
    }

    @Override
    public NetworkPacket withObjectReference(QName value) {
        this.setObjectReference(value);
        return this;
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        TransportLayerType theTransportLayer = this.getTransportLayer();
        strategy.appendField(locator, (Object)this, "transportLayer", buffer, (Object)theTransportLayer);
        InternetLayerType theInternetLayer = this.getInternetLayer();
        strategy.appendField(locator, (Object)this, "internetLayer", buffer, (Object)theInternetLayer);
        LinkLayerType theLinkLayer = this.getLinkLayer();
        strategy.appendField(locator, (Object)this, "linkLayer", buffer, (Object)theLinkLayer);
        return buffer;
    }

    @Override
    public Document toDocument() {
        return this.toDocument(false);
    }

    @Override
    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    @Override
    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, NetworkPacket.class, (Object)this);
    }

    @Override
    public String toXMLString() {
        return this.toXMLString(false);
    }

    @Override
    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static NetworkPacket fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)NetworkPacket.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (NetworkPacket)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

