/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.cybox.objects;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.cybox.objects.IANAAssignedIPNumbersType;
import org.mitre.cybox.objects.NetworkFlowLabelType;
import org.mitre.cybox.objects.SocketAddress;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NetworkLayerInfoType", namespace="http://cybox.mitre.org/objects#NetworkFlowObject-2", propOrder={"srcSocketAddress", "destSocketAddress", "ipProtocol"})
@XmlSeeAlso(value={NetworkFlowLabelType.class})
public class NetworkLayerInfoType
implements Equals,
HashCode,
ToString {
    @XmlElement(name="Src_Socket_Address")
    protected SocketAddress srcSocketAddress;
    @XmlElement(name="Dest_Socket_Address")
    protected SocketAddress destSocketAddress;
    @XmlElement(name="IP_Protocol")
    protected IANAAssignedIPNumbersType ipProtocol;

    public NetworkLayerInfoType() {
    }

    public NetworkLayerInfoType(SocketAddress srcSocketAddress, SocketAddress destSocketAddress, IANAAssignedIPNumbersType ipProtocol) {
        this.srcSocketAddress = srcSocketAddress;
        this.destSocketAddress = destSocketAddress;
        this.ipProtocol = ipProtocol;
    }

    public SocketAddress getSrcSocketAddress() {
        return this.srcSocketAddress;
    }

    public void setSrcSocketAddress(SocketAddress value) {
        this.srcSocketAddress = value;
    }

    public SocketAddress getDestSocketAddress() {
        return this.destSocketAddress;
    }

    public void setDestSocketAddress(SocketAddress value) {
        this.destSocketAddress = value;
    }

    public IANAAssignedIPNumbersType getIPProtocol() {
        return this.ipProtocol;
    }

    public void setIPProtocol(IANAAssignedIPNumbersType value) {
        this.ipProtocol = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof NetworkLayerInfoType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        NetworkLayerInfoType that = (NetworkLayerInfoType)object;
        SocketAddress lhsSrcSocketAddress = this.getSrcSocketAddress();
        SocketAddress rhsSrcSocketAddress = that.getSrcSocketAddress();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"srcSocketAddress", (Object)lhsSrcSocketAddress), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"srcSocketAddress", (Object)rhsSrcSocketAddress), (Object)lhsSrcSocketAddress, (Object)rhsSrcSocketAddress)) {
            return false;
        }
        SocketAddress lhsDestSocketAddress = this.getDestSocketAddress();
        SocketAddress rhsDestSocketAddress = that.getDestSocketAddress();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"destSocketAddress", (Object)lhsDestSocketAddress), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"destSocketAddress", (Object)rhsDestSocketAddress), (Object)lhsDestSocketAddress, (Object)rhsDestSocketAddress)) {
            return false;
        }
        IANAAssignedIPNumbersType lhsIPProtocol = this.getIPProtocol();
        IANAAssignedIPNumbersType rhsIPProtocol = that.getIPProtocol();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"ipProtocol", (Object)lhsIPProtocol), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"ipProtocol", (Object)rhsIPProtocol), (Object)lhsIPProtocol, (Object)rhsIPProtocol);
    }

    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        SocketAddress theSrcSocketAddress = this.getSrcSocketAddress();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"srcSocketAddress", (Object)theSrcSocketAddress), currentHashCode, (Object)theSrcSocketAddress);
        SocketAddress theDestSocketAddress = this.getDestSocketAddress();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"destSocketAddress", (Object)theDestSocketAddress), currentHashCode, (Object)theDestSocketAddress);
        IANAAssignedIPNumbersType theIPProtocol = this.getIPProtocol();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"ipProtocol", (Object)theIPProtocol), currentHashCode, (Object)theIPProtocol);
        return currentHashCode;
    }

    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public NetworkLayerInfoType withSrcSocketAddress(SocketAddress value) {
        this.setSrcSocketAddress(value);
        return this;
    }

    public NetworkLayerInfoType withDestSocketAddress(SocketAddress value) {
        this.setDestSocketAddress(value);
        return this;
    }

    public NetworkLayerInfoType withIPProtocol(IANAAssignedIPNumbersType value) {
        this.setIPProtocol(value);
        return this;
    }

    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        SocketAddress theSrcSocketAddress = this.getSrcSocketAddress();
        strategy.appendField(locator, (Object)this, "srcSocketAddress", buffer, (Object)theSrcSocketAddress);
        SocketAddress theDestSocketAddress = this.getDestSocketAddress();
        strategy.appendField(locator, (Object)this, "destSocketAddress", buffer, (Object)theDestSocketAddress);
        IANAAssignedIPNumbersType theIPProtocol = this.getIPProtocol();
        strategy.appendField(locator, (Object)this, "ipProtocol", buffer, (Object)theIPProtocol);
        return buffer;
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, NetworkLayerInfoType.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static NetworkLayerInfoType fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)NetworkLayerInfoType.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (NetworkLayerInfoType)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

