/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.cybox.objects;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.cybox.common_2.HexBinaryObjectPropertyType;
import org.mitre.cybox.objects.IPv6ExtHeaderType;
import org.mitre.cybox.objects.IPv6HeaderType;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="IPv6PacketType", propOrder={"iPv6Header", "extHeaders", "data"})
public class IPv6PacketType
implements Equals,
HashCode,
ToString {
    @XmlElement(name="IPv6_Header")
    protected IPv6HeaderType iPv6Header;
    @XmlElement(name="Ext_Headers")
    protected List<IPv6ExtHeaderType> extHeaders;
    @XmlElement(name="Data")
    protected HexBinaryObjectPropertyType data;

    public IPv6PacketType() {
    }

    public IPv6PacketType(IPv6HeaderType iPv6Header, List<IPv6ExtHeaderType> extHeaders, HexBinaryObjectPropertyType data) {
        this.iPv6Header = iPv6Header;
        this.extHeaders = extHeaders;
        this.data = data;
    }

    public IPv6HeaderType getIPv6Header() {
        return this.iPv6Header;
    }

    public void setIPv6Header(IPv6HeaderType value) {
        this.iPv6Header = value;
    }

    public List<IPv6ExtHeaderType> getExtHeaders() {
        if (this.extHeaders == null) {
            this.extHeaders = new ArrayList<IPv6ExtHeaderType>();
        }
        return this.extHeaders;
    }

    public HexBinaryObjectPropertyType getData() {
        return this.data;
    }

    public void setData(HexBinaryObjectPropertyType value) {
        this.data = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<IPv6ExtHeaderType> rhsExtHeaders;
        if (!(object instanceof IPv6PacketType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        IPv6PacketType that = (IPv6PacketType)object;
        IPv6HeaderType lhsIPv6Header = this.getIPv6Header();
        IPv6HeaderType rhsIPv6Header = that.getIPv6Header();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"iPv6Header", (Object)lhsIPv6Header), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"iPv6Header", (Object)rhsIPv6Header), (Object)lhsIPv6Header, (Object)rhsIPv6Header)) {
            return false;
        }
        List<IPv6ExtHeaderType> lhsExtHeaders = this.extHeaders != null && !this.extHeaders.isEmpty() ? this.getExtHeaders() : null;
        List<IPv6ExtHeaderType> list = rhsExtHeaders = that.extHeaders != null && !that.extHeaders.isEmpty() ? that.getExtHeaders() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"extHeaders", lhsExtHeaders), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"extHeaders", rhsExtHeaders), lhsExtHeaders, rhsExtHeaders)) {
            return false;
        }
        HexBinaryObjectPropertyType lhsData = this.getData();
        HexBinaryObjectPropertyType rhsData = that.getData();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"data", (Object)lhsData), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"data", (Object)rhsData), (Object)lhsData, (Object)rhsData);
    }

    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        IPv6HeaderType theIPv6Header = this.getIPv6Header();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"iPv6Header", (Object)theIPv6Header), currentHashCode, (Object)theIPv6Header);
        List<IPv6ExtHeaderType> theExtHeaders = this.extHeaders != null && !this.extHeaders.isEmpty() ? this.getExtHeaders() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"extHeaders", theExtHeaders), currentHashCode, theExtHeaders);
        HexBinaryObjectPropertyType theData = this.getData();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"data", (Object)theData), currentHashCode, (Object)theData);
        return currentHashCode;
    }

    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public IPv6PacketType withIPv6Header(IPv6HeaderType value) {
        this.setIPv6Header(value);
        return this;
    }

    public IPv6PacketType withExtHeaders(IPv6ExtHeaderType ... values) {
        if (values != null) {
            for (IPv6ExtHeaderType value : values) {
                this.getExtHeaders().add(value);
            }
        }
        return this;
    }

    public IPv6PacketType withExtHeaders(Collection<IPv6ExtHeaderType> values) {
        if (values != null) {
            this.getExtHeaders().addAll(values);
        }
        return this;
    }

    public IPv6PacketType withData(HexBinaryObjectPropertyType value) {
        this.setData(value);
        return this;
    }

    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        IPv6HeaderType theIPv6Header = this.getIPv6Header();
        strategy.appendField(locator, (Object)this, "iPv6Header", buffer, (Object)theIPv6Header);
        List<IPv6ExtHeaderType> theExtHeaders = this.extHeaders != null && !this.extHeaders.isEmpty() ? this.getExtHeaders() : null;
        strategy.appendField(locator, (Object)this, "extHeaders", buffer, theExtHeaders);
        HexBinaryObjectPropertyType theData = this.getData();
        strategy.appendField(locator, (Object)this, "data", buffer, (Object)theData);
        return buffer;
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, IPv6PacketType.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static IPv6PacketType fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)IPv6PacketType.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (IPv6PacketType)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

