/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.cybox.objects;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EncodingType", namespace="http://cybox.mitre.org/objects#ArtifactObject-2")
public class EncodingType
implements Equals,
HashCode,
ToString {
    @XmlAttribute(name="algorithm")
    protected String algorithm;
    @XmlAttribute(name="character_set")
    protected String characterSet;
    @XmlAttribute(name="custom_character_set_ref")
    @XmlSchemaType(name="anyURI")
    protected String customCharacterSetRef;

    public EncodingType() {
    }

    public EncodingType(String algorithm, String characterSet, String customCharacterSetRef) {
        this.algorithm = algorithm;
        this.characterSet = characterSet;
        this.customCharacterSetRef = customCharacterSetRef;
    }

    public String getAlgorithm() {
        if (this.algorithm == null) {
            return "Base64";
        }
        return this.algorithm;
    }

    public void setAlgorithm(String value) {
        this.algorithm = value;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String value) {
        this.characterSet = value;
    }

    public String getCustomCharacterSetRef() {
        return this.customCharacterSetRef;
    }

    public void setCustomCharacterSetRef(String value) {
        this.customCharacterSetRef = value;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof EncodingType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        EncodingType that = (EncodingType)object;
        String lhsAlgorithm = this.getAlgorithm();
        String rhsAlgorithm = that.getAlgorithm();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"algorithm", (Object)lhsAlgorithm), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"algorithm", (Object)rhsAlgorithm), (Object)lhsAlgorithm, (Object)rhsAlgorithm)) {
            return false;
        }
        String lhsCharacterSet = this.getCharacterSet();
        String rhsCharacterSet = that.getCharacterSet();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"characterSet", (Object)lhsCharacterSet), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"characterSet", (Object)rhsCharacterSet), (Object)lhsCharacterSet, (Object)rhsCharacterSet)) {
            return false;
        }
        String lhsCustomCharacterSetRef = this.getCustomCharacterSetRef();
        String rhsCustomCharacterSetRef = that.getCustomCharacterSetRef();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"customCharacterSetRef", (Object)lhsCustomCharacterSetRef), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"customCharacterSetRef", (Object)rhsCustomCharacterSetRef), (Object)lhsCustomCharacterSetRef, (Object)rhsCustomCharacterSetRef);
    }

    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        String theAlgorithm = this.getAlgorithm();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"algorithm", (Object)theAlgorithm), currentHashCode, (Object)theAlgorithm);
        String theCharacterSet = this.getCharacterSet();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"characterSet", (Object)theCharacterSet), currentHashCode, (Object)theCharacterSet);
        String theCustomCharacterSetRef = this.getCustomCharacterSetRef();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"customCharacterSetRef", (Object)theCustomCharacterSetRef), currentHashCode, (Object)theCustomCharacterSetRef);
        return currentHashCode;
    }

    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public EncodingType withAlgorithm(String value) {
        this.setAlgorithm(value);
        return this;
    }

    public EncodingType withCharacterSet(String value) {
        this.setCharacterSet(value);
        return this;
    }

    public EncodingType withCustomCharacterSetRef(String value) {
        this.setCustomCharacterSetRef(value);
        return this;
    }

    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        String theAlgorithm = this.getAlgorithm();
        strategy.appendField(locator, (Object)this, "algorithm", buffer, (Object)theAlgorithm);
        String theCharacterSet = this.getCharacterSet();
        strategy.appendField(locator, (Object)this, "characterSet", buffer, (Object)theCharacterSet);
        String theCustomCharacterSetRef = this.getCustomCharacterSetRef();
        strategy.appendField(locator, (Object)this, "customCharacterSetRef", buffer, (Object)theCustomCharacterSetRef);
        return buffer;
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, EncodingType.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static EncodingType fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)EncodingType.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (EncodingType)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

