/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.cpe.language._2;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.mitre.cpe.language._2.FactRef;
import org.mitre.cpe.language._2.LogicalTest;
import org.mitre.cpe.language._2.Platform;
import org.mitre.cpe.language._2.PlatformBaseType;
import org.mitre.cpe.language._2.PlatformSpecification;
import org.mitre.cpe.language._2.TextType;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlRegistry
public class ObjectFactory {
    private static final QName _PlatformConfiguration_QNAME = new QName("http://cpe.mitre.org/language/2.0", "platform-configuration");

    public LogicalTest createLogicalTest() {
        return new LogicalTest();
    }

    public FactRef createFactRef() {
        return new FactRef();
    }

    public PlatformBaseType createPlatformBaseType() {
        return new PlatformBaseType();
    }

    public PlatformSpecification createPlatformSpecification() {
        return new PlatformSpecification();
    }

    public Platform createPlatform() {
        return new Platform();
    }

    public TextType createTextType() {
        return new TextType();
    }

    @XmlElementDecl(namespace="http://cpe.mitre.org/language/2.0", name="platform-configuration")
    public JAXBElement<PlatformBaseType> createPlatformConfiguration(PlatformBaseType value) {
        return new JAXBElement(_PlatformConfiguration_QNAME, PlatformBaseType.class, null, (Object)value);
    }

    public Document toDocument() {
        return this.toDocument(false);
    }

    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, ObjectFactory.class, (Object)this);
    }

    public String toXMLString() {
        return this.toXMLString(false);
    }

    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static ObjectFactory fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (ObjectFactory)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

