/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.scap.schema.scap_core._1;

import gov.nist.scap.schema.scap_core._1.AssessmentCheck;
import gov.nist.scap.schema.scap_core._1.AssessmentMethodType;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.mitre.stix.DocumentUtilities;
import org.mitre.stix.STIXSchema;
import org.mitre.stix.ValidationEventHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="identifyableAssessmentMethodType")
@XmlRootElement(name="assessment-method")
public class AssessmentMethod
extends AssessmentMethodType
implements Equals,
HashCode,
ToString {
    @XmlAttribute(name="id")
    @XmlSchemaType(name="positiveInteger")
    protected BigInteger id;

    public AssessmentMethod() {
    }

    public AssessmentMethod(AssessmentCheck assessmentCheck, List<String> assessmentEngines, BigInteger id) {
        super(assessmentCheck, assessmentEngines);
        this.id = id;
    }

    public BigInteger getId() {
        return this.id;
    }

    public void setId(BigInteger value) {
        this.id = value;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof AssessmentMethod)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        AssessmentMethod that = (AssessmentMethod)object;
        BigInteger lhsId = this.getId();
        BigInteger rhsId = that.getId();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"id", (Object)lhsId), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"id", (Object)rhsId), (Object)lhsId, (Object)rhsId);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        BigInteger theId = this.getId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"id", (Object)theId), currentHashCode, (Object)theId);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public AssessmentMethod withId(BigInteger value) {
        this.setId(value);
        return this;
    }

    @Override
    public AssessmentMethod withAssessmentCheck(AssessmentCheck value) {
        this.setAssessmentCheck(value);
        return this;
    }

    @Override
    public AssessmentMethod withAssessmentEngines(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getAssessmentEngines().add(value);
            }
        }
        return this;
    }

    @Override
    public AssessmentMethod withAssessmentEngines(Collection<String> values) {
        if (values != null) {
            this.getAssessmentEngines().addAll(values);
        }
        return this;
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        BigInteger theId = this.getId();
        strategy.appendField(locator, (Object)this, "id", buffer, (Object)theId);
        return buffer;
    }

    @Override
    public Document toDocument() {
        return this.toDocument(false);
    }

    @Override
    public Document toDocument(boolean prettyPrint) {
        return DocumentUtilities.toDocument(this.toJAXBElement(), prettyPrint);
    }

    @Override
    public JAXBElement<?> toJAXBElement() {
        QName qualifiedName = STIXSchema.getQualifiedName(this);
        return new JAXBElement(qualifiedName, AssessmentMethod.class, (Object)this);
    }

    @Override
    public String toXMLString() {
        return this.toXMLString(false);
    }

    @Override
    public String toXMLString(boolean prettyPrint) {
        return DocumentUtilities.toXMLString(this.toDocument(), prettyPrint);
    }

    public static AssessmentMethod fromXMLString(String text) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)AssessmentMethod.class.getPackage().getName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(STIXSchema.getInstance().getSchema());
            unmarshaller.setEventHandler((javax.xml.bind.ValidationEventHandler)new ValidationEventHandler());
            StreamSource streamSource = new StreamSource(new StringReader(text));
            return (AssessmentMethod)unmarshaller.unmarshal((Source)streamSource);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean validate() throws SAXException {
        return STIXSchema.getInstance().validate(this.toXMLString());
    }
}

