/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl;

public class SHA3 {
    private long length;
    private int rate;
    private int len;
    private long[][] S = new long[5][5];
    public static final int HASH224 = 28;
    public static final int HASH256 = 32;
    public static final int HASH384 = 48;
    public static final int HASH512 = 64;
    public static final int SHAKE128 = 16;
    public static final int SHAKE256 = 32;
    public static final long[] RC = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
    private static final int ROUNDS = 24;

    public SHA3(int olen) {
        this.init(olen);
    }

    private static long rotl(long x, int n) {
        return x << n | x >>> 64 - n;
    }

    private void transform() {
        long[] C = new long[5];
        long[] D = new long[5];
        long[][] B = new long[5][5];
        for (int k = 0; k < 24; ++k) {
            int j;
            int i;
            C[0] = this.S[0][0] ^ this.S[0][1] ^ this.S[0][2] ^ this.S[0][3] ^ this.S[0][4];
            C[1] = this.S[1][0] ^ this.S[1][1] ^ this.S[1][2] ^ this.S[1][3] ^ this.S[1][4];
            C[2] = this.S[2][0] ^ this.S[2][1] ^ this.S[2][2] ^ this.S[2][3] ^ this.S[2][4];
            C[3] = this.S[3][0] ^ this.S[3][1] ^ this.S[3][2] ^ this.S[3][3] ^ this.S[3][4];
            C[4] = this.S[4][0] ^ this.S[4][1] ^ this.S[4][2] ^ this.S[4][3] ^ this.S[4][4];
            D[0] = C[4] ^ SHA3.rotl(C[1], 1);
            D[1] = C[0] ^ SHA3.rotl(C[2], 1);
            D[2] = C[1] ^ SHA3.rotl(C[3], 1);
            D[3] = C[2] ^ SHA3.rotl(C[4], 1);
            D[4] = C[3] ^ SHA3.rotl(C[0], 1);
            for (i = 0; i < 5; ++i) {
                j = 0;
                while (j < 5) {
                    long[] lArray = this.S[i];
                    int n = j++;
                    lArray[n] = lArray[n] ^ D[i];
                }
            }
            B[0][0] = this.S[0][0];
            B[1][3] = SHA3.rotl(this.S[0][1], 36);
            B[2][1] = SHA3.rotl(this.S[0][2], 3);
            B[3][4] = SHA3.rotl(this.S[0][3], 41);
            B[4][2] = SHA3.rotl(this.S[0][4], 18);
            B[0][2] = SHA3.rotl(this.S[1][0], 1);
            B[1][0] = SHA3.rotl(this.S[1][1], 44);
            B[2][3] = SHA3.rotl(this.S[1][2], 10);
            B[3][1] = SHA3.rotl(this.S[1][3], 45);
            B[4][4] = SHA3.rotl(this.S[1][4], 2);
            B[0][4] = SHA3.rotl(this.S[2][0], 62);
            B[1][2] = SHA3.rotl(this.S[2][1], 6);
            B[2][0] = SHA3.rotl(this.S[2][2], 43);
            B[3][3] = SHA3.rotl(this.S[2][3], 15);
            B[4][1] = SHA3.rotl(this.S[2][4], 61);
            B[0][1] = SHA3.rotl(this.S[3][0], 28);
            B[1][4] = SHA3.rotl(this.S[3][1], 55);
            B[2][2] = SHA3.rotl(this.S[3][2], 25);
            B[3][0] = SHA3.rotl(this.S[3][3], 21);
            B[4][3] = SHA3.rotl(this.S[3][4], 56);
            B[0][3] = SHA3.rotl(this.S[4][0], 27);
            B[1][1] = SHA3.rotl(this.S[4][1], 20);
            B[2][4] = SHA3.rotl(this.S[4][2], 39);
            B[3][2] = SHA3.rotl(this.S[4][3], 8);
            B[4][0] = SHA3.rotl(this.S[4][4], 14);
            for (i = 0; i < 5; ++i) {
                for (j = 0; j < 5; ++j) {
                    this.S[i][j] = B[i][j] ^ (B[(i + 1) % 5][j] ^ 0xFFFFFFFFFFFFFFFFL) & B[(i + 2) % 5][j];
                }
            }
            long[] lArray = this.S[0];
            lArray[0] = lArray[0] ^ RC[k];
        }
    }

    public void init(int olen) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.S[i][j] = 0L;
            }
        }
        this.length = 0L;
        this.len = olen;
        this.rate = 200 - 2 * olen;
    }

    public void process(int byt) {
        int cnt = (int)(this.length % (long)this.rate);
        int b = cnt % 8;
        int i = (cnt /= 8) % 5;
        int j = cnt / 5;
        long[] lArray = this.S[i];
        int n = j;
        lArray[n] = lArray[n] ^ (long)(byt & 0xFF) << 8 * b;
        ++this.length;
        if (this.length % (long)this.rate == 0L) {
            this.transform();
        }
    }

    public byte[] squeeze(byte[] buff, int olen) {
        int m = 0;
        boolean done = false;
        while (true) {
            for (int j = 0; j < 5; ++j) {
                for (int i = 0; i < 5; ++i) {
                    long el = this.S[i][j];
                    for (int k = 0; k < 8; ++k) {
                        buff[m++] = (byte)(el & 0xFFL);
                        if (m >= olen || m % this.rate == 0) {
                            done = true;
                            break;
                        }
                        el >>>= 8;
                    }
                    if (done) break;
                }
                if (done) break;
            }
            if (m >= olen) break;
            done = false;
            this.transform();
        }
        return buff;
    }

    public void hash(byte[] digest) {
        int q = this.rate - (int)(this.length % (long)this.rate);
        if (q == 1) {
            this.process(134);
        } else {
            this.process(6);
            while (this.length % (long)this.rate != (long)(this.rate - 1)) {
                this.process(0);
            }
            this.process(128);
        }
        this.squeeze(digest, this.len);
    }

    public void shake(byte[] digest, int olen) {
        int q = this.rate - (int)(this.length % (long)this.rate);
        if (q == 1) {
            this.process(159);
        } else {
            this.process(31);
            while (this.length % (long)this.rate != (long)(this.rate - 1)) {
                this.process(0);
            }
            this.process(128);
        }
        this.squeeze(digest, olen);
    }
}

