/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.RSA2048;

import org.apache.milagro.amcl.RAND;
import org.apache.milagro.amcl.RSA2048.BIG;
import org.apache.milagro.amcl.RSA2048.DBIG;

public final class FF {
    public static final int FFLEN = 2;
    public static final int FF_BITS = 2048;
    public static final int HFLEN = 1;
    public static final int P_MBITS = 1024;
    public static final int P_TBITS = 38;
    private final BIG[] v;
    private final int length;
    public static final long P_OMASK = -274877906944L;
    public static final long P_FEXCESS = 524288L;

    public static long EXCESS(BIG a) {
        return ((a.get(17) & 0xFFFFFFC000000000L) >> 38) + 1L;
    }

    public static boolean pexceed(BIG a, BIG b) {
        long eb;
        long ea = FF.EXCESS(a);
        return ea + 1L > 524288L / ((eb = FF.EXCESS(b)) + 1L);
    }

    public static boolean sexceed(BIG a) {
        long ea = FF.EXCESS(a);
        return ea + 1L > 524288L / (ea + 1L);
    }

    public FF(int n) {
        this.v = new BIG[n];
        for (int i = 0; i < n; ++i) {
            this.v[i] = new BIG(0);
        }
        this.length = n;
    }

    public int getlen() {
        return this.length;
    }

    public void set(int m) {
        this.zero();
        this.v[0].set(0, (long)m & 0x3FFFFFFFFFFFFFFL);
        this.v[0].set(1, m >> 58);
    }

    public void copy(FF b) {
        for (int i = 0; i < this.length; ++i) {
            this.v[i].copy(b.v[i]);
        }
    }

    public void dsucopy(FF b) {
        for (int i = 0; i < b.length; ++i) {
            this.v[b.length + i].copy(b.v[i]);
            this.v[i].zero();
        }
    }

    public void dscopy(FF b) {
        for (int i = 0; i < b.length; ++i) {
            this.v[i].copy(b.v[i]);
            this.v[b.length + i].zero();
        }
    }

    public void sducopy(FF b) {
        for (int i = 0; i < this.length; ++i) {
            this.v[i].copy(b.v[this.length + i]);
        }
    }

    public void zero() {
        for (int i = 0; i < this.length; ++i) {
            this.v[i].zero();
        }
    }

    public void one() {
        this.v[0].one();
        for (int i = 1; i < this.length; ++i) {
            this.v[i].zero();
        }
    }

    public boolean iszilch() {
        for (int i = 0; i < this.length; ++i) {
            if (this.v[i].iszilch()) continue;
            return false;
        }
        return true;
    }

    public void shrw(int n) {
        for (int i = 0; i < n; ++i) {
            this.v[i].copy(this.v[i + n]);
            this.v[i + n].zero();
        }
    }

    public void shlw(int n) {
        for (int i = 0; i < n; ++i) {
            this.v[n + i].copy(this.v[i]);
            this.v[i].zero();
        }
    }

    public int parity() {
        return this.v[0].parity();
    }

    public int lastbits(int m) {
        return this.v[0].lastbits(m);
    }

    public static int comp(FF a, FF b) {
        for (int i = a.length - 1; i >= 0; --i) {
            int j = BIG.comp(a.v[i], b.v[i]);
            if (j == 0) continue;
            return j;
        }
        return 0;
    }

    public void radd(int vp, FF x, int xp, FF y, int yp, int n) {
        for (int i = 0; i < n; ++i) {
            this.v[vp + i].copy(x.v[xp + i]);
            this.v[vp + i].add(y.v[yp + i]);
        }
    }

    public void rinc(int vp, FF y, int yp, int n) {
        for (int i = 0; i < n; ++i) {
            this.v[vp + i].add(y.v[yp + i]);
        }
    }

    public void rsub(int vp, FF x, int xp, FF y, int yp, int n) {
        for (int i = 0; i < n; ++i) {
            this.v[vp + i].copy(x.v[xp + i]);
            this.v[vp + i].sub(y.v[yp + i]);
        }
    }

    public void rdec(int vp, FF y, int yp, int n) {
        for (int i = 0; i < n; ++i) {
            this.v[vp + i].sub(y.v[yp + i]);
        }
    }

    public void add(FF b) {
        for (int i = 0; i < this.length; ++i) {
            this.v[i].add(b.v[i]);
        }
    }

    public void sub(FF b) {
        for (int i = 0; i < this.length; ++i) {
            this.v[i].sub(b.v[i]);
        }
    }

    public void revsub(FF b) {
        for (int i = 0; i < this.length; ++i) {
            this.v[i].rsub(b.v[i]);
        }
    }

    public void inc(int m) {
        this.v[0].inc(m);
        this.norm();
    }

    public void dec(int m) {
        this.v[0].dec(m);
        this.norm();
    }

    private void rnorm(int vp, int n) {
        long carry;
        boolean trunc = false;
        if (n < 0) {
            n = -n;
            trunc = true;
        }
        for (int i = 0; i < n - 1; ++i) {
            carry = this.v[vp + i].norm();
            this.v[vp + i].xortop(carry << 38);
            this.v[vp + i + 1].incl(carry);
        }
        carry = this.v[vp + n - 1].norm();
        if (trunc) {
            this.v[vp + n - 1].xortop(carry << 38);
        }
    }

    public void norm() {
        this.rnorm(0, this.length);
    }

    public void shl() {
        int delay_carry = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            int carry = this.v[i].fshl(1);
            this.v[i].inc(delay_carry);
            this.v[i].xortop((long)carry << 38);
            delay_carry = carry;
        }
        this.v[this.length - 1].fshl(1);
        this.v[this.length - 1].inc(delay_carry);
    }

    public void shr() {
        for (int i = this.length - 1; i > 0; --i) {
            int carry = this.v[i].fshr(1);
            this.v[i - 1].xortop((long)carry << 38);
        }
        this.v[0].fshr(1);
    }

    public String toString() {
        this.norm();
        String s = "";
        for (int i = this.length - 1; i >= 0; --i) {
            s = s + this.v[i].toString();
        }
        return s;
    }

    public void toBytes(byte[] b) {
        for (int i = 0; i < this.length; ++i) {
            this.v[i].tobytearray(b, (this.length - i - 1) * 128);
        }
    }

    public static void fromBytes(FF x, byte[] b) {
        for (int i = 0; i < x.length; ++i) {
            x.v[i] = BIG.frombytearray(b, (x.length - i - 1) * 128);
        }
    }

    private static void cswap(FF a, FF b, int d) {
        for (int i = 0; i < a.length; ++i) {
            a.v[i].cswap(b.v[i], d);
        }
    }

    private void karmul(int vp, FF x, int xp, FF y, int yp, FF t, int tp, int n) {
        if (n == 1) {
            x.v[xp].norm();
            y.v[yp].norm();
            DBIG d = BIG.mul(x.v[xp], y.v[yp]);
            this.v[vp + 1] = d.split(1024);
            this.v[vp].copy(d);
            return;
        }
        int nd2 = n / 2;
        this.radd(vp, x, xp, x, xp + nd2, nd2);
        this.rnorm(vp, nd2);
        this.radd(vp + nd2, y, yp, y, yp + nd2, nd2);
        this.rnorm(vp + nd2, nd2);
        t.karmul(tp, this, vp, this, vp + nd2, t, tp + n, nd2);
        this.karmul(vp, x, xp, y, yp, t, tp + n, nd2);
        this.karmul(vp + n, x, xp + nd2, y, yp + nd2, t, tp + n, nd2);
        t.rdec(tp, this, vp, n);
        t.rdec(tp, this, vp + n, n);
        this.rinc(vp + nd2, t, tp, n);
        this.rnorm(vp, 2 * n);
    }

    private void karsqr(int vp, FF x, int xp, FF t, int tp, int n) {
        if (n == 1) {
            x.v[xp].norm();
            DBIG d = BIG.sqr(x.v[xp]);
            this.v[vp + 1].copy(d.split(1024));
            this.v[vp].copy(d);
            return;
        }
        int nd2 = n / 2;
        this.karsqr(vp, x, xp, t, tp + n, nd2);
        this.karsqr(vp + n, x, xp + nd2, t, tp + n, nd2);
        t.karmul(tp, x, xp, x, xp + nd2, t, tp + n, nd2);
        this.rinc(vp + nd2, t, tp, n);
        this.rinc(vp + nd2, t, tp, n);
        this.rnorm(vp + nd2, n);
    }

    private void karmul_lower(int vp, FF x, int xp, FF y, int yp, FF t, int tp, int n) {
        if (n == 1) {
            this.v[vp].copy(BIG.smul(x.v[xp], y.v[yp]));
            return;
        }
        int nd2 = n / 2;
        this.karmul(vp, x, xp, y, yp, t, tp + n, nd2);
        t.karmul_lower(tp, x, xp + nd2, y, yp, t, tp + n, nd2);
        this.rinc(vp + nd2, t, tp, nd2);
        t.karmul_lower(tp, x, xp, y, yp + nd2, t, tp + n, nd2);
        this.rinc(vp + nd2, t, tp, nd2);
        this.rnorm(vp + nd2, -nd2);
    }

    private void karmul_upper(FF x, FF y, FF t, int n) {
        int nd2 = n / 2;
        this.radd(n, x, 0, x, nd2, nd2);
        this.radd(n + nd2, y, 0, y, nd2, nd2);
        this.rnorm(n, nd2);
        this.rnorm(n + nd2, nd2);
        t.karmul(0, this, n + nd2, this, n, t, n, nd2);
        this.karmul(n, x, nd2, y, nd2, t, n, nd2);
        t.rdec(0, this, n, n);
        this.rinc(nd2, this, 0, nd2);
        this.rdec(nd2, t, 0, nd2);
        this.rnorm(0, -n);
        t.rdec(0, this, 0, n);
        this.rinc(nd2, t, 0, n);
        this.rnorm(nd2, n);
    }

    public static FF mul(FF x, FF y) {
        int n = x.length;
        FF z = new FF(2 * n);
        FF t = new FF(2 * n);
        z.karmul(0, x, 0, y, 0, t, 0, n);
        return z;
    }

    public static FF sqr(FF x) {
        int n = x.length;
        FF z = new FF(2 * n);
        FF t = new FF(2 * n);
        z.karsqr(0, x, 0, t, 0, n);
        return z;
    }

    public void lmul(FF y) {
        int n = this.length;
        FF t = new FF(2 * n);
        FF x = new FF(n);
        x.copy(this);
        this.karmul_lower(0, x, 0, y, 0, t, 0, n);
    }

    public void mod(FF c) {
        int k = 0;
        this.norm();
        if (FF.comp(this, c) < 0) {
            return;
        }
        do {
            c.shl();
            ++k;
        } while (FF.comp(this, c) >= 0);
        while (k > 0) {
            c.shr();
            if (FF.comp(this, c) >= 0) {
                this.sub(c);
                this.norm();
            }
            --k;
        }
    }

    public FF reduce(FF N, FF ND) {
        int n = N.length;
        FF t = new FF(2 * n);
        FF r = new FF(n);
        FF m = new FF(n);
        r.sducopy(this);
        m.karmul_lower(0, this, 0, ND, 0, t, 0, n);
        this.karmul_upper(N, m, t, n);
        m.sducopy(this);
        r.add(N);
        r.sub(m);
        r.norm();
        return r;
    }

    public FF dmod(FF b) {
        int n = b.length;
        FF m = new FF(2 * n);
        FF x = new FF(2 * n);
        FF r = new FF(n);
        x.copy(this);
        x.norm();
        m.dsucopy(b);
        int k = 1024 * n;
        while (FF.comp(x, m) >= 0) {
            x.sub(m);
            x.norm();
        }
        while (k > 0) {
            m.shr();
            if (FF.comp(x, m) >= 0) {
                x.sub(m);
                x.norm();
            }
            --k;
        }
        r.copy(x);
        r.mod(b);
        return r;
    }

    public void invmodp(FF p) {
        int n = p.length;
        FF u = new FF(n);
        FF v = new FF(n);
        FF x1 = new FF(n);
        FF x2 = new FF(n);
        FF t = new FF(n);
        FF one = new FF(n);
        one.one();
        u.copy(this);
        v.copy(p);
        x1.copy(one);
        x2.zero();
        while (FF.comp(u, one) != 0 && FF.comp(v, one) != 0) {
            while (u.parity() == 0) {
                u.shr();
                if (x1.parity() != 0) {
                    x1.add(p);
                    x1.norm();
                }
                x1.shr();
            }
            while (v.parity() == 0) {
                v.shr();
                if (x2.parity() != 0) {
                    x2.add(p);
                    x2.norm();
                }
                x2.shr();
            }
            if (FF.comp(u, v) >= 0) {
                u.sub(v);
                u.norm();
                if (FF.comp(x1, x2) >= 0) {
                    x1.sub(x2);
                } else {
                    t.copy(p);
                    t.sub(x2);
                    x1.add(t);
                }
                x1.norm();
                continue;
            }
            v.sub(u);
            v.norm();
            if (FF.comp(x2, x1) >= 0) {
                x2.sub(x1);
            } else {
                t.copy(p);
                t.sub(x1);
                x2.add(t);
            }
            x2.norm();
        }
        if (FF.comp(u, one) == 0) {
            this.copy(x1);
        } else {
            this.copy(x2);
        }
    }

    public void nres(FF m) {
        int n = m.length;
        if (n == 1) {
            DBIG d = new DBIG(this.v[0]);
            d.shl(1044);
            this.v[0].copy(d.mod(m.v[0]));
        } else {
            FF d = new FF(2 * n);
            d.dsucopy(this);
            this.copy(d.dmod(m));
        }
    }

    public void redc(FF m, FF ND) {
        int n = m.length;
        if (n == 1) {
            DBIG d = new DBIG(this.v[0]);
            this.v[0].copy(BIG.monty(m.v[0], (BIG.cast_to_chunk(1) << 58) - ND.v[0].w[0], d));
        } else {
            FF d = new FF(2 * n);
            this.mod(m);
            d.dscopy(this);
            this.copy(d.reduce(m, ND));
            this.mod(m);
        }
    }

    private void mod2m(int m) {
        for (int i = m; i < this.length; ++i) {
            this.v[i].zero();
        }
    }

    private FF invmod2m() {
        int n = this.length;
        FF b = new FF(n);
        FF c = new FF(n);
        FF U = new FF(n);
        U.zero();
        U.v[0].copy(this.v[0]);
        U.v[0].invmod2m();
        for (int i = 1; i < n; i <<= 1) {
            b.copy(this);
            b.mod2m(i);
            FF t = FF.mul(U, b);
            t.shrw(i);
            b.copy(t);
            c.copy(this);
            c.shrw(i);
            c.mod2m(i);
            c.lmul(U);
            c.mod2m(i);
            b.add(c);
            b.norm();
            b.lmul(U);
            b.mod2m(i);
            c.one();
            c.shlw(i);
            b.revsub(c);
            b.norm();
            b.shlw(i);
            U.add(b);
        }
        U.norm();
        return U;
    }

    public void random(RAND rng) {
        int n = this.length;
        for (int i = 0; i < n; ++i) {
            this.v[i].copy(BIG.random(rng));
        }
        while (this.v[n - 1].nbits() < 1024) {
            this.v[n - 1].copy(BIG.random(rng));
        }
    }

    public void randomnum(FF p, RAND rng) {
        int n = this.length;
        FF d = new FF(2 * n);
        for (int i = 0; i < 2 * n; ++i) {
            d.v[i].copy(BIG.random(rng));
        }
        this.copy(d.dmod(p));
    }

    public void modmul(FF y, FF p, FF nd) {
        int n;
        if (FF.pexceed(this.v[this.length - 1], y.v[y.length - 1])) {
            this.mod(p);
        }
        if ((n = p.length) == 1) {
            DBIG d = BIG.mul(this.v[0], y.v[0]);
            this.v[0].copy(BIG.monty(p.v[0], (BIG.cast_to_chunk(1) << 58) - nd.v[0].w[0], d));
        } else {
            FF d = FF.mul(this, y);
            this.copy(d.reduce(p, nd));
        }
    }

    public void modsqr(FF p, FF nd) {
        int n;
        if (FF.sexceed(this.v[this.length - 1])) {
            this.mod(p);
        }
        if ((n = p.length) == 1) {
            DBIG d = BIG.sqr(this.v[0]);
            this.v[0].copy(BIG.monty(p.v[0], (BIG.cast_to_chunk(1) << 58) - nd.v[0].w[0], d));
        } else {
            FF d = FF.sqr(this);
            this.copy(d.reduce(p, nd));
        }
    }

    public void skpow(FF e, FF p) {
        int n = p.length;
        FF R0 = new FF(n);
        FF R1 = new FF(n);
        FF ND = p.invmod2m();
        this.mod(p);
        R0.one();
        R1.copy(this);
        R0.nres(p);
        R1.nres(p);
        for (int i = 1024 * n - 1; i >= 0; --i) {
            int b = e.v[i / 1024].bit(i % 1024);
            this.copy(R0);
            this.modmul(R1, p, ND);
            FF.cswap(R0, R1, b);
            R0.modsqr(p, ND);
            R1.copy(this);
            FF.cswap(R0, R1, b);
        }
        this.copy(R0);
        this.redc(p, ND);
    }

    public void skpow(BIG e, FF p) {
        int n = p.length;
        FF R0 = new FF(n);
        FF R1 = new FF(n);
        FF ND = p.invmod2m();
        this.mod(p);
        R0.one();
        R1.copy(this);
        R0.nres(p);
        R1.nres(p);
        for (int i = 1023; i >= 0; --i) {
            int b = e.bit(i);
            this.copy(R0);
            this.modmul(R1, p, ND);
            FF.cswap(R0, R1, b);
            R0.modsqr(p, ND);
            R1.copy(this);
            FF.cswap(R0, R1, b);
        }
        this.copy(R0);
        this.redc(p, ND);
    }

    public void power(int e, FF p) {
        int n = p.length;
        FF w = new FF(n);
        FF ND = p.invmod2m();
        boolean f = true;
        w.copy(this);
        w.nres(p);
        if (e == 2) {
            this.copy(w);
            this.modsqr(p, ND);
        } else {
            while (true) {
                if (e % 2 == 1) {
                    if (f) {
                        this.copy(w);
                    } else {
                        this.modmul(w, p, ND);
                    }
                    f = false;
                }
                if ((e >>= 1) == 0) break;
                w.modsqr(p, ND);
            }
        }
        this.redc(p, ND);
    }

    public void pow(FF e, FF p) {
        int n = p.length;
        FF w = new FF(n);
        FF ND = p.invmod2m();
        w.copy(this);
        this.one();
        this.nres(p);
        w.nres(p);
        for (int i = 1024 * n - 1; i >= 0; --i) {
            this.modsqr(p, ND);
            int b = e.v[i / 1024].bit(i % 1024);
            if (b != 1) continue;
            this.modmul(w, p, ND);
        }
        this.redc(p, ND);
    }

    public void pow2(BIG e, FF y, BIG f, FF p) {
        int n = p.length;
        FF xn = new FF(n);
        FF yn = new FF(n);
        FF xy = new FF(n);
        FF ND = p.invmod2m();
        xn.copy(this);
        yn.copy(y);
        xn.nres(p);
        yn.nres(p);
        xy.copy(xn);
        xy.modmul(yn, p, ND);
        this.one();
        this.nres(p);
        for (int i = 1023; i >= 0; --i) {
            int eb = e.bit(i);
            int fb = f.bit(i);
            this.modsqr(p, ND);
            if (eb == 1) {
                if (fb == 1) {
                    this.modmul(xy, p, ND);
                    continue;
                }
                this.modmul(xn, p, ND);
                continue;
            }
            if (fb != 1) continue;
            this.modmul(yn, p, ND);
        }
        this.redc(p, ND);
    }

    private static int igcd(int x, int y) {
        int r;
        if (y == 0) {
            return x;
        }
        while ((r = x % y) != 0) {
            x = y;
            y = r;
        }
        return y;
    }

    public boolean cfactor(int s) {
        int n = this.length;
        FF x = new FF(n);
        FF y = new FF(n);
        y.set(s);
        x.copy(this);
        x.norm();
        do {
            x.sub(y);
            x.norm();
            while (!x.iszilch() && x.parity() == 0) {
                x.shr();
            }
        } while (FF.comp(x, y) > 0);
        int g = (int)x.v[0].get(0);
        int r = FF.igcd(s, g);
        return r > 1;
    }

    public static boolean prime(FF p, RAND rng) {
        int s = 0;
        int n = p.length;
        FF d = new FF(n);
        FF x = new FF(n);
        FF unity = new FF(n);
        FF nm1 = new FF(n);
        int sf = 4849845;
        p.norm();
        if (p.cfactor(sf)) {
            return false;
        }
        unity.one();
        nm1.copy(p);
        nm1.sub(unity);
        nm1.norm();
        d.copy(nm1);
        while (d.parity() == 0) {
            d.shr();
            ++s;
        }
        if (s == 0) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            x.randomnum(p, rng);
            x.pow(d, p);
            if (FF.comp(x, unity) == 0 || FF.comp(x, nm1) == 0) continue;
            boolean loop = false;
            for (int j = 1; j < s; ++j) {
                x.power(2, p);
                if (FF.comp(x, unity) == 0) {
                    return false;
                }
                if (FF.comp(x, nm1) != 0) continue;
                loop = true;
                break;
            }
            if (loop) continue;
            return false;
        }
        return true;
    }
}

